(function(d1Utilities,undefined){const block=d1Utilities;block.toggleElement=function(button,element,open){try{if(element!==null&&button!==null){button.setAttribute("aria-expanded",!open);element.setAttribute("aria-hidden",open);}}catch(e){console.log("Error toggling the search");console.log(e);}};block.throttle=function throttle(fn,wait){var time=Date.now();return function(){if((time+wait-Date.now())<0){fn();time=Date.now();}}};block.isMobile=function(){var mobileDesktopBreakpoint=699||700;var winWidth=window.innerWidth||document.documentElement.clientWidth;if(winWidth<mobileDesktopBreakpoint){return true}else{return false}};block.isSafari=function(){if(navigator.userAgent.search("Safari")>=0&&navigator.userAgent.search("Chrome")<0){return true}
return false}}(window.d1Utilities=window.d1Utilities||{}));try{(function(d1_globalHeader,undefined){var block=d1_globalHeader;const
tokenUrl="https://cn.dataone.org/portal/token",isMCUI=typeof MetacatUI!=='undefined',urlMCUI="https://search.dataone.org",baseUrl="https://dataone.org",subLinkTextSelector=".d1_menu-item__sub-item-name",profileMenuSelector=".d1_menu-item--profile",signinMenuSelector=".d1_menu-item--sign-in",profileTextSelector=profileMenuSelector+" .d1_menu-item__top-item-name",menuLinksSelector=".d1_menu-item a",dropdownSelector=".d1_menu-item--dropdown",submenuSelector=".d1_menu-item__sub-menu";var lastScroll=0,closeDropdownTimeout=0;block.initialize=function(){selectElements();setListeners();if(getUserData()){updateProfileMenu()}
if(isMCUI){updateNavMetacatUI()}else{getToken()}}
const selectElements=function(){block.menuButton=document.getElementById("global-menu-toggle");block.menu=document.getElementById("global-menu");block.header=document.getElementById("nav");block.signin=document.querySelectorAll(signinMenuSelector);block.profile=document.querySelectorAll(profileMenuSelector);block.profileText=document.querySelectorAll(profileTextSelector);block.profileTerm=block.profileText[0].innerHTML;block.allMenuLinks=[];document.querySelectorAll(menuLinksSelector).forEach((link,i)=>{block.allMenuLinks[i]={el:link}});block.dropdownEls=[];document.querySelectorAll(dropdownSelector).forEach((container,i)=>{block.dropdownEls[i]={container:container,button:container.querySelector("button"),submenu:container.querySelector(submenuSelector)}});block.profileLinkEls=[];document.querySelectorAll(profileMenuSelector+" a").forEach((link,i)=>{const textEl=link.querySelector(subLinkTextSelector);block.profileLinkEls[i]={el:link,textEl:textEl,originalHref:link.getAttribute("href"),originalDisplay:link.style.display}});}
const getToken=function(){fetch(tokenUrl,{method:'GET',dataType:"text",credentials:'include'}).then(function(response){response.text().then(function(text){var userData;if(text){const parsedToken=parseToken(text);userData={loggedin:true,username:parsedToken.fullName,userId:parsedToken.userId||parsedToken.sub};}else{userData={loggedin:false,username:"",userId:""}}
if(getUserData()!=userData){saveUserData(userData);updateProfileMenu();}});}).catch(function(error){console.log("error fetching user data, error message:");console.log(error);});}
const parseToken=function(token){try{if(typeof token=="undefined")return "";var jws=new KJUR.jws.JWS();var result=0;try{result=jws.parseJWS(token);}catch(ex){result=0;}
if(!jws.parsedJWS)return "";return JSON.parse(jws.parsedJWS.payloadS);}catch(e){console.log("Error parsing token, error message: ");console.log(e);}}
const updateNavMetacatUI=function(){block.allMenuLinks.forEach((link,i)=>{link.el.href=link.el.href.replace(urlMCUI,"");})
userData={loggedin:MetacatUI.appUserModel.get("loggedIn"),username:MetacatUI.appUserModel.get('fullName')?MetacatUI.appUserModel.get('fullName').charAt(0).toUpperCase()+MetacatUI.appUserModel.get("fullName").substring(1):MetacatUI.appUserModel.get("username"),userId:MetacatUI.appUserModel.get('username')}
if(getUserData()!=userData){saveUserData(userData);updateProfileMenu();}}
const getUserData=function(){const storedData=localStorage.getItem("userData");if(storedData){return JSON.parse(storedData);}else{return false}}
const saveUserData=function(data){if(data){if(!(typeof data==='string'||data instanceof String)){data=JSON.stringify(data)}
localStorage.setItem("userData",data);}}
const resetProfileMenu=function(){block.profileText.forEach((el,i)=>{el.innerHTML=block.profileTerm;});block.signin.forEach((el,i)=>{showMenu(el);});block.profile.forEach((el,i)=>{hideMenu(el);});if(!block.profileLinkEls){return}
block.profileLinkEls.forEach((link,i)=>{link.el.href=link.originalHref;link.el.style.display=link.originalDisplay;});}
const updateProfileMenu=function(){if(!block.profile){console.warn("Couldn't update profile menu in the navigation bar because the menu element was missing.");return}
resetProfileMenu();const data=getUserData();if(!data){console.warn("Couldn't update profile menu in the navigation bar because the user data was missing.");return}
if(data.loggedin){if(data.username){block.profileText.forEach((el,i)=>{el.innerHTML=data.username});}
block.signin.forEach((el,i)=>{hideMenu(el);});block.profile.forEach((el,i)=>{showMenu(el);});block.profileLinkEls.forEach((link,i)=>{const baseProfileUrl=isMCUI?"":urlMCUI;link.el.href=link.el.href.replace(/USERNAME/,data.userId).replace(/^.*?SEARCH/,baseProfileUrl);});}}
const showMenu=function(menuEl){if(!menuEl)return;menuEl.style.display="block";}
const hideMenu=function(menuEl){if(!menuEl)return;menuEl.style.display="none";}
const closeAllDropdowns=function(){if(block.dropdownEls){block.dropdownEls.forEach(els=>{d1Utilities.toggleElement(els.button,els.submenu,true);});}}
const startCloseTimeout=function(){closeDropdownTimeout=setTimeout(()=>closeAllDropdowns(),70);}
const stopCloseTimeout=function(){clearTimeout(closeDropdownTimeout);};const dropdownMouseenter=function(els){if(!d1Utilities.isMobile()){stopCloseTimeout();closeAllDropdowns();d1Utilities.toggleElement(els.button,els.submenu,false);}}
const dropdownMouseleave=function(){if(!d1Utilities.isMobile()){startCloseTimeout()}}
const dropdownClick=function(els){if(d1Utilities.isMobile()){var open=JSON.parse(els.button.getAttribute("aria-expanded"));closeAllDropdowns();d1Utilities.toggleElement(els.button,els.submenu,open);}}
const menuButtonClick=function(){if(d1Utilities.isMobile()){var open=JSON.parse(block.menuButton.getAttribute("aria-expanded"));d1Utilities.toggleElement(block.menuButton,block.menu,open);closeAllDropdowns();}};block.toggleHeader=function(){if(!block.header||!d1Utilities.isMobile()){return}
const currentScroll=window.pageYOffset;var currentScrollPos=window.pageYOffset;if(currentScroll==0){block.header.style.bottom="0";return}
if(currentScroll>lastScroll){block.header.style.bottom="-63px";d1Utilities.toggleElement(block.menuButton,block.menu,true);}else if(currentScroll<lastScroll){block.header.style.bottom="0";}
lastScroll=currentScrollPos;}
const setListeners=function(){window.removeEventListener("load",function(e){if(!d1Utilities.isMobile()){d1Utilities.toggleElement(block.menuButton,block.menu,false)}},false);window.addEventListener("load",function(e){if(!d1Utilities.isMobile()){d1Utilities.toggleElement(block.menuButton,block.menu,false)}},false);window.addEventListener("scroll",d1Utilities.throttle(block.toggleHeader,100));block.dropdownEls.forEach(els=>{els.container.removeEventListener("mouseenter",function(){dropdownMouseenter(els)},false);els.container.addEventListener("mouseenter",function(){dropdownMouseenter(els)},false);els.container.removeEventListener("mouseleave",function(){dropdownMouseleave(els)},false);els.container.addEventListener("mouseleave",function(){dropdownMouseleave(els)},false);els.container.removeEventListener("click",function(){dropdownClick(els)},false);els.container.addEventListener("click",function(){dropdownClick(els)},false);});if(block.menu!==null&&block.menuButton!==null){block.menuButton.removeEventListener("click",menuButtonClick);block.menuButton.addEventListener("click",menuButtonClick);}}}(window.d1_globalHeader=window.d1_globalHeader||{}));}catch(e){console.log('error in: themes/dataone/layouts/partials/blocks/nav/nav.js, error message:'+e)}