/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class INLogEntry
implements LogEntry,
LoggableObject,
INContainingEntry {
    private IN in;
    private DatabaseId dbId;
    private Class logClass;

    public INLogEntry(Class logClass) {
        this.logClass = logClass;
    }

    public INLogEntry(IN in) {
        this.in = in;
        this.dbId = in.getDatabase().getId();
        this.logClass = in.getClass();
    }

    public void readEntry(ByteBuffer entryBuffer) throws DatabaseException {
        try {
            this.in = (IN)this.logClass.newInstance();
            this.in.readFromLog(entryBuffer);
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException(e);
        }
        catch (InstantiationException e) {
            throw new DatabaseException(e);
        }
    }

    public StringBuffer dumpEntry(StringBuffer sb, boolean verbose) {
        this.in.dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        return sb;
    }

    public Object getMainItem() {
        return this.in;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    public LogEntryType getLogType() {
        return this.in.getLogType();
    }

    public boolean marshallOutsideWriteLatch() {
        return this.in.marshallOutsideWriteLatch();
    }

    public void postLogWork(DbLsn justLoggedLsn) {
    }

    public int getLogSize() {
        return this.in.getLogSize() + this.dbId.getLogSize();
    }

    public void writeToLog(ByteBuffer destBuffer) {
        this.in.writeToLog(destBuffer);
        this.dbId.writeToLog(destBuffer);
    }

    public IN getIN(EnvironmentImpl env) throws DatabaseException {
        return this.in;
    }

    public DatabaseId getDbId() {
        return this.dbId;
    }

    public DbLsn getLsnOfIN(DbLsn lastReadLsn) {
        return lastReadLsn;
    }
}

