/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import java.util.Set;

public class StoredKeySet
extends StoredCollection
implements Set {
    public StoredKeySet(Database database, EntryBinding keyBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, null, null, writeAllowed, null));
    }

    StoredKeySet(DataView keySetView) {
        super(keySetView);
    }

    public boolean add(Object key) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.putNoOverwrite(key, null, false);
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean remove(Object key) {
        return this.removeKey(key, null);
    }

    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    boolean hasValues() {
        return false;
    }

    Object makeIteratorData(StoredIterator iterator, DataCursor cursor) throws DatabaseException {
        return cursor.getCurrentKey();
    }

    boolean iterateDuplicates() {
        return false;
    }
}

