/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.modify.TemplateLib;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.util.Iso;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Template {
    static final int HashTemplateGroup = 177;
    private final BasicPattern bgp;
    private int calcHashCode = -1;

    public Template(BasicPattern bgp) {
        this.bgp = bgp;
    }

    public BasicPattern getBGP() {
        return this.bgp;
    }

    public List<Triple> getTriples() {
        return this.bgp.getList();
    }

    public void subst(Collection<Triple> acc, Map<Node, Node> bNodeMap, Binding b) {
        for (Triple t : this.bgp.getList()) {
            t = TemplateLib.subst(t, b, bNodeMap);
            acc.add(t);
        }
    }

    public int hashCode() {
        int calcHashCode = 177;
        for (Triple t : this.bgp.getList()) {
            calcHashCode ^= Template.hash(t) ^ calcHashCode << 1;
        }
        return calcHashCode;
    }

    private static int hash(Triple triple) {
        int hash = 0;
        hash = Template.hashNode(triple.getSubject()) ^ hash << 1;
        hash = Template.hashNode(triple.getPredicate()) ^ hash << 1;
        hash = Template.hashNode(triple.getObject()) ^ hash << 1;
        return hash;
    }

    private static int hashNode(Node node) {
        if (node.isBlank()) {
            return 59;
        }
        return node.hashCode();
    }

    public boolean equalIso(Object temp2, NodeIsomorphismMap labelMap) {
        if (!(temp2 instanceof Template)) {
            return false;
        }
        Template tg2 = (Template)temp2;
        List<Triple> list1 = this.bgp.getList();
        List<Triple> list2 = tg2.bgp.getList();
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            Triple t1 = list1.get(i);
            Triple t2 = list2.get(i);
            Iso.tripleIso(t1, t2, labelMap);
        }
        return true;
    }

    public void format(FormatterTemplate fmtTemplate) {
        fmtTemplate.format(this);
    }
}

