/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.IOService;
import com.hazelcast.util.Clock;
import java.util.logging.Level;

class ConnectionMonitor {
    final ILogger logger;
    final ConnectionManager connectionManager;
    final IOService ioService;
    final Address endPoint;
    final long minInterval;
    final int maxFaults;
    int faults = 0;
    long lastFaultTime = 0L;

    public ConnectionMonitor(ConnectionManager connectionManager, Address endPoint) {
        this.connectionManager = connectionManager;
        this.endPoint = endPoint;
        this.ioService = connectionManager.getIOHandler();
        this.minInterval = this.ioService.getConnectionMonitorInterval();
        this.maxFaults = this.ioService.getConnectionMonitorMaxFaults();
        this.logger = this.ioService.getLogger(this.getClass().getName());
    }

    public Address getEndPoint() {
        return this.endPoint;
    }

    public synchronized void onError(Throwable t) {
        String errorMessage = "An error occurred on connection to " + this.endPoint + this.getCauseDescription(t);
        this.logger.log(Level.FINEST, errorMessage);
        this.ioService.getSystemLogService().logConnection(errorMessage);
        long now = Clock.currentTimeMillis();
        long last = this.lastFaultTime;
        if (now - last > this.minInterval) {
            if (this.faults++ >= this.maxFaults) {
                String removeEndpointMessage = "Removing connection to endpoint " + this.endPoint + this.getCauseDescription(t);
                this.logger.log(Level.WARNING, removeEndpointMessage);
                this.ioService.getSystemLogService().logConnection(removeEndpointMessage);
                this.ioService.removeEndpoint(this.endPoint);
            }
            this.lastFaultTime = now;
        }
    }

    public synchronized void reset() {
        String resetMessage = "Resetting connection monitor for endpoint " + this.endPoint;
        this.logger.log(Level.FINEST, resetMessage);
        this.ioService.getSystemLogService().logConnection(resetMessage);
        this.faults = 0;
        this.lastFaultTime = 0L;
    }

    private String getCauseDescription(Throwable t) {
        StringBuilder s = new StringBuilder(" Cause => ");
        if (t != null) {
            s.append(t.getClass().getName()).append(" {").append(t.getMessage()).append("}");
        } else {
            s.append("Unknown");
        }
        return s.append(", Error-Count: ").append(this.faults + 1).toString();
    }
}

