/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.configuration;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import java.io.File;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class ConfigUtil {
    public static ConfigurationNode findConfiguration(String fileName, String configName, String topNodeTag) {
        if (fileName == null || fileName.length() == 0) {
            throw new MyConfigurationException("Error: No configuration file specified");
        }
        XMLConfiguration cfg = null;
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            throw new MyConfigurationException("Error: file \"" + file + "\" does not exist");
        }
        cfg = Configurations.getConfiguration((File)new File(fileName));
        return ConfigUtil.findNamedConfig(cfg, configName, topNodeTag);
    }

    protected static ConfigurationNode findNamedConfig(XMLConfiguration cfg, String cfgName, String topNodeTag) {
        ConfigurationNode cn = null;
        cn = cfgName == null ? cfg.configurationAt(topNodeTag).getRootNode() : Configurations.getConfig((XMLConfiguration)cfg, (String)topNodeTag, (String)cfgName);
        return cn;
    }
}

