/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.SystemARQ;
import org.apache.jena.atlas.event.Event;
import org.apache.jena.atlas.event.EventListener;
import org.apache.jena.atlas.event.EventManager;
import org.apache.jena.atlas.event.EventType;
import org.apache.jena.atlas.lib.Sink;

public class SinkTriplesToGraph
implements Sink<Triple> {
    static final EventType startRead = new EventType("SinkToGraph.StartRead");
    static final EventType finishRead = new EventType("SinkToGraph.FinishRead");
    protected final Graph graph;
    private EventListener el1;
    private EventListener el2;

    public SinkTriplesToGraph(boolean x, Graph g) {
        this.graph = g;
        this.el1 = new EventListener(){

            @Override
            public void event(Object dest, Event event) {
                SinkTriplesToGraph.this.graph.getEventManager().notifyEvent(SinkTriplesToGraph.this.graph, (Object)GraphEvents.startRead);
            }
        };
        this.el2 = new EventListener(){

            @Override
            public void event(Object dest, Event event) {
                SinkTriplesToGraph.this.graph.getEventManager().notifyEvent(SinkTriplesToGraph.this.graph, (Object)GraphEvents.finishRead);
            }
        };
        EventManager.register(this, startRead, this.el1);
        EventManager.register(this, finishRead, this.el2);
    }

    @Override
    public void send(Triple triple) {
        this.graph.add(triple);
    }

    @Override
    public void flush() {
        SystemARQ.sync(this.graph);
    }

    @Override
    public void close() {
        EventManager.unregister(this, finishRead, this.el2);
        EventManager.unregister(this, startRead, this.el1);
    }
}

