/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashSet;

public class OntPropertyImpl
extends OntResourceImpl
implements OntProperty {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new OntPropertyImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to OntProperty");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile;
            Profile profile2 = profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = OntPropertyImpl.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
        }
    };

    public OntPropertyImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public boolean isProperty() {
        return true;
    }

    public int getOrdinal() {
        return ((Property)this.as(Property.class)).getOrdinal();
    }

    public void setSuperProperty(Property prop) {
        this.setPropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", prop);
    }

    public void addSuperProperty(Property prop) {
        this.addPropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", prop);
    }

    public OntProperty getSuperProperty() {
        return this.objectAsProperty(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF");
    }

    public ExtendedIterator listSuperProperties() {
        return this.listSuperProperties(false);
    }

    public ExtendedIterator listSuperProperties(boolean direct) {
        return this.listDirectPropertyValues(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", OntProperty.class, this.getProfile().SUB_PROPERTY_OF(), direct, false);
    }

    public boolean hasSuperProperty(Property prop, boolean direct) {
        return this.hasPropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", prop);
    }

    public void removeSuperProperty(Property prop) {
        this.removePropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", prop);
    }

    public void setSubProperty(Property prop) {
        this.checkProfile(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF");
        StmtIterator i = this.getModel().listStatements(null, this.getProfile().SUB_PROPERTY_OF(), this);
        while (i.hasNext()) {
            i.removeNext();
        }
        ((OntProperty)prop.as(OntProperty.class)).addSuperProperty(this);
    }

    public void addSubProperty(Property prop) {
        ((OntProperty)prop.as(OntProperty.class)).addSuperProperty(this);
    }

    public OntProperty getSubProperty() {
        this.checkProfile(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF");
        return (OntProperty)this.getModel().listStatements(null, this.getProfile().SUB_PROPERTY_OF(), this).nextStatement().getSubject().as(OntProperty.class);
    }

    public ExtendedIterator listSubProperties() {
        return this.listSubProperties(false);
    }

    public ExtendedIterator listSubProperties(boolean direct) {
        return this.listDirectPropertyValues(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", OntProperty.class, this.getProfile().SUB_PROPERTY_OF(), direct, true);
    }

    public boolean hasSubProperty(Property prop, boolean direct) {
        return ((OntProperty)prop.as(OntProperty.class)).hasSuperProperty(this, direct);
    }

    public void removeSubProperty(Property prop) {
        ((OntProperty)prop.as(OntProperty.class)).removeSuperProperty(this);
    }

    public void setDomain(Resource res) {
        this.setPropertyValue(this.getProfile().DOMAIN(), "DOMAIN", res);
    }

    public void addDomain(Resource res) {
        this.addPropertyValue(this.getProfile().DOMAIN(), "DOMAIN", res);
    }

    public OntResource getDomain() {
        return this.objectAsResource(this.getProfile().DOMAIN(), "DOMAIN");
    }

    public ExtendedIterator listDomain() {
        return this.listAs(this.getProfile().DOMAIN(), "DOMAIN", OntClass.class);
    }

    public boolean hasDomain(Resource res) {
        return this.hasPropertyValue(this.getProfile().DOMAIN(), "DOMAIN", res);
    }

    public void removeDomain(Resource cls) {
        this.removePropertyValue(this.getProfile().DOMAIN(), "DOMAIN", cls);
    }

    public void setRange(Resource res) {
        this.setPropertyValue(this.getProfile().RANGE(), "RANGE", res);
    }

    public void addRange(Resource res) {
        this.addPropertyValue(this.getProfile().RANGE(), "RANGE", res);
    }

    public OntResource getRange() {
        return this.objectAsResource(this.getProfile().RANGE(), "RANGE");
    }

    public ExtendedIterator listRange() {
        return this.listAs(this.getProfile().RANGE(), "RANGE", OntClass.class);
    }

    public boolean hasRange(Resource res) {
        return this.hasPropertyValue(this.getProfile().RANGE(), "RANGE", res);
    }

    public void removeRange(Resource cls) {
        this.removePropertyValue(this.getProfile().RANGE(), "RANGE", cls);
    }

    public void setEquivalentProperty(Property prop) {
        this.setPropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", prop);
    }

    public void addEquivalentProperty(Property prop) {
        this.addPropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", prop);
    }

    public OntProperty getEquivalentProperty() {
        return this.objectAsProperty(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY");
    }

    public ExtendedIterator listEquivalentProperties() {
        return this.listAs(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", OntProperty.class);
    }

    public boolean hasEquivalentProperty(Property prop) {
        return this.hasPropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", prop);
    }

    public void removeEquivalentProperty(Property prop) {
        this.removePropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", prop);
    }

    public void setInverseOf(Property prop) {
        this.setPropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", prop);
    }

    public void addInverseOf(Property prop) {
        this.addPropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", prop);
    }

    public OntProperty getInverseOf() {
        return this.objectAsProperty(this.getProfile().INVERSE_OF(), "INVERSE_OF");
    }

    public ExtendedIterator listInverseOf() {
        return this.listAs(this.getProfile().INVERSE_OF(), "INVERSE_OF", OntProperty.class);
    }

    public boolean isInverseOf(Property prop) {
        return this.hasPropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", prop);
    }

    public void removeInverseProperty(Property prop) {
        this.removePropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", prop);
    }

    public FunctionalProperty asFunctionalProperty() {
        return (FunctionalProperty)this.as(FunctionalProperty.class);
    }

    public DatatypeProperty asDatatypeProperty() {
        return (DatatypeProperty)this.as(DatatypeProperty.class);
    }

    public ObjectProperty asObjectProperty() {
        return (ObjectProperty)this.as(ObjectProperty.class);
    }

    public TransitiveProperty asTransitiveProperty() {
        return (TransitiveProperty)this.as(TransitiveProperty.class);
    }

    public InverseFunctionalProperty asInverseFunctionalProperty() {
        return (InverseFunctionalProperty)this.as(InverseFunctionalProperty.class);
    }

    public SymmetricProperty asSymmetricProperty() {
        return (SymmetricProperty)this.as(SymmetricProperty.class);
    }

    public FunctionalProperty convertToFunctionalProperty() {
        return (FunctionalProperty)this.convertToType(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY", FunctionalProperty.class);
    }

    public DatatypeProperty convertToDatatypeProperty() {
        return (DatatypeProperty)this.convertToType(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY", DatatypeProperty.class);
    }

    public ObjectProperty convertToObjectProperty() {
        return (ObjectProperty)this.convertToType(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY", ObjectProperty.class);
    }

    public TransitiveProperty convertToTransitiveProperty() {
        return (TransitiveProperty)this.convertToType(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY", TransitiveProperty.class);
    }

    public InverseFunctionalProperty convertToInverseFunctionalProperty() {
        return (InverseFunctionalProperty)this.convertToType(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY", InverseFunctionalProperty.class);
    }

    public SymmetricProperty convertToSymmetricProperty() {
        return (SymmetricProperty)this.convertToType(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY", SymmetricProperty.class);
    }

    public boolean isFunctionalProperty() {
        return this.hasRDFType(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY", false);
    }

    public boolean isDatatypeProperty() {
        return this.hasRDFType(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY", false);
    }

    public boolean isObjectProperty() {
        return this.hasRDFType(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY", false);
    }

    public boolean isTransitiveProperty() {
        return this.hasRDFType(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY", false);
    }

    public boolean isInverseFunctionalProperty() {
        return this.hasRDFType(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY", false);
    }

    public boolean isSymmetricProperty() {
        return this.hasRDFType(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY", false);
    }

    public OntProperty getInverse() {
        ExtendedIterator i = this.listInverse();
        OntProperty p = i.hasNext() ? (OntProperty)i.next() : null;
        i.close();
        return p;
    }

    public ExtendedIterator listInverse() {
        return this.getModel().listStatements(null, this.getProfile().INVERSE_OF(), this).mapWith(new OntResourceImpl.SubjectAsMapper(OntProperty.class));
    }

    public boolean hasInverse() {
        ExtendedIterator i = this.listInverse();
        boolean hasInv = i.hasNext();
        i.close();
        return hasInv;
    }

    public ExtendedIterator listDeclaringClasses() {
        return this.listDeclaringClasses(false);
    }

    public ExtendedIterator listDeclaringClasses(boolean direct) {
        HashSet<OntClass> cands = new HashSet<OntClass>();
        ExtendedIterator i = this.listDomain();
        while (i.hasNext()) {
            ArrayList q = new ArrayList();
            q.add(i.next());
            while (!q.isEmpty()) {
                OntClass c = (OntClass)q.remove(0);
                if (c.isOntLanguageTerm() || cands.contains(c)) continue;
                cands.add(c);
                ExtendedIterator j = c.listSubClasses();
                while (j.hasNext()) {
                    q.add(j.next());
                }
            }
        }
        if (cands.isEmpty()) {
            if (!direct) {
                return ((OntModel)this.getModel()).listClasses().filterDrop(new Filter(){

                    public boolean accept(Object o) {
                        return ((OntClass)o).isOntLanguageTerm();
                    }
                });
            }
            return ((OntModel)this.getModel()).listHierarchyRootClasses();
        }
        return WrappedIterator.create(cands.iterator()).filterKeep(new FilterDeclaringClass(this, direct));
    }

    public ExtendedIterator listReferringRestrictions() {
        return this.getModel().listStatements(null, this.getProfile().ON_PROPERTY(), this).mapWith(new OntResourceImpl.SubjectAsMapper(Restriction.class));
    }

    public RDFNode inModel(Model m) {
        return this.getModel() == m ? this : m.createProperty(this.getURI());
    }

    private class FilterDeclaringClass
    extends Filter {
        private boolean m_direct;
        private Property m_prop;

        private FilterDeclaringClass(Property prop, boolean direct) {
            this.m_prop = prop;
            this.m_direct = direct;
        }

        public boolean accept(Object o) {
            return ((OntClass)o).hasDeclaredProperty(this.m_prop, this.m_direct);
        }
    }
}

