/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashMap;

public class HashMappedList
extends HashMap {
    public HashMappedList() {
        this(16, 0.75f);
    }

    public HashMappedList(int n) throws IllegalArgumentException {
        this(n, 0.75f);
    }

    public HashMappedList(int n, float f) throws IllegalArgumentException {
        super(n, f);
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.objectValueTable[n];
    }

    public Object remove(Object object) {
        int n = this.getLookup(object, object.hashCode());
        if (n < 0) {
            return null;
        }
        Object object2 = super.remove(object);
        this.removeRow(n);
        return object2;
    }

    public Object remove(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.remove(this.objectKeyTable[n]);
    }

    public boolean add(Object object, Object object2) {
        if (this.keySet().contains(object)) {
            return false;
        }
        super.put(object, object2);
        return true;
    }

    public Object put(Object object, Object object2) {
        return super.put(object, object2);
    }

    public Object set(int n, Object object) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object2 = this.objectKeyTable[n];
        this.objectKeyTable[n] = object;
        return object2;
    }

    public boolean set(int n, Object object, Object object2) throws IndexOutOfBoundsException {
        this.checkRange(n);
        if (this.keySet().contains(object) && this.getIndex(object) != n) {
            return false;
        }
        super.remove(this.objectKeyTable[n]);
        super.put(object, object2);
        return true;
    }

    public boolean setKey(int n, Object object) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object2 = this.objectValueTable[n];
        return this.set(n, object, object2);
    }

    public Object getKey(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.objectKeyTable[n];
    }

    public int getIndex(Object object) {
        return this.getLookup(object, object.hashCode());
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

