/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.engine.PlanBase;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;

public class PlanOp
extends PlanBase {
    private QueryIterator qIter;
    private String label = null;

    public PlanOp(Op op, QueryIterator qIter) {
        super(op);
        this.qIter = qIter;
    }

    public PlanOp(String label, Op op, QueryIterator qIter) {
        this(op, qIter);
        this.label = label;
    }

    protected QueryIterator iteratorOnce() {
        return this.qIter;
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        if (this.getOp() == null) {
            out.println(Utils.className(this));
            return;
        }
        if (this.label != null) {
            out.print("(");
            out.println(this.label);
            out.incIndent();
        }
        this.iterator().output(out, sCxt);
        if (this.label != null) {
            out.print(")");
            out.decIndent();
        }
        out.ensureStartOfLine();
    }
}

