/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.dspace.foresite.Agent;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.DateParser;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREFactory;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.Proxy;
import org.dspace.foresite.ReMSerialisation;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.Vocab;
import org.dspace.foresite.jena.AgentJena;
import org.dspace.foresite.jena.AggregatedResourceJena;
import org.dspace.foresite.jena.JenaOREFactory;
import org.dspace.foresite.jena.ORE;
import org.dspace.foresite.jena.OREResourceJena;
import org.dspace.foresite.jena.OREX;
import org.dspace.foresite.jena.ProxyJena;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationJena
extends OREResourceJena
implements Aggregation {
    @Override
    public void empty() {
    }

    @Override
    public void detach() throws OREException {
    }

    @Override
    public void initialise(URI uri) throws OREException {
        String ident = uri.toString();
        String rx = ".+://.+";
        Pattern p = Pattern.compile(rx);
        Matcher m = p.matcher(ident);
        if (!m.matches()) {
            throw new OREException("Illegal URI: " + uri.toString() + "; Aggregation requires a protocol-based URI");
        }
        this.res = this.model.createResource(uri.toString());
        this.res.addProperty(RDF.type, (RDFNode)ORE.Aggregation);
    }

    @Override
    public List<Agent> getCreators() {
        ArrayList<Agent> creators = new ArrayList<Agent>();
        StmtIterator itr = this.res.listProperties(DC.creator);
        while (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            Resource resource = (Resource)statement.getObject();
            Agent creator = JenaOREFactory.createAgent(resource);
            creators.add(creator);
        }
        return creators;
    }

    @Override
    public void setCreators(List<Agent> creators) {
        this.clearCreators();
        for (Agent creator : creators) {
            this.addCreator(creator);
        }
    }

    @Override
    public void addCreator(Agent creator) {
        Resource resource = ((AgentJena)creator).getResource();
        this.res.addProperty(DC.creator, (RDFNode)resource);
        this.addResourceToModel(resource);
    }

    @Override
    public void clearCreators() {
        List<Agent> creators = this.getCreators();
        for (Agent creator : creators) {
            Model cModel = ((AgentJena)creator).getModel();
            StmtIterator itr = cModel.listStatements();
            this.model.remove(itr);
        }
    }

    @Override
    public Date getCreated() throws OREException {
        try {
            Statement statement = this.res.getProperty(DCTerms.created);
            if (statement == null) {
                return null;
            }
            String date = ((Literal)statement.getObject()).getLexicalForm();
            Date created = DateParser.parse(date);
            return created;
        }
        catch (OREParserException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setCreated(Date created) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(created);
        String date = DatatypeConverter.printDateTime((Calendar)cal);
        this.res.addProperty(DCTerms.created, (RDFNode)this.model.createTypedLiteral(date, "http://www.w3.org/2001/XMLSchema#dateTime"));
    }

    @Override
    public Date getModified() throws OREException {
        try {
            Statement statement = this.res.getProperty(DCTerms.modified);
            if (statement == null) {
                return null;
            }
            String date = ((Literal)statement.getObject()).getLexicalForm();
            Date created = DateParser.parse(date);
            return created;
        }
        catch (OREParserException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setModified(Date modified) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(modified);
        String date = DatatypeConverter.printDateTime((Calendar)cal);
        this.res.addProperty(DCTerms.modified, (RDFNode)this.model.createTypedLiteral(date, "http://www.w3.org/2001/XMLSchema#dateTime"));
    }

    @Override
    public List<URI> getRights() throws OREException {
        try {
            ArrayList<URI> rights = new ArrayList<URI>();
            StmtIterator itr = this.res.listProperties(DC.rights);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Resource right = (Resource)statement.getObject();
                rights.add(new URI(right.getURI()));
            }
            return rights;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setRights(List<URI> rights) {
        this.clearRights();
        for (URI right : rights) {
            this.addRights(right);
        }
    }

    @Override
    public void addRights(URI rights) {
        this.res.addProperty(DC.rights, (RDFNode)this.model.createResource(rights.toString()));
    }

    @Override
    public void clearRights() {
        this.res.removeAll(DC.rights);
    }

    @Override
    public List<String> getTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        StmtIterator itr = this.res.listProperties(DC.title);
        while (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            String title = ((Literal)statement.getObject()).getLexicalForm();
            titles.add(title);
        }
        return titles;
    }

    @Override
    public void setTitles(List<String> titles) {
        this.clearTitles();
        for (String title : titles) {
            this.addTitle(title);
        }
    }

    @Override
    public void addTitle(String title) {
        this.res.addProperty(DC.title, title);
    }

    @Override
    public void clearTitles() {
        StmtIterator itr = this.res.listProperties(DC.title);
        this.model.remove(itr);
    }

    @Override
    public void setTypes(List<URI> types) {
        super.setTypes(types);
        SimpleSelector selector = new SimpleSelector(this.res, RDF.type, (RDFNode)ORE.Aggregation);
        StmtIterator itr = this.model.listStatements((Selector)selector);
        if (!itr.hasNext()) {
            this.res.addProperty(RDF.type, (RDFNode)ORE.Aggregation);
        }
    }

    @Override
    public void clearTypes() {
        super.clearTypes();
        this.res.addProperty(RDF.type, (RDFNode)ORE.Aggregation);
    }

    @Override
    public Vocab getOREType() throws OREException {
        return Vocab.ore_Aggregation;
    }

    @Override
    public List<URI> getSimilarTo() throws OREException {
        try {
            ArrayList<URI> similars = new ArrayList<URI>();
            StmtIterator itr = this.res.listProperties(ORE.similarTo);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Resource node = (Resource)statement.getObject();
                similars.add(new URI(node.getURI()));
            }
            return similars;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setSimilarTo(List<URI> similarTo) {
        this.clearSimilarTo();
        for (URI similar : similarTo) {
            this.addSimilarTo(similar);
        }
    }

    @Override
    public void addSimilarTo(URI similarTo) {
        this.res.addProperty(ORE.similarTo, (RDFNode)this.model.createResource(similarTo.toString()));
    }

    @Override
    public void clearSimilarTo() {
        StmtIterator itr = this.res.listProperties(ORE.similarTo);
        this.model.remove(itr);
    }

    @Override
    public List<URI> getSeeAlso() throws OREException {
        try {
            ArrayList<URI> similars = new ArrayList<URI>();
            StmtIterator itr = this.res.listProperties(RDFS.seeAlso);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                RDFNode node = statement.getObject();
                similars.add(new URI(((Literal)node).getLexicalForm()));
            }
            return similars;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setSeeAlso(List<URI> seeAlso) throws OREException {
        this.clearSeeAlso();
        for (URI similar : seeAlso) {
            this.addSeeAlso(similar);
        }
    }

    @Override
    public void addSeeAlso(URI seeAlso) throws OREException {
        this.res.addProperty(RDFS.seeAlso, (RDFNode)this.model.createTypedLiteral((Object)seeAlso));
    }

    @Override
    public void clearSeeAlso() throws OREException {
        StmtIterator itr = this.res.listProperties(RDFS.seeAlso);
        this.model.remove(itr);
    }

    @Override
    public AggregatedResource createAggregatedResource(Aggregation aggregation) throws OREException {
        AggregatedResource ar = JenaOREFactory.createAggregatedResource(this.model, aggregation.getURI());
        Resource resource = ((AggregatedResourceJena)ar).getResource();
        resource.addProperty(RDF.type, (RDFNode)ORE.Aggregation);
        this.addAggregatedResource(ar);
        return ar;
    }

    @Override
    public AggregatedResource createAggregatedResource(URI uri) throws OREException {
        if (uri.equals(this.res.getURI())) {
            throw new OREException("Cannot create an AggregatedResource with the same URI as its Aggregation");
        }
        AggregatedResource ar = JenaOREFactory.createAggregatedResource(this.model, uri);
        this.addAggregatedResource(ar);
        return ar;
    }

    @Override
    public List<AggregatedResource> getAggregatedResources() throws OREException {
        try {
            ArrayList<AggregatedResource> ars = new ArrayList<AggregatedResource>();
            StmtIterator itr = this.res.listProperties(ORE.aggregates);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                String resURI = ((Resource)statement.getObject()).getURI();
                AggregatedResource ar = JenaOREFactory.createAggregatedResource(this.model, new URI(resURI));
                ars.add(ar);
            }
            return ars;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setAggregatedResources(List<AggregatedResource> resources) throws OREException {
        this.clearAggregatedResources();
        for (AggregatedResource ar : resources) {
            this.addAggregatedResource(ar);
        }
    }

    @Override
    public void addAggregatedResource(AggregatedResource resource) throws OREException {
        try {
            if (resource.getURI().equals(this.res.getURI())) {
                throw new OREException("Cannot add an AggregatedResource with the same URI as its Aggregation");
            }
            resource.addAggregation(new URI(this.res.getURI()));
            Resource ar = ((AggregatedResourceJena)resource).getResource();
            Model arModel = ((AggregatedResourceJena)resource).getModel();
            this.addModelToModel(arModel);
            this.res.addProperty(ORE.aggregates, (RDFNode)ar);
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void clearAggregatedResources() throws OREException {
        List<AggregatedResource> ars = this.getAggregatedResources();
        for (AggregatedResource ar : ars) {
            ar.empty();
        }
        StmtIterator itr = this.res.listProperties(ORE.aggregates);
        this.model.remove(itr);
    }

    @Override
    public List<ReMSerialisation> getReMSerialisations() throws OREException {
        try {
            ArrayList<ReMSerialisation> serialisations = new ArrayList<ReMSerialisation>();
            StmtIterator itr = this.res.listProperties(ORE.isDescribedBy);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Resource resource = (Resource)statement.getObject();
                StmtIterator itr2 = resource.listProperties(DC.format);
                StmtIterator itr3 = resource.listProperties(OREX.isAuthoritativeFor);
                String mime = "application/octet-stream";
                if (itr2.hasNext()) {
                    Statement stmt = itr2.nextStatement();
                    mime = ((Literal)stmt.getObject()).getLexicalForm();
                }
                boolean authoritative = false;
                if (itr3.hasNext()) {
                    authoritative = true;
                }
                ReMSerialisation serialisation = new ReMSerialisation(mime, new URI(resource.getURI()));
                serialisation.setAuthoritative(authoritative);
                serialisations.add(serialisation);
            }
            return serialisations;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setReMSerialisations(List<ReMSerialisation> serialisations) throws OREException {
        for (ReMSerialisation serial : serialisations) {
            this.addReMSerialisation(serial);
        }
    }

    @Override
    public void clearReMSerialisations() {
        StmtIterator itr = this.res.listProperties(ORE.isDescribedBy);
        this.model.remove(itr);
    }

    @Override
    public void addReMSerialisation(ReMSerialisation serialisation) throws OREException {
        URI uri = serialisation.getURI();
        ResourceMap rem = this.getResourceMap(uri);
        if (rem != null) {
            return;
        }
        this.addResourceMapURI(uri);
        String mime = serialisation.getMimeType();
        if (mime == null) {
            mime = "application/octet-stream";
        }
        Literal literal = this.model.createTypedLiteral(mime);
        Statement statement = this.model.createStatement(this.model.getResource(uri.toString()), DC.format, (RDFNode)literal);
        this.model.add(statement);
    }

    @Override
    public ResourceMap createResourceMap(URI uri) throws OREException {
        ResourceMap rem = JenaOREFactory.createResourceMap(this.model, uri);
        List<ResourceMap> arems = this.getAuthoritative();
        if (arems.size() == 0) {
            rem.setAuthoritative(true);
        }
        this.addResourceMapURI(uri);
        return rem;
    }

    @Override
    public List<ResourceMap> getAuthoritative() throws OREException {
        try {
            ArrayList<ResourceMap> rems = new ArrayList<ResourceMap>();
            SimpleSelector selector = new SimpleSelector(null, OREX.isAuthoritativeFor, (RDFNode)this.res);
            StmtIterator itr = this.model.listStatements((Selector)selector);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                ResourceMap rem = JenaOREFactory.createResourceMap(this.model, new URI(statement.getSubject().getURI()));
                rems.add(rem);
            }
            return rems;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public List<ResourceMap> getResourceMaps() throws OREException {
        try {
            ArrayList<ResourceMap> rems = new ArrayList<ResourceMap>();
            SimpleSelector selector = new SimpleSelector(this.res, ORE.isDescribedBy, (RDFNode)null);
            StmtIterator itr = this.model.listStatements((Selector)selector);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                ResourceMap rem = JenaOREFactory.createResourceMap(this.model, new URI(statement.getSubject().getURI()));
                rems.add(rem);
            }
            return rems;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void addResourceMapURI(URI uri) throws OREException {
        Resource resource = this.model.createResource(uri.toString());
        this.model.add(this.model.createStatement(resource, ORE.describes, (RDFNode)this.res));
        this.model.add(this.model.createStatement(this.res, ORE.isDescribedBy, (RDFNode)resource));
        this.model.add(this.model.createStatement(resource, RDF.type, (RDFNode)ORE.ResourceMap));
    }

    @Override
    public ResourceMap getResourceMap(URI uri) throws OREException {
        SimpleSelector selector = new SimpleSelector(null, ORE.isAggregatedBy, (RDFNode)this.res);
        StmtIterator itr = this.model.listStatements((Selector)selector);
        if (itr.hasNext()) {
            ResourceMap rem = JenaOREFactory.createResourceMap(this.model, uri);
            return rem;
        }
        return null;
    }

    @Override
    public Proxy createProxy(URI proxyURI, URI arURI) throws OREException {
        SimpleSelector selector = new SimpleSelector(this.model.createResource(proxyURI.toString()), null, (RDFNode)null);
        StmtIterator itr = this.model.listStatements((Selector)selector);
        if (itr.hasNext()) {
            throw new OREException("URI: " + proxyURI.toString() + " is already in use by this Aggregation");
        }
        Proxy proxy = OREFactory.createProxy(proxyURI);
        proxy.setProxyForURI(arURI);
        this.addProxy(proxy);
        ((ProxyJena)proxy).setModel(this.model, proxyURI);
        return proxy;
    }

    @Override
    public void addProxy(Proxy proxy) throws OREException {
        proxy.setProxyInURI(this.getURI());
        Model pModel = ((ProxyJena)proxy).getModel();
        this.addModelToModel(pModel);
    }

    @Override
    public List<Proxy> getProxies() throws OREException {
        try {
            SimpleSelector selector = new SimpleSelector(null, ORE.proxyIn, (RDFNode)this.res);
            ArrayList<Proxy> proxies = new ArrayList<Proxy>();
            StmtIterator itr = this.model.listStatements((Selector)selector);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                URI resURI = new URI(statement.getSubject().getURI());
                Proxy proxy = JenaOREFactory.createProxy(this.model, resURI);
                proxies.add(proxy);
            }
            return proxies;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void clearProxies() throws OREException {
        List<Proxy> proxies = this.getProxies();
    }
}

