/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.util.Vector;
import org.ecoinformatics.datamanager.database.ANDRelation;
import org.ecoinformatics.datamanager.database.ConditionInterface;
import org.ecoinformatics.datamanager.database.ORRelation;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;

public class LogicalRelation {
    protected static final String AND = "AND";
    protected static final String OR = "OR";
    private static final String LEFT_PARENSIS = "(";
    private static final String RIGHT_PARENSIS = ")";
    private Vector ANDRelationList = new Vector();
    private Vector conditionList = new Vector();
    private Vector ORRelationList = new Vector();

    public ConditionInterface[] getConditionInterfaceList() {
        if (this.conditionList == null || this.conditionList.size() == 0) {
            return null;
        }
        int size = this.conditionList.size();
        ConditionInterface[] list = new ConditionInterface[size];
        for (int i = 0; i < size; ++i) {
            list[i] = (ConditionInterface)this.conditionList.elementAt(i);
        }
        return list;
    }

    public ANDRelation[] getANDRelationList() {
        if (this.ANDRelationList == null || this.ANDRelationList.size() == 0) {
            return null;
        }
        int size = this.ANDRelationList.size();
        ANDRelation[] list = new ANDRelation[size];
        for (int i = 0; i < size; ++i) {
            list[i] = (ANDRelation)this.ANDRelationList.elementAt(i);
        }
        return list;
    }

    public ORRelation[] getORRelationList() {
        if (this.ORRelationList == null || this.ORRelationList.size() == 0) {
            return null;
        }
        int size = this.ORRelationList.size();
        ORRelation[] list = new ORRelation[size];
        for (int i = 0; i < size; ++i) {
            list[i] = (ORRelation)this.ORRelationList.elementAt(i);
        }
        return list;
    }

    public void addCondtionInterface(ConditionInterface condition) {
        this.conditionList.add(condition);
    }

    public void addANDRelation(ANDRelation and) {
        this.ANDRelationList.add(and);
    }

    public void addORRelation(ORRelation or) {
        this.ORRelationList.add(or);
    }

    protected String transferToString(String operator) throws UnWellFormedQueryException {
        int i;
        int length;
        StringBuffer sql = new StringBuffer();
        if (this.conditionList == null && this.ANDRelationList == null && this.ORRelationList == null || this.conditionList.isEmpty() && this.ANDRelationList.isEmpty() && this.ORRelationList.isEmpty()) {
            throw new UnWellFormedQueryException("There are no sub-compents in the logical (AND or OR) relation");
        }
        int conditionLength = 0;
        int ANDRelationLength = 0;
        int ORRelationLength = 0;
        if (this.conditionList != null) {
            conditionLength = this.conditionList.size();
        }
        if (this.ANDRelationList != null) {
            ANDRelationLength = this.ANDRelationList.size();
        }
        sql.append(" ");
        if (this.ORRelationList != null) {
            ORRelationLength = this.ORRelationList.size();
        }
        if ((length = conditionLength + ANDRelationLength + ORRelationLength) == 1) {
            throw new UnWellFormedQueryException("There is only one sub component in the logical relation");
        }
        boolean firstElement = true;
        for (i = 0; i < conditionLength; ++i) {
            ConditionInterface condition = (ConditionInterface)this.conditionList.elementAt(i);
            if (firstElement) {
                sql.append(condition.toSQLString());
                sql.append(" ");
                firstElement = false;
                continue;
            }
            sql.append(operator);
            sql.append(" ");
            sql.append(condition.toSQLString());
            sql.append(" ");
        }
        for (i = 0; i < ANDRelationLength; ++i) {
            ANDRelation and = (ANDRelation)this.ANDRelationList.elementAt(i);
            if (firstElement) {
                sql.append(LEFT_PARENSIS);
                sql.append(and.toSQLString());
                sql.append(RIGHT_PARENSIS);
                sql.append(" ");
                firstElement = false;
                continue;
            }
            sql.append(operator);
            sql.append(" ");
            sql.append(LEFT_PARENSIS);
            sql.append(and.toSQLString());
            sql.append(RIGHT_PARENSIS);
            sql.append(" ");
        }
        for (i = 0; i < ORRelationLength; ++i) {
            ORRelation or = (ORRelation)this.ORRelationList.elementAt(i);
            if (firstElement) {
                sql.append(LEFT_PARENSIS);
                sql.append(or.toSQLString());
                sql.append(RIGHT_PARENSIS);
                sql.append(" ");
                firstElement = false;
                continue;
            }
            sql.append(operator);
            sql.append(" ");
            sql.append(LEFT_PARENSIS);
            sql.append(or.toSQLString());
            sql.append(RIGHT_PARENSIS);
            sql.append(" ");
        }
        return sql.toString();
    }
}

