/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.ClassUtils;

public abstract class JodaTimeConverters {
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent("org.joda.time.LocalDate", null);

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JODA_TIME_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(LocalDateToDateConverter.INSTANCE);
        converters.add(LocalDateTimeToDateConverter.INSTANCE);
        converters.add(DateTimeToDateConverter.INSTANCE);
        converters.add(DateMidnightToDateConverter.INSTANCE);
        converters.add(DateToLocalDateConverter.INSTANCE);
        converters.add(DateToLocalDateTimeConverter.INSTANCE);
        converters.add(DateToDateTimeConverter.INSTANCE);
        converters.add(DateToDateMidnightConverter.INSTANCE);
        return converters;
    }

    public static enum DateToDateMidnightConverter implements Converter<Date, DateMidnight>
    {
        INSTANCE;


        @Override
        public DateMidnight convert(Date source) {
            return source == null ? null : new DateMidnight(source.getTime());
        }
    }

    public static enum DateToDateTimeConverter implements Converter<Date, DateTime>
    {
        INSTANCE;


        @Override
        public DateTime convert(Date source) {
            return source == null ? null : new DateTime(source.getTime());
        }
    }

    public static enum DateToLocalDateTimeConverter implements Converter<Date, LocalDateTime>
    {
        INSTANCE;


        @Override
        public LocalDateTime convert(Date source) {
            return source == null ? null : new LocalDateTime(source.getTime());
        }
    }

    public static enum DateToLocalDateConverter implements Converter<Date, LocalDate>
    {
        INSTANCE;


        @Override
        public LocalDate convert(Date source) {
            return source == null ? null : new LocalDate(source.getTime());
        }
    }

    public static enum DateMidnightToDateConverter implements Converter<DateMidnight, Date>
    {
        INSTANCE;


        @Override
        public Date convert(DateMidnight source) {
            return source == null ? null : source.toDate();
        }
    }

    public static enum DateTimeToDateConverter implements Converter<DateTime, Date>
    {
        INSTANCE;


        @Override
        public Date convert(DateTime source) {
            return source == null ? null : source.toDate();
        }
    }

    public static enum LocalDateTimeToDateConverter implements Converter<LocalDateTime, Date>
    {
        INSTANCE;


        @Override
        public Date convert(LocalDateTime source) {
            return source == null ? null : source.toDate();
        }
    }

    public static enum LocalDateToDateConverter implements Converter<LocalDate, Date>
    {
        INSTANCE;


        @Override
        public Date convert(LocalDate source) {
            return source == null ? null : source.toDate();
        }
    }
}

