/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.LockMode;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.OnLockVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractReassociateEventListener
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractReassociateEventListener.class);

    protected final EntityEntry reassociate(AbstractEvent event, Object object, Serializable id, EntityPersister persister) {
        if (log.isTraceEnabled()) {
            log.trace("reassociating transient instance: " + MessageHelper.infoString(persister, id, event.getSession().getFactory()));
        }
        EventSource source = event.getSession();
        EntityKey key = new EntityKey(id, persister, source.getEntityMode());
        source.getPersistenceContext().checkUniqueness(key, object);
        Object[] values = persister.getPropertyValues(object, source.getEntityMode());
        TypeHelper.deepCopy(values, persister.getPropertyTypes(), persister.getPropertyUpdateability(), values, source);
        Object version2 = Versioning.getVersion(values, persister);
        EntityEntry newEntry = source.getPersistenceContext().addEntity(object, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, values, key, version2, LockMode.NONE, true, persister, false, true);
        new OnLockVisitor(source, id, object).process(object, persister);
        persister.afterReassociate(object, source);
        return newEntry;
    }
}

