/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;
import org.dataone.cn.dao.DaoFactory;
import org.dataone.cn.dao.ReplicationDao;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.service.types.v1.Identifier;

public abstract class AbstractReplicationAuditor
implements Runnable {
    private static Logger log = Logger.getLogger(AbstractReplicationAuditor.class.getName());
    protected ReplicationDao replicationDao = DaoFactory.getReplicationDao();
    private ExecutorService executorService = Executors.newFixedThreadPool(this.getTaskPoolSize());

    protected abstract String getLockName();

    protected abstract Date calculateAuditDate();

    protected abstract List<Identifier> getPidsToAudit(Date var1, int var2, int var3) throws DataAccessException;

    protected abstract Callable<String> newAuditTask(List<Identifier> var1, Date var2);

    protected abstract int getMaxPages();

    protected abstract int getTaskPoolSize();

    protected abstract int getPageSize();

    protected abstract int getPidsPerTaskSize();

    protected abstract boolean shouldRunAudit();

    protected abstract long getFutureExecutionWaitTimeSeconds();

    @Override
    public void run() {
        this.auditReplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auditReplication() {
        block8: {
            if (this.shouldRunAudit()) {
                Lock auditLock = this.getProcessingLock();
                try {
                    if (!this.tryLock(auditLock)) break block8;
                    Date auditDate = this.calculateAuditDate();
                    List<Identifier> pidsToAudit = null;
                    for (int i = 1; i < this.getMaxPages(); ++i) {
                        try {
                            pidsToAudit = this.getPidsToAudit(auditDate, i, this.getPageSize());
                        }
                        catch (DataAccessException dae) {
                            log.error("Unable to retrieve replicas by date using replication dao for audit date: " + auditDate.toString() + ".", dae);
                        }
                        if (pidsToAudit.size() == 0) {
                            break;
                        }
                        this.auditPids(pidsToAudit, auditDate);
                    }
                }
                finally {
                    this.releaseLock(auditLock);
                }
            }
        }
    }

    protected boolean tryLock(Lock auditLock) {
        if (auditLock == null) {
            return false;
        }
        return auditLock.tryLock();
    }

    protected void releaseLock(Lock auditLock) {
        if (auditLock != null) {
            auditLock.unlock();
        }
    }

    protected Lock getProcessingLock() {
        return HazelcastClientFactory.getProcessingClient().getLock(this.getLockName());
    }

    private void auditPids(List<Identifier> pids, Date auditDate) {
        ArrayList<Identifier> pidBatch = new ArrayList<Identifier>();
        ArrayList<Callable<String>> auditTaskBatch = new ArrayList<Callable<String>>();
        ArrayList<Future> currentFutures = new ArrayList<Future>();
        ArrayList<Future> previousFutures = new ArrayList<Future>();
        for (Identifier pid : pids) {
            pidBatch.add(pid);
            if (pidBatch.size() >= this.getPidsPerTaskSize()) {
                auditTaskBatch.add(this.newAuditTask(pidBatch, auditDate));
                pidBatch.clear();
            }
            if (auditTaskBatch.size() >= this.getTaskPoolSize()) {
                this.submitTasks(auditTaskBatch, currentFutures, previousFutures);
            }
            if (previousFutures.isEmpty()) continue;
            this.handleFutures(previousFutures);
        }
        if (auditTaskBatch.size() > 0) {
            this.submitTasks(auditTaskBatch, currentFutures, previousFutures);
        }
        this.handleFutures(currentFutures);
    }

    private void submitTasks(List<Callable<String>> tasks, List<Future> currentFutures, List<Future> previousFutures) {
        previousFutures.clear();
        previousFutures.addAll(currentFutures);
        currentFutures.clear();
        for (Callable<String> auditTask : tasks) {
            this.submitTask(currentFutures, auditTask);
        }
        tasks.clear();
    }

    private void submitTask(List<Future> currentFutures, Callable<String> auditTask) {
        Future<String> future = null;
        try {
            future = this.executorService.submit(auditTask);
        }
        catch (RejectedExecutionException rej) {
            log.error("Unable to submit tasks to executor service. ", rej);
            log.error("Sleeping for 10 seconds, trying again");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e2) {
                log.error("sleep interrupted.", e2);
            }
            try {
                future = this.executorService.submit(auditTask);
            }
            catch (RejectedExecutionException reEx) {
                log.error("Still unable to submit tasks to executor service, failing. ", reEx);
            }
        }
        if (future != null) {
            currentFutures.add(future);
        }
    }

    private void handleFutures(List<Future> taskFutures) {
        for (Future future : taskFutures) {
            this.handleFuture(future);
        }
    }

    private void handleFuture(Future future) {
        boolean isDone = false;
        String result = null;
        boolean timedOut = false;
        while (!isDone) {
            try {
                result = (String)future.get(this.getFutureExecutionWaitTimeSeconds(), TimeUnit.SECONDS);
                if (result != null) {
                    log.debug("Replica audit task completed with result: " + result);
                }
            }
            catch (InterruptedException e2) {
                log.error("Replica audit task interrupted, cancelling.", e2);
                future.cancel(true);
            }
            catch (CancellationException e3) {
                log.error("Replica audit task cancelled.", e3);
            }
            catch (ExecutionException e4) {
                log.error("Replica audit task threw exception during execution. ", e4);
            }
            catch (TimeoutException e5) {
                if (!timedOut) {
                    log.debug("Replica audit task timed out.  waiting another" + this.getFutureExecutionWaitTimeSeconds() + " seconds.");
                    timedOut = true;
                }
                log.error("Replica audit task timed out twice, cancelling.");
                future.cancel(true);
            }
            isDone = future.isDone();
        }
    }
}

