/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.ldap.LDAPService;
import org.dataone.cn.ldap.NodeServicesAccess;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.ServiceMethodRestriction;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.Node;

public class ServiceMethodRestrictionsAccess
extends LDAPService {
    public static Log log = LogFactory.getLog(ServiceMethodRestrictionsAccess.class);
    private static NodeServicesAccess nodeServicesAccess = new NodeServicesAccess();
    public static final String OBJECT_CLASS_ID = "d1ServiceMethodRestriction";
    public static final String SERVICE_METHOD_NAME = "d1ServiceMethodName";
    public static final String SERVICE_ALLOWED_SUBJECT = "d1AllowedSubject";

    public ServiceMethodRestrictionsAccess() {
        this.setBase(Settings.getConfiguration().getString("nodeRegistry.ldap.base"));
    }

    protected String buildServiceMethodRestrictionDN(NodeReference nodeReference, Service service, ServiceMethodRestriction restrict) {
        String d1NodeServiceId = nodeServicesAccess.buildNodeServiceId(service);
        return String.format("%s=%s,%s=%s,cn=%s,dc=dataone,dc=org", SERVICE_METHOD_NAME, restrict.getMethodName(), "d1NodeServiceId", d1NodeServiceId, nodeReference.getValue());
    }

    protected Boolean deleteServiceMethodRestriction(DirContext ctx, NodeReference nodeReference, Service service, ServiceMethodRestriction restrict) {
        return super.removeEntry(ctx, this.buildServiceMethodRestrictionDN(nodeReference, service, restrict));
    }

    protected List<ServiceMethodRestriction> getServiceMethodRestrictionList(DirContext ctx, String nodeIdentifier, String serviceIdentifier) throws ServiceFailure {
        ArrayList<ServiceMethodRestriction> serviceMethodRestrictionList = new ArrayList<ServiceMethodRestriction>();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(this.getBase(), String.format("(&(&(objectClass=%s)(%s=%s))(%s=%s))", OBJECT_CLASS_ID, "d1NodeServiceId", serviceIdentifier, "d1NodeId", nodeIdentifier), ctls);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String nodeDn = si.getNameInNamespace();
                log.trace("Search result found for: " + nodeDn);
                HashMap<String, NamingEnumeration> attributesMap = new HashMap<String, NamingEnumeration>();
                Attributes attributes = si.getAttributes();
                NamingEnumeration<? extends Attribute> values = attributes.getAll();
                while (values.hasMore()) {
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID().toLowerCase();
                    NamingEnumeration<?> attributeValue = attribute.getAll();
                    attributesMap.put(attributeName, attributeValue);
                }
                serviceMethodRestrictionList.add(this.mapServiceMethodRestriction(attributesMap));
            }
        }
        catch (CommunicationException ex) {
            log.error("LDAP Service is unresponsive " + nodeIdentifier, ex);
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            log.error("Problem search Nodes for Nodelist", e2);
            throw new ServiceFailure("-1", e2.getMessage());
        }
        return serviceMethodRestrictionList;
    }

    protected ServiceMethodRestriction mapServiceMethodRestriction(HashMap<String, NamingEnumeration> attributesMap) throws NamingException {
        ServiceMethodRestriction serviceMethodRestriction = new ServiceMethodRestriction();
        serviceMethodRestriction.setMethodName(this.getEnumerationValueString(attributesMap.get(SERVICE_METHOD_NAME.toLowerCase())));
        if (attributesMap.containsKey(SERVICE_ALLOWED_SUBJECT.toLowerCase())) {
            List<Subject> subjectList = serviceMethodRestriction.getSubjectList();
            NamingEnumeration allowSubjects = attributesMap.get(SERVICE_ALLOWED_SUBJECT.toLowerCase());
            while (allowSubjects.hasMore()) {
                Subject allowSubject = new Subject();
                String subjectValue = (String)allowSubjects.next();
                allowSubject.setValue(subjectValue);
                try {
                    X500Principal principal = new X500Principal(subjectValue);
                    String standardizedName = principal.getName("RFC2253");
                    allowSubject.setValue(standardizedName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                subjectList.add(allowSubject);
            }
        }
        return serviceMethodRestriction;
    }

    protected Attributes mapServiceMethodRestrictionAttributes(Node node, Service service, ServiceMethodRestriction restrict) {
        BasicAttributes serviceAttributes = new BasicAttributes();
        String nodeServiceId = nodeServicesAccess.buildNodeServiceId(service);
        serviceAttributes.put(new BasicAttribute("objectclass", OBJECT_CLASS_ID));
        serviceAttributes.put(new BasicAttribute("d1NodeServiceId", nodeServiceId));
        serviceAttributes.put(new BasicAttribute("d1NodeId", node.getIdentifier().getValue()));
        serviceAttributes.put(new BasicAttribute(SERVICE_METHOD_NAME, restrict.getMethodName()));
        if (restrict.getSubjectList() != null && !restrict.getSubjectList().isEmpty()) {
            for (Subject subject : restrict.getSubjectList()) {
                serviceAttributes.put(new BasicAttribute(SERVICE_ALLOWED_SUBJECT, subject.getValue()));
            }
        }
        return serviceAttributes;
    }
}

