/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultiComp;
import org.apache.solr.client.solrj.io.stream.ExpressibleStream;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrjNamedThreadFactory;

public class CloudSolrStream
extends TupleStream
implements ExpressibleStream {
    private static final long serialVersionUID = 1L;
    protected String zkHost;
    protected String collection;
    protected Map<String, String> params;
    private Map<String, String> fieldMappings;
    protected Comparator<Tuple> comp;
    private int zkConnectTimeout = 10000;
    private int zkClientTimeout = 10000;
    private int numWorkers;
    private int workerID;
    private boolean trace;
    protected transient Map<String, Tuple> eofTuples;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;
    protected transient List<TupleStream> solrStreams;
    protected transient TreeSet<TupleWrapper> tuples;
    protected transient StreamContext streamContext;

    protected CloudSolrStream() {
    }

    public CloudSolrStream(String zkHost, String collectionName, Map params) throws IOException {
        this.init(collectionName, zkHost, params);
    }

    public CloudSolrStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter aliasExpression = factory.getNamedOperand(expression, "aliases");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (expression.getParameters().size() != 1 + namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("aliases")) continue;
            params.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        if (null != aliasExpression && aliasExpression.getParameter() instanceof StreamExpressionValue) {
            this.fieldMappings = new HashMap<String, String>();
            for (String mapping : ((StreamExpressionValue)aliasExpression.getParameter()).getValue().split(",")) {
                String[] parts = mapping.trim().split("=");
                if (2 != parts.length) {
                    throw new IOException(String.format(Locale.ROOT, "invalid expression %s - alias expected of the format origName=newName", expression));
                }
                this.fieldMappings.put(parts[0], parts[1]);
            }
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(collectionName, zkHost, params);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), param.getValue()));
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        if (null != this.fieldMappings && 0 != this.fieldMappings.size()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> mapping : this.fieldMappings.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(mapping.getKey());
                sb.append("=");
                sb.append(mapping.getValue());
            }
            expression.addParameter(new StreamExpressionNamedParameter("aliases", sb.toString()));
        }
        return expression;
    }

    private void init(String collectionName, String zkHost, Map params) throws IOException {
        this.zkHost = zkHost;
        this.collection = collectionName;
        this.params = params;
        if (!params.containsKey("fl")) {
            throw new IOException("fl param expected for a stream");
        }
        if (!params.containsKey("sort")) {
            throw new IOException("sort param expected for a stream");
        }
        this.comp = this.parseComp((String)params.get("sort"), (String)params.get("fl"));
    }

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.numWorkers = context.numWorkers;
        this.workerID = context.workerID;
        this.cache = context.getSolrClientCache();
        this.streamContext = context;
    }

    @Override
    public void open() throws IOException {
        this.tuples = new TreeSet();
        this.solrStreams = new ArrayList<TupleStream>();
        this.eofTuples = Collections.synchronizedMap(new HashMap());
        if (this.cache != null) {
            this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
        } else {
            this.cloudSolrClient = new CloudSolrClient(this.zkHost);
            this.cloudSolrClient.connect();
        }
        this.constructStreams();
        this.openStreams();
    }

    public Map getEofTuples() {
        return this.eofTuples;
    }

    @Override
    public List<TupleStream> children() {
        return this.solrStreams;
    }

    private Comparator<Tuple> parseComp(String sort, String fl) throws IOException {
        String[] fls = fl.split(",");
        HashSet<String> fieldSet = new HashSet<String>();
        for (String f : fls) {
            fieldSet.add(f.trim());
        }
        String[] sorts = sort.split(",");
        Comparator[] comps = new Comparator[sorts.length];
        for (int i = 0; i < sorts.length; ++i) {
            String s = sorts[i];
            String[] spec = s.trim().split("\\s+");
            String fieldName = spec[0].trim();
            String order = spec[1].trim();
            if (!fieldSet.contains(spec[0])) {
                throw new IOException("Fields in the sort spec must be included in the field list:" + spec[0]);
            }
            if (null != this.fieldMappings && this.fieldMappings.containsKey(fieldName)) {
                fieldName = this.fieldMappings.get(fieldName);
            }
            comps[i] = new FieldComparator(fieldName, order.equalsIgnoreCase("asc") ? ComparatorOrder.ASCENDING : ComparatorOrder.DESCENDING);
        }
        if (comps.length > 1) {
            return new MultiComp(comps);
        }
        return comps[0];
    }

    protected void constructStreams() throws IOException {
        try {
            ZkStateReader zkStateReader = this.cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Collection<Slice> slices = clusterState.getActiveSlices(this.collection);
            long time = System.currentTimeMillis();
            this.params.put("distrib", "false");
            for (Slice slice : slices) {
                Collection<Replica> replicas = slice.getReplicas();
                ArrayList<Replica> shuffler = new ArrayList<Replica>();
                for (Replica replica : replicas) {
                    shuffler.add(replica);
                }
                Collections.shuffle(shuffler, new Random(time));
                Replica rep = (Replica)shuffler.get(0);
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(rep);
                String url = zkProps.getCoreUrl();
                SolrStream solrStream = new SolrStream(url, this.params);
                if (this.streamContext != null) {
                    solrStream.setStreamContext(this.streamContext);
                }
                solrStream.setFieldMappings(this.fieldMappings);
                this.solrStreams.add(solrStream);
            }
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openStreams() throws IOException {
        ExecutorService service = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("CloudSolrStream"));
        try {
            ArrayList<Future<TupleWrapper>> futures = new ArrayList<Future<TupleWrapper>>();
            for (TupleStream tupleStream : this.solrStreams) {
                StreamOpener so = new StreamOpener((SolrStream)tupleStream, this.comp);
                Future<TupleWrapper> future = service.submit(so);
                futures.add(future);
            }
            try {
                for (Future future : futures) {
                    TupleWrapper w = (TupleWrapper)future.get();
                    if (w == null) continue;
                    this.tuples.add(w);
                }
            }
            catch (Exception e2) {
                throw new IOException(e2);
            }
        }
        finally {
            service.shutdown();
        }
    }

    @Override
    public void close() throws IOException {
        for (TupleStream solrStream : this.solrStreams) {
            solrStream.close();
        }
        if (this.cache == null) {
            this.cloudSolrClient.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        return this._read();
    }

    protected Tuple _read() throws IOException {
        TupleWrapper tw = this.tuples.pollFirst();
        if (tw != null) {
            Tuple t = tw.getTuple();
            if (this.trace) {
                t.put("_COLLECTION_", this.collection);
            }
            if (tw.next()) {
                this.tuples.add(tw);
            }
            return t;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (this.trace) {
            m.put("_COLLECTION_", this.collection);
        }
        m.put("EOF", true);
        return new Tuple(m);
    }

    protected class StreamOpener
    implements Callable<TupleWrapper> {
        private SolrStream stream;
        private Comparator<Tuple> comp;

        public StreamOpener(SolrStream stream, Comparator<Tuple> comp) {
            this.stream = stream;
            this.comp = comp;
        }

        @Override
        public TupleWrapper call() throws Exception {
            this.stream.open();
            TupleWrapper wrapper = new TupleWrapper(this.stream, this.comp);
            if (wrapper.next()) {
                return wrapper;
            }
            return null;
        }
    }

    protected class TupleWrapper
    implements Comparable<TupleWrapper> {
        private Tuple tuple;
        private SolrStream stream;
        private Comparator comp;

        public TupleWrapper(SolrStream stream, Comparator comp) {
            this.stream = stream;
            this.comp = comp;
        }

        @Override
        public int compareTo(TupleWrapper w) {
            if (this == w) {
                return 0;
            }
            int i = this.comp.compare(this.tuple, w.tuple);
            if (i == 0) {
                return 1;
            }
            return i;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public boolean next() throws IOException {
            this.tuple = this.stream.read();
            if (this.tuple.EOF) {
                CloudSolrStream.this.eofTuples.put(this.stream.getBaseUrl(), this.tuple);
            }
            return !this.tuple.EOF;
        }
    }
}

