/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.commons.lang.NumberUtils;

public class TypeHandler {
    public static Object createValue(String str2, Object obj) {
        return TypeHandler.createValue(str2, (Class)obj);
    }

    public static Object createValue(String str2, Class clazz) {
        if (PatternOptionBuilder.STRING_VALUE == clazz) {
            return str2;
        }
        if (PatternOptionBuilder.OBJECT_VALUE == clazz) {
            return TypeHandler.createObject(str2);
        }
        if (PatternOptionBuilder.NUMBER_VALUE == clazz) {
            return TypeHandler.createNumber(str2);
        }
        if (PatternOptionBuilder.DATE_VALUE == clazz) {
            return TypeHandler.createDate(str2);
        }
        if (PatternOptionBuilder.CLASS_VALUE == clazz) {
            return TypeHandler.createClass(str2);
        }
        if (PatternOptionBuilder.FILE_VALUE == clazz) {
            return TypeHandler.createFile(str2);
        }
        if (PatternOptionBuilder.EXISTING_FILE_VALUE == clazz) {
            return TypeHandler.createFile(str2);
        }
        if (PatternOptionBuilder.FILES_VALUE == clazz) {
            return TypeHandler.createFiles(str2);
        }
        if (PatternOptionBuilder.URL_VALUE == clazz) {
            return TypeHandler.createURL(str2);
        }
        return null;
    }

    public static Object createObject(String str2) {
        Class<?> cl = null;
        try {
            cl = Class.forName(str2);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Unable to find: " + str2);
            return null;
        }
        Object instance = null;
        try {
            instance = cl.newInstance();
        }
        catch (InstantiationException cnfe) {
            System.err.println("InstantiationException; Unable to create: " + str2);
            return null;
        }
        catch (IllegalAccessException cnfe) {
            System.err.println("IllegalAccessException; Unable to create: " + str2);
            return null;
        }
        return instance;
    }

    public static Number createNumber(String str2) {
        try {
            return NumberUtils.createNumber(str2);
        }
        catch (NumberFormatException nfe) {
            System.err.println(nfe.getMessage());
            return null;
        }
    }

    public static Class createClass(String str2) {
        try {
            return Class.forName(str2);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Unable to find: " + str2);
            return null;
        }
    }

    public static Date createDate(String str2) {
        Date date2 = null;
        if (date2 == null) {
            System.err.println("Unable to parse: " + str2);
        }
        return date2;
    }

    public static URL createURL(String str2) {
        try {
            return new URL(str2);
        }
        catch (MalformedURLException mue) {
            System.err.println("Unable to parse: " + str2);
            return null;
        }
    }

    public static File createFile(String str2) {
        return new File(str2);
    }

    public static File[] createFiles(String str2) {
        return null;
    }
}

