/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ExecUtils {
    public static void compilePattern(Query graphQuery, List pattern, Binding presets, Set vars) {
        if (pattern == null) {
            return;
        }
        ListIterator iter = pattern.listIterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            t = BindingUtils.substituteIntoTriple(t, presets);
            if (vars != null) {
                if (t.getSubject().isVariable()) {
                    vars.add(t.getSubject());
                }
                if (t.getPredicate().isVariable()) {
                    vars.add(t.getPredicate());
                }
                if (t.getObject().isVariable()) {
                    vars.add(t.getObject());
                }
            }
            graphQuery.addMatch(t);
        }
    }

    public static void compileConstraints(Query graphQuery, List constraints) {
        ALog.warn(ExecUtils.class, "Call to compileConstraints for Jena Expressions");
    }

    public static Var[] projectionVars(Set vars) {
        Var[] result = new Var[vars.size()];
        int i = 0;
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Var n;
            result[i] = n = (Var)iter.next();
            ++i;
        }
        return result;
    }
}

