/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestUtil {
    public static void assertIteratorValues(TestCase testCase, Iterator it, Object[] vals) {
        TestUtil.assertIteratorValues(testCase, it, vals, 0);
    }

    public static void assertIteratorValues(TestCase testCase, Iterator it, Object[] vals, int countAnon) {
        int i;
        Log logger = LogFactory.getLog(testCase.getClass());
        boolean[] found = new boolean[vals.length];
        int anonFound = 0;
        for (i = 0; i < vals.length; ++i) {
            found[i] = false;
        }
        while (it.hasNext()) {
            Object n = it.next();
            boolean gotit = false;
            if (countAnon > 0 && TestUtil.isAnonValue(n)) {
                ++anonFound;
                continue;
            }
            for (int i2 = 0; i2 < vals.length; ++i2) {
                if (!n.equals(vals[i2])) continue;
                gotit = true;
                found[i2] = true;
            }
            if (!gotit) {
                logger.debug(testCase.getName() + " found unexpected iterator value: " + n);
            }
            TestCase.assertTrue(testCase.getName() + " found unexpected iterator value: " + n, gotit);
        }
        for (i = 0; i < vals.length; ++i) {
            if (!found[i]) {
                logger.debug(testCase.getName() + " failed to find expected iterator value: " + vals[i]);
            }
            TestCase.assertTrue(testCase.getName() + " failed to find expected iterator value: " + vals[i], found[i]);
        }
        TestCase.assertEquals(testCase.getName() + " iterator test did not find the right number of anon. nodes", countAnon, anonFound);
    }

    public static String normalizeWhiteSpace(String src) {
        StringBuffer result = new StringBuffer(src.length());
        boolean inWhitespaceBlock = false;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (Character.isWhitespace(c)) {
                if (inWhitespaceBlock) continue;
                result.append(" ");
                inWhitespaceBlock = true;
                continue;
            }
            inWhitespaceBlock = false;
            result.append(c);
        }
        return result.toString();
    }

    public static void assertIteratorLength(Iterator it, int expectedLength) {
        int length = 0;
        while (it.hasNext()) {
            it.next();
            ++length;
        }
        TestCase.assertEquals(expectedLength, length);
    }

    protected static boolean isAnonValue(Object n) {
        return n instanceof Resource && ((Resource)n).isAnon() || n instanceof Statement && ((Statement)n).getSubject().isAnon() || n instanceof Statement && TestUtil.isAnonValue(((Statement)n).getObject());
    }
}

