/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.Filter;
import junit.framework.TestSuite;

public class TestTripleField
extends GraphTestBase {
    public TestTripleField(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTripleField.class);
    }

    public void testFieldsExistAndAreTyped() {
        TestTripleField.assertInstanceOf(Triple.Field.class, Triple.Field.getSubject);
        TestTripleField.assertInstanceOf(Triple.Field.class, Triple.Field.getObject);
        TestTripleField.assertInstanceOf(Triple.Field.class, Triple.Field.getPredicate);
    }

    public void testGetSubject() {
        TestTripleField.assertEquals(TestTripleField.node("s"), Triple.Field.getSubject.getField(TestTripleField.triple("s p o")));
    }

    public void testGetObject() {
        TestTripleField.assertEquals(TestTripleField.node("o"), Triple.Field.getObject.getField(TestTripleField.triple("s p o")));
    }

    public void testGetPredicate() {
        TestTripleField.assertEquals(TestTripleField.node("p"), Triple.Field.getPredicate.getField(TestTripleField.triple("s p o")));
    }

    public void testFilterSubject() {
        TestTripleField.assertTrue(Triple.Field.getSubject.filterOn(TestTripleField.node("a")).accept(TestTripleField.triple("a P b")));
        TestTripleField.assertFalse(Triple.Field.getSubject.filterOn(TestTripleField.node("x")).accept(TestTripleField.triple("a P b")));
    }

    public void testFilterObject() {
        TestTripleField.assertTrue(Triple.Field.getObject.filterOn(TestTripleField.node("b")).accept(TestTripleField.triple("a P b")));
        TestTripleField.assertFalse(Triple.Field.getObject.filterOn(TestTripleField.node("c")).accept(TestTripleField.triple("a P b")));
    }

    public void testFilterPredicate() {
        TestTripleField.assertTrue(Triple.Field.getPredicate.filterOn(TestTripleField.node("P")).accept(TestTripleField.triple("a P b")));
        TestTripleField.assertFalse(Triple.Field.getPredicate.filterOn(TestTripleField.node("Q")).accept(TestTripleField.triple("a P b")));
    }

    public void testFilterByTriple() {
        TestTripleField.assertTrue(Triple.Field.getSubject.filterOn(TestTripleField.triple("s P o")).accept(TestTripleField.triple("s Q p")));
        TestTripleField.assertFalse(Triple.Field.getSubject.filterOn(TestTripleField.triple("s P o")).accept(TestTripleField.triple("x Q p")));
    }

    public void testWildcardFilterIsAny() {
        TestTripleField.assertSame(Filter.any, Triple.Field.getSubject.filterOn(TestTripleField.triple("?x R s")));
        TestTripleField.assertSame(Filter.any, Triple.Field.getObject.filterOn(TestTripleField.triple("x R ?s")));
        TestTripleField.assertSame(Filter.any, Triple.Field.getPredicate.filterOn(TestTripleField.triple("x ?R s")));
    }
}

