/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.dataone.service.cn.replication.auditor.v1.strategy.MemberNodeReplicaAuditingStrategy;
import org.dataone.service.cn.replication.auditor.v1.strategy.ReplicaAuditStrategy;
import org.dataone.service.types.v1.Identifier;

public class MemberNodeReplicaAuditTask
implements Serializable,
Callable<String> {
    private static final long serialVersionUID = 8549092026722882706L;
    private static Logger log = Logger.getLogger(MemberNodeReplicaAuditTask.class.getName());
    private List<Identifier> pidsToAudit = new ArrayList<Identifier>();
    private ReplicaAuditStrategy auditor;
    private Date auditDate;

    public MemberNodeReplicaAuditTask(List<Identifier> pids, Date auditDate) {
        this.pidsToAudit.addAll(pids);
        log.debug("audit task has " + pids.size() + " pids to audit.");
        this.auditDate = auditDate;
        this.auditor = new MemberNodeReplicaAuditingStrategy();
    }

    @Override
    public String call() throws Exception {
        this.auditor.auditPids(this.pidsToAudit, this.auditDate);
        return "Member Node replica audit task for pids: " + this.pidsToAudit.size() + " completed.";
    }

    public List<Identifier> getPidsToAudit() {
        return this.pidsToAudit;
    }
}

