/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.ldap.LDAPService;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.Property;
import org.dataone.service.util.DateTimeMarshaller;

public class NodePropertyAccess
extends LDAPService {
    public static Log log = LogFactory.getLog(NodePropertyAccess.class);
    public static final String OBJECT_CLASS_ID = "d1NodeProperty";
    public static final String NODE_PROPERTY_ID = "d1NodePropertyId";
    public static final String NODE_PROPERTY_KEY = "d1NodePropertyKey";
    public static final String NODE_PROPERTY_VALUE = "d1NodePropertyValue";
    public static final String NODE_PROPERTY_TYPE = "d1NodePropertyType";

    public NodePropertyAccess() {
        this.setBase(Settings.getConfiguration().getString("nodeRegistry.ldap.base"));
    }

    protected String buildNodePropertyDN(NodeReference nodeReference, Property property) {
        String d1NodePropertyId = this.buildNodePropertyId(property);
        String propertyDN = "d1NodePropertyId=" + d1NodePropertyId + ",cn=" + nodeReference.getValue() + ",dc=dataone,dc=org";
        return propertyDN;
    }

    protected String buildNodePropertyId(Property property) {
        return property.getKey();
    }

    protected Boolean deleteNodeProperty(DirContext ctx, NodeReference nodeReference, Property property) {
        return super.removeEntry(ctx, this.buildNodePropertyDN(nodeReference, property));
    }

    protected List<Property> getPropertyList(DirContext ctx, String nodeIdentifier) throws ServiceFailure {
        ArrayList<Property> allProperties = new ArrayList<Property>();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(this.getBase(), String.format("(&(objectClass=%s)(%s=%s))", OBJECT_CLASS_ID, "d1NodeId", nodeIdentifier), ctls);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String nodeDn = si.getNameInNamespace();
                HashMap<String, String> attributesMap = new HashMap<String, String>();
                Attributes attributes = si.getAttributes();
                NamingEnumeration<? extends Attribute> values = attributes.getAll();
                while (values.hasMore()) {
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID().toLowerCase();
                    String attributeValue = (String)attribute.get();
                    attributesMap.put(attributeName, attributeValue);
                }
                allProperties.add(this.mapProperty(attributesMap));
            }
        }
        catch (CommunicationException ex) {
            log.error("LDAP Service is unresponsive " + nodeIdentifier, ex);
            throw new ServiceFailure("-1", "LDAP Service is unresponsive");
        }
        catch (Exception e2) {
            System.err.print("[" + DateTimeMarshaller.serializeDateToUTC(new Date()) + "]  NodeId: " + nodeIdentifier + " ");
            e2.printStackTrace();
            log.error("Problem search NodesProperties for Nodelist", e2);
            throw new ServiceFailure("-1", e2.getMessage());
        }
        return allProperties;
    }

    protected Attributes mapNodePropertyAttributes(Node node, Property property) {
        BasicAttributes propertyAttributes = new BasicAttributes(true);
        String NodePropertyId = this.buildNodePropertyId(property);
        propertyAttributes.put(new BasicAttribute("objectclass", OBJECT_CLASS_ID));
        propertyAttributes.put(new BasicAttribute(NODE_PROPERTY_ID, NodePropertyId));
        propertyAttributes.put(new BasicAttribute("d1NodeId", node.getIdentifier().getValue()));
        propertyAttributes.put(new BasicAttribute(NODE_PROPERTY_KEY, property.getKey()));
        propertyAttributes.put(new BasicAttribute(NODE_PROPERTY_VALUE, property.getValue()));
        if (property.getType() != null) {
            propertyAttributes.put(new BasicAttribute(NODE_PROPERTY_TYPE, property.getType()));
        }
        return propertyAttributes;
    }

    private Property mapProperty(HashMap<String, String> attributesMap) {
        Property property = new Property();
        property.setKey(attributesMap.get(NODE_PROPERTY_KEY.toLowerCase()));
        property.setValue(attributesMap.get(NODE_PROPERTY_VALUE.toLowerCase()));
        property.setType(attributesMap.get(NODE_PROPERTY_TYPE.toLowerCase()));
        return property;
    }
}

