/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;

public class StylesheetComposed
extends Stylesheet {
    static final long serialVersionUID = -3444072247410233923L;
    private int m_importNumber = -1;
    private int m_importCountComposed;
    private int m_endImportCountComposed;
    private transient Vector m_includesComposed;

    public StylesheetComposed(Stylesheet parent) {
        super(parent);
    }

    public boolean isAggregatedType() {
        return true;
    }

    public void recompose(Vector recomposableElements) throws TransformerException {
        int n = this.getIncludeCountComposed();
        int i = -1;
        while (i < n) {
            Stylesheet included = this.getIncludeComposed(i);
            int s = included.getOutputCount();
            int j = 0;
            while (j < s) {
                recomposableElements.addElement(included.getOutput(j));
                ++j;
            }
            s = included.getAttributeSetCount();
            int j2 = 0;
            while (j2 < s) {
                recomposableElements.addElement(included.getAttributeSet(j2));
                ++j2;
            }
            s = included.getDecimalFormatCount();
            int j3 = 0;
            while (j3 < s) {
                recomposableElements.addElement(included.getDecimalFormat(j3));
                ++j3;
            }
            s = included.getKeyCount();
            int j4 = 0;
            while (j4 < s) {
                recomposableElements.addElement(included.getKey(j4));
                ++j4;
            }
            s = included.getNamespaceAliasCount();
            int j5 = 0;
            while (j5 < s) {
                recomposableElements.addElement(included.getNamespaceAlias(j5));
                ++j5;
            }
            s = included.getTemplateCount();
            int j6 = 0;
            while (j6 < s) {
                recomposableElements.addElement(included.getTemplate(j6));
                ++j6;
            }
            s = included.getVariableOrParamCount();
            int j7 = 0;
            while (j7 < s) {
                recomposableElements.addElement(included.getVariableOrParam(j7));
                ++j7;
            }
            s = included.getStripSpaceCount();
            int j8 = 0;
            while (j8 < s) {
                recomposableElements.addElement(included.getStripSpace(j8));
                ++j8;
            }
            s = included.getPreserveSpaceCount();
            int j9 = 0;
            while (j9 < s) {
                recomposableElements.addElement(included.getPreserveSpace(j9));
                ++j9;
            }
            ++i;
        }
    }

    void recomposeImports() {
        this.m_importNumber = this.getStylesheetRoot().getImportNumber(this);
        StylesheetRoot root = this.getStylesheetRoot();
        int globalImportCount = root.getGlobalImportCount();
        this.m_importCountComposed = globalImportCount - this.m_importNumber - 1;
        int count = this.getImportCount();
        if (count > 0) {
            this.m_endImportCountComposed += count;
            while (count > 0) {
                this.m_endImportCountComposed += this.getImport(--count).getEndImportCountComposed();
            }
        }
        count = this.getIncludeCountComposed();
        while (count > 0) {
            int imports = this.getIncludeComposed(--count).getImportCount();
            this.m_endImportCountComposed += imports;
            while (imports > 0) {
                this.m_endImportCountComposed += this.getIncludeComposed(count).getImport(--imports).getEndImportCountComposed();
            }
        }
    }

    public StylesheetComposed getImportComposed(int i) throws ArrayIndexOutOfBoundsException {
        StylesheetRoot root = this.getStylesheetRoot();
        return root.getGlobalImport(1 + this.m_importNumber + i);
    }

    public int getImportCountComposed() {
        return this.m_importCountComposed;
    }

    public int getEndImportCountComposed() {
        return this.m_endImportCountComposed;
    }

    void recomposeIncludes(Stylesheet including) {
        int n = including.getIncludeCount();
        if (n > 0) {
            if (null == this.m_includesComposed) {
                this.m_includesComposed = new Vector();
            }
            int i = 0;
            while (i < n) {
                Stylesheet included = including.getInclude(i);
                this.m_includesComposed.addElement(included);
                this.recomposeIncludes(included);
                ++i;
            }
        }
    }

    public Stylesheet getIncludeComposed(int i) throws ArrayIndexOutOfBoundsException {
        if (-1 == i) {
            return this;
        }
        if (null == this.m_includesComposed) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Stylesheet)this.m_includesComposed.elementAt(i);
    }

    public int getIncludeCountComposed() {
        return null != this.m_includesComposed ? this.m_includesComposed.size() : 0;
    }

    public void recomposeTemplates(boolean flushFirst) throws TransformerException {
    }
}

