/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.EarlTestCase;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.QueryUtils;

public class TestSerialization
extends EarlTestCase {
    static int count = 0;
    String queryString;
    TestItem testItem;

    public TestSerialization(String testName, EarlReport earl, TestItem t) {
        super(testName, t.getURI(), earl);
        this.testItem = t;
    }

    private void setTest(String testName, EarlReport earl, String _queryString) {
        super.setName(testName);
        this.queryString = _queryString;
    }

    protected void runTestForReal() throws Throwable {
        Query query2 = null;
        query2 = this.queryString == null ? this.queryFromTestItem(this.testItem) : this.queryFromString(this.queryString);
        this.runTestWorker(query2, query2.getSyntax());
    }

    protected void runTestWorker(Query query2, Syntax syntax) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        query2.serialize(buff, syntax);
        String baseURI = null;
        if (!query2.explicitlySetBaseURI()) {
            baseURI = query2.getBaseURI();
        }
        try {
            QueryUtils.checkParse(query2);
        }
        catch (RuntimeException ex) {
            System.err.println("**** Test: " + this.getName());
            System.err.println("** " + ex.getMessage());
            System.err.println(query2);
            throw ex;
        }
        try {
            QueryUtils.checkOp(query2);
        }
        catch (SSEParseException ex) {
            System.err.println("**** Test: " + this.getName());
            System.err.println("** Algebra error: " + ex.getMessage());
        }
    }
}

