/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.iri.Violation;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class URITests
extends TestCase {
    static IRIFactory factory = IRIFactory.jenaImplementation();

    public static Test suite() {
        TestSuite suite = new TestSuite("URIs");
        suite.addTest(new URITests("testNoDomain"));
        suite.addTest(new URITests("testLong"));
        suite.addTest(new URITests("testBadScheme"));
        suite.addTest(new URITests("testJustScheme"));
        suite.addTest(new URITests("testHostPortNoSlashWithFragment"));
        suite.addTest(new URITests("testHostNoSlashWithFragment"));
        suite.addTest(new URITests("testBadAuthority"));
        suite.addTest(new URITests("testTwoHashes"));
        suite.addTest(new URITests("testTwoHashes2"));
        return suite;
    }

    URITests(String s) {
        super(s);
    }

    public void testURI(String uri, boolean ok) {
        IRI ref = factory.create(uri);
        if (ok && ref.hasViolation(false)) {
            Violation v = (Violation)ref.violations(false).next();
            URITests.fail("<" + uri + "> is expected to be a URI, but: " + v.getLongMessage());
        }
        URITests.assertEquals("<" + uri + "> is" + (ok ? " " : " not ") + "a URI", ok, !ref.hasViolation(false));
    }

    public void testNoDomain() {
        this.testURI("app://calendar/event", true);
    }

    public void testLong() {
        this.testURI("http://46229EFFE16A9BD60B9F1BE88B2DB047ADDED785/demo.mp3", true);
    }

    public void testBadScheme() {
        this.testURI("ht^tp://www.w3.org/demo.mp3", false);
    }

    public void testFragmentLooksLikeScheme() {
        this.testURI("ht#tp://www.w3.org/demo.mp3", true);
    }

    public void testHostNoSlashWithFragment() {
        this.testURI("http://www.w#3.org/demo.mp3", true);
    }

    public void testHostPortNoSlashWithFragment() {
        this.testURI("http://www.w3.org:1#4/demo.mp3", true);
    }

    public void testBadHost() {
        this.testURI("http://www.w+3.org/demo.mp3", false);
    }

    public void testJustScheme() {
        this.testURI("http:", false);
    }

    public void testBadPort() {
        this.testURI("http://www.w3.org:1+4/demo.mp3", false);
    }

    public void testBadUserHost() {
        this.testURI("http://jjc@www.w@3.org/demo.mp3", false);
    }

    public void testBadAuthority() {
        this.testURI("http://jjc^3.org/demo.mp3", false);
    }

    public void testTwoHashes() {
        this.testURI("ht#tp://jjc3.org/demo.mp3#frag", false);
    }

    public void testTwoHashes2() {
        this.testURI("http://jjc#3.org/demo.mp3#frag", false);
    }
}

