/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Util;
import com.hp.hpl.jena.graph.query.ValuatorSet;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Iterator;
import java.util.Set;

public class GuardArranger {
    protected Set[] boundVariables;
    protected int size;

    public GuardArranger(Triple[] triples) {
        this.size = triples.length;
        this.boundVariables = this.makeBoundVariables(triples);
    }

    protected Set[] makeBoundVariables(Triple[] triples) {
        int length = triples.length;
        Set[] result = new Set[length];
        Set prev = CollectionFactory.createHashedSet();
        for (int i = 0; i < length; ++i) {
            prev = result[i] = Util.union(prev, Util.variablesOf(triples[i]));
        }
        return result;
    }

    public ValuatorSet[] makeGuards(Mapping map, ExpressionSet constraints) {
        return this.makeGuards(map, constraints, this.size);
    }

    protected ValuatorSet[] makeGuards(Mapping map, ExpressionSet constraints, int length) {
        ValuatorSet[] result = new ValuatorSet[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new ValuatorSet();
        }
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            this.plantWhereFullyBound((Expression)it.next(), it, map, result);
        }
        return result;
    }

    protected void plantWhereFullyBound(Expression e2, Iterator it, Mapping map, ValuatorSet[] es) {
        for (int i = 0; i < this.boundVariables.length; ++i) {
            if (!this.canEval(e2, i)) continue;
            es[i].add(e2.prepare(map));
            it.remove();
            return;
        }
    }

    protected boolean canEval(Expression e2, int index) {
        return Expression.Util.containsAllVariablesOf(this.boundVariables[index], e2);
    }
}

