/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.PortletSecurityException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockBaseURL
implements BaseURL {
    public static final String URL_TYPE_RENDER = "render";
    public static final String URL_TYPE_ACTION = "action";
    private static final String ENCODING = "UTF-8";
    protected final Map<String, String[]> parameters = new LinkedHashMap<String, String[]>();
    private boolean secure = false;
    private final Map<String, String[]> properties = new LinkedHashMap<String, String[]>();

    public void setParameter(String key, String value) {
        Assert.notNull(key, "Parameter key must be null");
        Assert.notNull(value, "Parameter value must not be null");
        this.parameters.put(key, new String[]{value});
    }

    public void setParameter(String key, String[] values) {
        Assert.notNull(key, "Parameter key must be null");
        Assert.notNull(values, "Parameter values must not be null");
        this.parameters.put(key, values);
    }

    public void setParameters(Map<String, String[]> parameters) {
        Assert.notNull(parameters, "Parameters Map must not be null");
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public String getParameter(String name) {
        String[] arr = this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void write(Writer out) throws IOException {
        out.write(this.toString());
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        out.write(this.toString());
    }

    public void addProperty(String key, String value) {
        String[] values = this.properties.get(key);
        if (values != null) {
            this.properties.put(key, StringUtils.addStringToArray(values, value));
        } else {
            this.properties.put(key, new String[]{value});
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, new String[]{value});
    }

    public Map<String, String[]> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected String encodeParameter(String name, String value) {
        try {
            return String.valueOf(URLEncoder.encode(name, ENCODING)) + "=" + URLEncoder.encode(value, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    protected String encodeParameter(String name, String[] values) {
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            int n = values.length;
            while (i < n) {
                sb.append(i > 0 ? ";" : "").append(URLEncoder.encode(name, ENCODING)).append("=").append(URLEncoder.encode(values[i], ENCODING));
                ++i;
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

