/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.AliasRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAliasRegistry
implements AliasRegistry {
    private final Map<String, String> aliasMap = new ConcurrentHashMap<String, String>();

    @Override
    public void registerAlias(String name, String alias) {
        Assert.hasText(name, "'name' must not be empty");
        Assert.hasText(alias, "'alias' must not be empty");
        if (alias.equals(name)) {
            this.aliasMap.remove(alias);
        } else {
            String registeredName;
            if (!this.allowAliasOverriding() && (registeredName = this.aliasMap.get(alias)) != null && !registeredName.equals(name)) {
                throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name + "': It is already registered for name '" + registeredName + "'.");
            }
            this.checkForAliasCircle(name, alias);
            this.aliasMap.put(alias, name);
        }
    }

    protected boolean allowAliasOverriding() {
        return true;
    }

    @Override
    public void removeAlias(String alias) {
        String name = this.aliasMap.remove(alias);
        if (name == null) {
            throw new IllegalStateException("No alias '" + alias + "' registered");
        }
    }

    @Override
    public boolean isAlias(String name) {
        return this.aliasMap.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAliases(String name) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> map = this.aliasMap;
        synchronized (map) {
            this.retrieveAliases(name, result);
        }
        return StringUtils.toStringArray(result);
    }

    private void retrieveAliases(String name, List<String> result) {
        for (Map.Entry<String, String> entry : this.aliasMap.entrySet()) {
            String registeredName = entry.getValue();
            if (!registeredName.equals(name)) continue;
            String alias = entry.getKey();
            result.add(alias);
            this.retrieveAliases(alias, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAliases(StringValueResolver valueResolver) {
        Assert.notNull(valueResolver, "StringValueResolver must not be null");
        Map<String, String> map = this.aliasMap;
        synchronized (map) {
            HashMap<String, String> aliasCopy = new HashMap<String, String>(this.aliasMap);
            for (String alias : aliasCopy.keySet()) {
                String resolvedName;
                String registeredName = (String)aliasCopy.get(alias);
                String resolvedAlias = valueResolver.resolveStringValue(alias);
                if (resolvedAlias.equals(resolvedName = valueResolver.resolveStringValue(registeredName))) {
                    this.aliasMap.remove(alias);
                    continue;
                }
                if (!resolvedAlias.equals(alias)) {
                    String existingName = this.aliasMap.get(resolvedAlias);
                    if (existingName != null && !existingName.equals(resolvedName)) {
                        throw new IllegalStateException("Cannot register resolved alias '" + resolvedAlias + "' (original: '" + alias + "') for name '" + resolvedName + "': It is already registered for name '" + registeredName + "'.");
                    }
                    this.checkForAliasCircle(resolvedName, resolvedAlias);
                    this.aliasMap.remove(alias);
                    this.aliasMap.put(resolvedAlias, resolvedName);
                    continue;
                }
                if (registeredName.equals(resolvedName)) continue;
                this.aliasMap.put(alias, resolvedName);
            }
        }
    }

    public String canonicalName(String name) {
        String resolvedName;
        String canonicalName = name;
        do {
            if ((resolvedName = this.aliasMap.get(canonicalName)) == null) continue;
            canonicalName = resolvedName;
        } while (resolvedName != null);
        return canonicalName;
    }

    protected void checkForAliasCircle(String name, String alias) {
        if (alias.equals(this.canonicalName(name))) {
            throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name + "': Circular reference - '" + name + "' is a direct or indirect alias for '" + alias + "' already");
        }
    }
}

