/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.DuplicateMappingException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.InvalidMappingException;
import org.hibernate.MappingException;
import org.hibernate.MappingNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.CopyIdentifierComponentSecondPass;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.MetadataSourceType;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.cfg.RecoverableException;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.SecondaryTableSecondPass;
import org.hibernate.cfg.SetSimpleValueTypeSecondPass;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.annotations.reflection.JPAMetadataProvider;
import org.hibernate.cfg.beanvalidation.BeanValidationActivator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreCollectionRecreateEventListener;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorAggregator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.factory.DefaultIdentifierGeneratorFactory;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.persister.PersisterClassProvider;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.secure.JACCConfiguration;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.IndexMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.hibernate.type.BasicType;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.SerializationHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.hibernate.util.xml.MappingReader;
import org.hibernate.util.xml.Origin;
import org.hibernate.util.xml.OriginImpl;
import org.hibernate.util.xml.XmlDocument;
import org.hibernate.util.xml.XmlDocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(Configuration.class);
    public static final String DEFAULT_CACHE_CONCURRENCY_STRATEGY = "hibernate.cache.default_cache_concurrency_strategy";
    public static final String USE_NEW_ID_GENERATOR_MAPPINGS = "hibernate.id.new_generator_mappings";
    public static final String ARTEFACT_PROCESSING_ORDER = "hibernate.mapping.precedence";
    private static final String SEARCH_STARTUP_CLASS = "org.hibernate.search.event.EventListenerRegister";
    private static final String SEARCH_STARTUP_METHOD = "enableHibernateSearch";
    protected MetadataSourceQueue metadataSourceQueue;
    private transient ReflectionManager reflectionManager;
    protected Map<String, PersistentClass> classes;
    protected Map<String, String> imports;
    protected Map<String, Collection> collections;
    protected Map<String, Table> tables;
    protected List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects;
    protected Map<String, NamedQueryDefinition> namedQueries;
    protected Map<String, NamedSQLQueryDefinition> namedSqlQueries;
    protected Map<String, ResultSetMappingDefinition> sqlResultSetMappings;
    protected Map<String, TypeDef> typeDefs;
    protected Map<String, FilterDefinition> filterDefinitions;
    protected Map<String, FetchProfile> fetchProfiles;
    protected Map tableNameBinding;
    protected Map columnNameBindingPerTable;
    protected List<SecondPass> secondPasses;
    protected List<Mappings.PropertyReference> propertyReferences;
    protected Map<ExtendsQueueEntry, ?> extendsQueue;
    protected Map<String, SQLFunction> sqlFunctions;
    private TypeResolver typeResolver = new TypeResolver();
    private EntityTuplizerFactory entityTuplizerFactory;
    private Interceptor interceptor;
    private Properties properties;
    private EntityResolver entityResolver;
    private EntityNotFoundDelegate entityNotFoundDelegate;
    protected transient XMLHelper xmlHelper;
    protected NamingStrategy namingStrategy;
    private PersisterClassProvider persisterClassProvider;
    private SessionFactoryObserver sessionFactoryObserver;
    private EventListeners eventListeners;
    protected final SettingsFactory settingsFactory;
    private transient Mapping mapping = this.buildMapping();
    private DefaultIdentifierGeneratorFactory identifierGeneratorFactory;
    private Map<Class<?>, org.hibernate.mapping.MappedSuperclass> mappedSuperClasses;
    private Map<String, IdGenerator> namedGenerators;
    private Map<String, Map<String, Join>> joins;
    private Map<String, AnnotatedClassType> classTypes;
    private Set<String> defaultNamedQueryNames;
    private Set<String> defaultNamedNativeQueryNames;
    private Set<String> defaultSqlResultSetMappingNames;
    private Set<String> defaultNamedGenerators;
    private Map<String, Properties> generatorTables;
    private Map<Table, List<UniqueConstraintHolder>> uniqueConstraintHoldersByTable;
    private Map<String, String> mappedByResolver;
    private Map<String, String> propertyRefResolver;
    private Map<String, AnyMetaDef> anyMetaDefs;
    private List<CacheHolder> caches;
    private boolean inSecondPass = false;
    private boolean isDefaultProcessed = false;
    private boolean isValidatorNotPresentLogged;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithMapsId;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithIdAndToOne;
    private boolean specjProprietarySyntaxEnabled;
    private static final String LEGACY_VALIDATOR_EVENT_LISTENER = "org.hibernate.validator.event.ValidateEventListener";
    private static final String SEARCH_EVENT_LISTENER_REGISTERER_CLASS = "org.hibernate.cfg.search.HibernateSearchEventListenerRegister";
    final ObjectNameNormalizer normalizer = new ObjectNameNormalizerImpl();
    public static final MetadataSourceType[] DEFAULT_ARTEFACT_PROCESSING_ORDER = new MetadataSourceType[]{MetadataSourceType.HBM, MetadataSourceType.CLASS};
    private List<MetadataSourceType> metadataSourcePrecedence;

    protected Configuration(SettingsFactory settingsFactory) {
        this.settingsFactory = settingsFactory;
        this.reset();
    }

    public Configuration() {
        this(new SettingsFactory());
    }

    protected void reset() {
        this.metadataSourceQueue = new MetadataSourceQueue();
        this.createReflectionManager();
        this.classes = new HashMap<String, PersistentClass>();
        this.imports = new HashMap<String, String>();
        this.collections = new HashMap<String, Collection>();
        this.tables = new TreeMap<String, Table>();
        this.namedQueries = new HashMap<String, NamedQueryDefinition>();
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>();
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>();
        this.typeDefs = new HashMap<String, TypeDef>();
        this.filterDefinitions = new HashMap<String, FilterDefinition>();
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        this.auxiliaryDatabaseObjects = new ArrayList<AuxiliaryDatabaseObject>();
        this.tableNameBinding = new HashMap();
        this.columnNameBindingPerTable = new HashMap();
        this.secondPasses = new ArrayList<SecondPass>();
        this.propertyReferences = new ArrayList<Mappings.PropertyReference>();
        this.extendsQueue = new HashMap();
        this.xmlHelper = new XMLHelper();
        this.interceptor = EmptyInterceptor.INSTANCE;
        this.properties = Environment.getProperties();
        this.entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        this.eventListeners = new EventListeners();
        this.sqlFunctions = new HashMap<String, SQLFunction>();
        this.entityTuplizerFactory = new EntityTuplizerFactory();
        this.identifierGeneratorFactory = new DefaultIdentifierGeneratorFactory();
        this.mappedSuperClasses = new HashMap();
        this.metadataSourcePrecedence = Collections.emptyList();
        this.namedGenerators = new HashMap<String, IdGenerator>();
        this.joins = new HashMap<String, Map<String, Join>>();
        this.classTypes = new HashMap<String, AnnotatedClassType>();
        this.generatorTables = new HashMap<String, Properties>();
        this.defaultNamedQueryNames = new HashSet<String>();
        this.defaultNamedNativeQueryNames = new HashSet<String>();
        this.defaultSqlResultSetMappingNames = new HashSet<String>();
        this.defaultNamedGenerators = new HashSet<String>();
        this.uniqueConstraintHoldersByTable = new HashMap<Table, List<UniqueConstraintHolder>>();
        this.mappedByResolver = new HashMap<String, String>();
        this.propertyRefResolver = new HashMap<String, String>();
        this.caches = new ArrayList<CacheHolder>();
        this.namingStrategy = EJB3NamingStrategy.INSTANCE;
        this.persisterClassProvider = null;
        this.setEntityResolver(new EJB3DTDEntityResolver());
        this.anyMetaDefs = new HashMap<String, AnyMetaDef>();
        this.propertiesAnnotatedWithMapsId = new HashMap<XClass, Map<String, PropertyData>>();
        this.propertiesAnnotatedWithIdAndToOne = new HashMap<XClass, Map<String, PropertyData>>();
        this.specjProprietarySyntaxEnabled = System.getProperty("hibernate.enable_specj_proprietary_syntax") != null;
    }

    public EntityTuplizerFactory getEntityTuplizerFactory() {
        return this.entityTuplizerFactory;
    }

    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    public Iterator<PersistentClass> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMappings() {
        return this.collections.values().iterator();
    }

    public Iterator<Table> getTableMappings() {
        return this.tables.values().iterator();
    }

    public Iterator<org.hibernate.mapping.MappedSuperclass> getMappedSuperclassMappings() {
        return this.mappedSuperClasses.values().iterator();
    }

    public PersistentClass getClassMapping(String entityName) {
        return this.classes.get(entityName);
    }

    public Collection getCollectionMapping(String role) {
        return this.collections.get(role);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    public void setEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.entityNotFoundDelegate = entityNotFoundDelegate;
    }

    public Configuration addFile(String xmlFile) throws MappingException {
        return this.addFile(new File(xmlFile));
    }

    public Configuration addFile(File xmlFile) throws MappingException {
        InputSource inputSource;
        log.info("Reading mappings from file: " + xmlFile.getPath());
        String name = xmlFile.getAbsolutePath();
        try {
            inputSource = new InputSource(new FileInputStream(xmlFile));
        }
        catch (FileNotFoundException e2) {
            throw new MappingNotFoundException("file", xmlFile.toString());
        }
        this.add(inputSource, "file", name);
        return this;
    }

    private XmlDocument add(InputSource inputSource, String originType, String originName) {
        return this.add(inputSource, new OriginImpl(originType, originName));
    }

    private XmlDocument add(InputSource inputSource, Origin origin) {
        XmlDocument metadataXml = MappingReader.INSTANCE.readMappingDocument(this.entityResolver, inputSource, origin);
        this.add(metadataXml);
        return metadataXml;
    }

    public void add(XmlDocument metadataXml) {
        if (this.inSecondPass || !Configuration.isOrmXml(metadataXml)) {
            this.metadataSourceQueue.add(metadataXml);
        } else {
            MetadataProvider metadataProvider = ((MetadataProviderInjector)((Object)this.reflectionManager)).getMetadataProvider();
            JPAMetadataProvider jpaMetadataProvider = (JPAMetadataProvider)metadataProvider;
            List<String> classNames = jpaMetadataProvider.getXMLContext().addDocument(metadataXml.getDocumentTree());
            for (String className : classNames) {
                try {
                    this.metadataSourceQueue.add(this.reflectionManager.classForName(className, this.getClass()));
                }
                catch (ClassNotFoundException e2) {
                    throw new AnnotationException("Unable to load class defined in XML: " + className, e2);
                }
            }
        }
    }

    private static boolean isOrmXml(XmlDocument xmlDocument) {
        return "entity-mappings".equals(xmlDocument.getDocumentTree().getRootElement().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration addCacheableFile(File xmlFile) throws MappingException {
        XmlDocument metadataXml;
        FileInputStream fileInputStream;
        File cachedFile = this.determineCachedDomFile(xmlFile);
        try {
            return this.addCacheableFileStrictly(xmlFile);
        }
        catch (SerializationException e2) {
            log.warn("Could not deserialize cache file: " + cachedFile.getPath() + " : " + e2);
        }
        catch (FileNotFoundException e3) {
            log.warn("I/O reported cached file could not be found : " + cachedFile.getPath() + " : " + e3);
        }
        String name = xmlFile.getAbsolutePath();
        try {
            fileInputStream = new FileInputStream(xmlFile);
        }
        catch (FileNotFoundException e4) {
            throw new MappingNotFoundException("file", xmlFile.toString());
        }
        try {
            InputSource inputSource = new InputSource(fileInputStream);
            log.info("Reading mappings from file: " + xmlFile);
            metadataXml = this.add(inputSource, "file", name);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException e5) {
                log.warn("I/O exception while closing mapping file : " + cachedFile.getPath() + " : " + e5);
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(cachedFile);
        }
        catch (FileNotFoundException e6) {
            log.warn("I/O reported error writing cached file : " + cachedFile.getPath(), e6);
        }
        if (fileInputStream != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Writing cache file for: " + xmlFile + " to: " + cachedFile);
                }
                SerializationHelper.serialize((Serializable)((Object)metadataXml.getDocumentTree()), fileOutputStream);
            }
            catch (SerializationException e7) {
                log.warn("Could not write cached file: " + cachedFile, e7);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException e8) {
                    log.warn("I/O exception while closing cache for mapping file : " + cachedFile + " : " + e8);
                }
            }
        }
        return this;
    }

    private File determineCachedDomFile(File xmlFile) {
        return new File(xmlFile.getAbsolutePath() + ".bin");
    }

    public Configuration addCacheableFileStrictly(File xmlFile) throws SerializationException, FileNotFoundException {
        boolean useCachedFile;
        File cachedFile = this.determineCachedDomFile(xmlFile);
        boolean bl = useCachedFile = xmlFile.exists() && cachedFile.exists() && xmlFile.lastModified() < cachedFile.lastModified();
        if (!useCachedFile) {
            throw new FileNotFoundException("Cached file could not be found or could not be used");
        }
        log.info("Reading mappings from cache file: " + cachedFile);
        org.dom4j.Document document = (org.dom4j.Document)SerializationHelper.deserialize(new FileInputStream(cachedFile));
        this.add(new XmlDocumentImpl(document, "file", xmlFile.getAbsolutePath()));
        return this;
    }

    public Configuration addCacheableFile(String xmlFile) throws MappingException {
        return this.addCacheableFile(new File(xmlFile));
    }

    public Configuration addXML(String xml) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug("Mapping XML:\n" + xml);
        }
        InputSource inputSource = new InputSource(new StringReader(xml));
        this.add(inputSource, "string", "XML String");
        return this;
    }

    public Configuration addURL(URL url) throws MappingException {
        String urlExternalForm = url.toExternalForm();
        if (log.isDebugEnabled()) {
            log.debug("Reading mapping document from URL : {}", (Object)urlExternalForm);
        }
        try {
            this.add(url.openStream(), "URL", urlExternalForm);
        }
        catch (IOException e2) {
            throw new InvalidMappingException("Unable to open url stream [" + urlExternalForm + "]", "URL", urlExternalForm, e2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlDocument add(InputStream inputStream, String type, String name) {
        InputSource inputSource = new InputSource(inputStream);
        try {
            XmlDocument xmlDocument = this.add(inputSource, type, name);
            return xmlDocument;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ignore) {
                log.trace("Was unable to close input stream");
            }
        }
    }

    public Configuration addDocument(Document doc) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug("Mapping document:\n" + doc);
        }
        org.dom4j.Document document = this.xmlHelper.createDOMReader().read(doc);
        this.add(new XmlDocumentImpl(document, "unknown", null));
        return this;
    }

    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        this.add(xmlInputStream, "input stream", null);
        return this;
    }

    public Configuration addResource(String resourceName, ClassLoader classLoader) throws MappingException {
        log.info("Reading mappings from resource: " + resourceName);
        InputStream resourceInputStream = classLoader.getResourceAsStream(resourceName);
        if (resourceInputStream == null) {
            throw new MappingNotFoundException("resource", resourceName);
        }
        this.add(resourceInputStream, "resource", resourceName);
        return this;
    }

    public Configuration addResource(String resourceName) throws MappingException {
        log.info("Reading mappings from resource : " + resourceName);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream resourceInputStream = null;
        if (contextClassLoader != null) {
            resourceInputStream = contextClassLoader.getResourceAsStream(resourceName);
        }
        if (resourceInputStream == null) {
            resourceInputStream = Environment.class.getClassLoader().getResourceAsStream(resourceName);
        }
        if (resourceInputStream == null) {
            throw new MappingNotFoundException("resource", resourceName);
        }
        this.add(resourceInputStream, "resource", resourceName);
        return this;
    }

    public Configuration addClass(Class persistentClass) throws MappingException {
        String mappingResourceName = persistentClass.getName().replace('.', '/') + ".hbm.xml";
        log.info("Reading mappings from resource: " + mappingResourceName);
        return this.addResource(mappingResourceName, persistentClass.getClassLoader());
    }

    public Configuration addAnnotatedClass(Class annotatedClass) {
        XClass xClass = this.reflectionManager.toXClass(annotatedClass);
        this.metadataSourceQueue.add(xClass);
        return this;
    }

    public Configuration addPackage(String packageName) throws MappingException {
        log.info("Mapping package {}", (Object)packageName);
        try {
            AnnotationBinder.bindPackage(packageName, this.createMappings());
            return this;
        }
        catch (MappingException me) {
            log.error("Could not parse the package-level metadata [" + packageName + "]");
            throw me;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration addJar(File jar) throws MappingException {
        log.info("Searching for mapping documents in jar: " + jar.getName());
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(jar);
            }
            catch (IOException ioe) {
                throw new InvalidMappingException("Could not read mapping documents from jar: " + jar.getName(), "jar", jar.getName(), ioe);
            }
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                ZipEntry ze = jarEntries.nextElement();
                if (!ze.getName().endsWith(".hbm.xml")) continue;
                log.info("Found mapping document in jar: " + ze.getName());
                try {
                    this.addInputStream(jarFile.getInputStream(ze));
                }
                catch (Exception e2) {
                    throw new InvalidMappingException("Could not read mapping documents from jar: " + jar.getName(), "jar", jar.getName(), e2);
                    return this;
                }
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException ioe) {
                log.error("could not close jar", ioe);
            }
        }
    }

    public Configuration addDirectory(File dir) throws MappingException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.addDirectory(file);
                continue;
            }
            if (!file.getName().endsWith(".hbm.xml")) continue;
            this.addFile(file);
        }
        return this;
    }

    public Mappings createMappings() {
        return new MappingsImpl();
    }

    private Iterator<IdentifierGenerator> iterateGenerators(Dialect dialect) throws MappingException {
        IdentifierGenerator ig;
        TreeMap<Object, IdentifierGenerator> generators = new TreeMap<Object, IdentifierGenerator>();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        for (PersistentClass pc : this.classes.values()) {
            if (pc.isInherited()) continue;
            ig = pc.getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, defaultCatalog, defaultSchema, (RootClass)pc);
            if (ig instanceof PersistentIdentifierGenerator) {
                generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
                continue;
            }
            if (!(ig instanceof IdentifierGeneratorAggregator)) continue;
            ((IdentifierGeneratorAggregator)((Object)ig)).registerPersistentGenerators(generators);
        }
        for (Collection collection : this.collections.values()) {
            if (!collection.isIdentified() || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, defaultCatalog, defaultSchema, null)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        Table table;
        this.secondPassCompile();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator<Object> itr = this.auxiliaryDatabaseObjects.listIterator(this.auxiliaryDatabaseObjects.size());
        while (itr.hasPrevious()) {
            AuxiliaryDatabaseObject object = itr.previous();
            if (!object.appliesToDialect(dialect)) continue;
            script.add(object.sqlDropString(dialect, defaultCatalog, defaultSchema));
        }
        if (dialect.dropConstraints()) {
            itr = this.getTableMappings();
            while (itr.hasNext()) {
                table = (Table)itr.next();
                if (!table.isPhysicalTable()) continue;
                Iterator subItr = table.getForeignKeyIterator();
                while (subItr.hasNext()) {
                    ForeignKey fk = (ForeignKey)subItr.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    script.add(fk.sqlDropString(dialect, defaultCatalog, defaultSchema));
                }
            }
        }
        itr = this.getTableMappings();
        while (itr.hasNext()) {
            table = (Table)itr.next();
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlDropString(dialect, defaultCatalog, defaultSchema));
        }
        itr = this.iterateGenerators(dialect);
        while (itr.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)itr.next()).sqlDropStrings(dialect);
            script.addAll(Arrays.asList(lines));
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        Iterator<Object> iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = iter.next();
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            Iterator comments = table.sqlCommentStrings(dialect, defaultCatalog, defaultSchema);
            while (comments.hasNext()) {
                script.add((String)comments.next());
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            Iterator subIter;
            table = iter.next();
            if (!table.isPhysicalTable()) continue;
            if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                subIter = table.getUniqueKeyIterator();
                while (subIter.hasNext()) {
                    UniqueKey uk = (UniqueKey)subIter.next();
                    String constraintString = uk.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema);
                    if (constraintString == null) continue;
                    script.add(constraintString);
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            }
            if (!dialect.hasAlterTable()) continue;
            subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey fk = (ForeignKey)subIter.next();
                if (!fk.isPhysicalConstraint()) continue;
                script.add(fk.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlCreateStrings(dialect);
            script.addAll(Arrays.asList(lines));
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.auxiliaryDatabaseObjects) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            script.add(auxiliaryDatabaseObject.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaUpdateScript(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        TableMetadata tableInfo;
        Table table;
        this.secondPassCompile();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator<Object> iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = iter.next();
            if (!table.isPhysicalTable()) continue;
            tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema() == null ? defaultSchema : table.getSchema(), table.getCatalog() == null ? defaultCatalog : table.getCatalog(), table.isQuoted());
            if (tableInfo == null) {
                script.add(table.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            } else {
                Iterator subiter = table.sqlAlterStrings(dialect, this.mapping, tableInfo, defaultCatalog, defaultSchema);
                while (subiter.hasNext()) {
                    script.add((String)subiter.next());
                }
            }
            Iterator comments = table.sqlCommentStrings(dialect, defaultCatalog, defaultSchema);
            while (comments.hasNext()) {
                script.add((String)comments.next());
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            Iterator subIter;
            table = iter.next();
            if (!table.isPhysicalTable()) continue;
            tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema(), table.getCatalog(), table.isQuoted());
            if (dialect.hasAlterTable()) {
                subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    boolean create;
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint() || !(create = tableInfo == null || tableInfo.getForeignKeyMetadata(fk) == null && (!(dialect instanceof MySQLDialect) || tableInfo.getIndexMetadata(fk.getName()) == null))) continue;
                    script.add(fk.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                IndexMetadata meta;
                Index index = (Index)subIter.next();
                if (tableInfo != null && StringHelper.isNotEmpty(index.getName()) && (meta = tableInfo.getIndexMetadata(index.getName())) != null) continue;
                script.add(index.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            String[] lines = generator.sqlCreateStrings(dialect);
            script.addAll(Arrays.asList(lines));
        }
        return ArrayHelper.toStringArray(script);
    }

    public void validateSchema(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        this.secondPassCompile();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        Iterator<Object> iter = this.getTableMappings();
        while (iter.hasNext()) {
            Table table = iter.next();
            if (!table.isPhysicalTable()) continue;
            TableMetadata tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema() == null ? defaultSchema : table.getSchema(), table.getCatalog() == null ? defaultCatalog : table.getCatalog(), table.isQuoted());
            if (tableInfo == null) {
                throw new HibernateException("Missing table: " + table.getName());
            }
            table.validateColumns(dialect, this.mapping, tableInfo);
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            throw new HibernateException("Missing sequence or table: " + key);
        }
    }

    private void validate() throws MappingException {
        Iterator<Filterable> iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            iter.next().validate(this.mapping);
        }
        iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            ((Collection)iter.next()).validate(this.mapping);
        }
    }

    public void buildMappings() {
        this.secondPassCompile();
    }

    protected void secondPassCompile() throws MappingException {
        log.trace("Starting secondPassCompile() processing");
        if (!this.isDefaultProcessed) {
            Object isDelimited = this.reflectionManager.getDefaults().get("delimited-identifier");
            if (isDelimited != null && isDelimited == Boolean.TRUE) {
                this.getProperties().put("hibernate.globally_quoted_identifiers", "true");
            }
            AnnotationBinder.bindDefaults(this.createMappings());
            this.isDefaultProcessed = true;
        }
        this.metadataSourceQueue.syncAnnotatedClasses();
        this.metadataSourceQueue.processMetadata(this.determineMetadataSourcePrecedence());
        for (CacheHolder cacheHolder : this.caches) {
            if (cacheHolder.isClass) {
                this.applyCacheConcurrencyStrategy(cacheHolder);
                continue;
            }
            this.applyCollectionCacheConcurrencyStrategy(cacheHolder);
        }
        this.caches.clear();
        try {
            this.inSecondPass = true;
            this.processSecondPassesOfType(PkDrivenByDefaultMapsIdSecondPass.class);
            this.processSecondPassesOfType(SetSimpleValueTypeSecondPass.class);
            this.processSecondPassesOfType(CopyIdentifierComponentSecondPass.class);
            this.processFkSecondPassInOrder();
            this.processSecondPassesOfType(CreateKeySecondPass.class);
            this.processSecondPassesOfType(SecondaryTableSecondPass.class);
            this.originalSecondPassCompile();
            this.inSecondPass = false;
        }
        catch (RecoverableException e2) {
            throw (RuntimeException)e2.getCause();
        }
        for (Map.Entry entry : this.uniqueConstraintHoldersByTable.entrySet()) {
            Table table = (Table)entry.getKey();
            List uniqueConstraints = (List)entry.getValue();
            int uniqueIndexPerTable = 0;
            for (UniqueConstraintHolder holder : uniqueConstraints) {
                String keyName = StringHelper.isEmpty(holder.getName()) ? "key" + ++uniqueIndexPerTable : holder.getName();
                this.buildUniqueKeyFromColumnNames(table, keyName, holder.getColumns());
            }
        }
        this.applyConstraintsToDDL();
    }

    private void processSecondPassesOfType(Class<? extends SecondPass> type) {
        Iterator<SecondPass> iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            SecondPass sp = iter.next();
            if (!type.isInstance(sp)) continue;
            sp.doSecondPass(this.classes);
            iter.remove();
        }
    }

    private void processFkSecondPassInOrder() {
        log.debug("processing fk mappings (*ToOne and JoinedSubclass)");
        List<FkSecondPass> fkSecondPasses = this.getFKSecondPassesOnly();
        if (fkSecondPasses.size() == 0) {
            return;
        }
        HashMap<String, Set<FkSecondPass>> isADependencyOf = new HashMap<String, Set<FkSecondPass>>();
        ArrayList<FkSecondPass> endOfQueueFkSecondPasses = new ArrayList<FkSecondPass>(fkSecondPasses.size());
        for (FkSecondPass sp : fkSecondPasses) {
            if (sp.isInPrimaryKey()) {
                String referenceEntityName = sp.getReferencedEntityName();
                PersistentClass classMapping = this.getClassMapping(referenceEntityName);
                String dependentTable = classMapping.getTable().getQuotedName();
                if (!isADependencyOf.containsKey(dependentTable)) {
                    isADependencyOf.put(dependentTable, new HashSet());
                }
                ((Set)isADependencyOf.get(dependentTable)).add(sp);
                continue;
            }
            endOfQueueFkSecondPasses.add(sp);
        }
        ArrayList<FkSecondPass> orderedFkSecondPasses = new ArrayList<FkSecondPass>(fkSecondPasses.size());
        for (String tableName : isADependencyOf.keySet()) {
            this.buildRecursiveOrderedFkSecondPasses(orderedFkSecondPasses, isADependencyOf, tableName, tableName);
        }
        for (FkSecondPass sp : orderedFkSecondPasses) {
            sp.doSecondPass(this.classes);
        }
        this.processEndOfQueue(endOfQueueFkSecondPasses);
    }

    private List<FkSecondPass> getFKSecondPassesOnly() {
        Iterator<SecondPass> iter = this.secondPasses.iterator();
        ArrayList<FkSecondPass> fkSecondPasses = new ArrayList<FkSecondPass>(this.secondPasses.size());
        while (iter.hasNext()) {
            SecondPass sp = iter.next();
            if (!(sp instanceof FkSecondPass)) continue;
            fkSecondPasses.add((FkSecondPass)sp);
            iter.remove();
        }
        return fkSecondPasses;
    }

    private void buildRecursiveOrderedFkSecondPasses(List<FkSecondPass> orderedFkSecondPasses, Map<String, Set<FkSecondPass>> isADependencyOf, String startTable, String currentTable) {
        Set<FkSecondPass> dependencies = isADependencyOf.get(currentTable);
        if (dependencies == null || dependencies.size() == 0) {
            return;
        }
        for (FkSecondPass sp : dependencies) {
            String dependentTable = sp.getValue().getTable().getQuotedName();
            if (dependentTable.compareTo(startTable) == 0) {
                StringBuilder sb = new StringBuilder("Foreign key circularity dependency involving the following tables: ");
                throw new AnnotationException(sb.toString());
            }
            this.buildRecursiveOrderedFkSecondPasses(orderedFkSecondPasses, isADependencyOf, startTable, dependentTable);
            if (orderedFkSecondPasses.contains(sp)) continue;
            orderedFkSecondPasses.add(0, sp);
        }
    }

    private void processEndOfQueue(List<FkSecondPass> endOfQueueFkSecondPasses) {
        boolean stopProcess = false;
        RuntimeException originalException = null;
        while (!stopProcess) {
            ArrayList<FkSecondPass> failingSecondPasses = new ArrayList<FkSecondPass>();
            ListIterator<FkSecondPass> it = endOfQueueFkSecondPasses.listIterator();
            while (it.hasNext()) {
                FkSecondPass pass = (FkSecondPass)it.next();
                try {
                    pass.doSecondPass(this.classes);
                }
                catch (RecoverableException e2) {
                    failingSecondPasses.add(pass);
                    if (originalException != null) continue;
                    originalException = (RuntimeException)e2.getCause();
                }
            }
            stopProcess = failingSecondPasses.size() == 0 || failingSecondPasses.size() == endOfQueueFkSecondPasses.size();
            endOfQueueFkSecondPasses = failingSecondPasses;
        }
        if (endOfQueueFkSecondPasses.size() > 0) {
            throw originalException;
        }
    }

    private void buildUniqueKeyFromColumnNames(Table table, String keyName, String[] columnNames) {
        keyName = this.normalizer.normalizeIdentifierQuoting(keyName);
        int size = columnNames.length;
        Column[] columns = new Column[size];
        HashSet<Column> unbound = new HashSet<Column>();
        HashSet<Column> unboundNoLogical = new HashSet<Column>();
        for (int index = 0; index < size; ++index) {
            String logicalColumnName = this.normalizer.normalizeIdentifierQuoting(columnNames[index]);
            try {
                String columnName = this.createMappings().getPhysicalColumnName(logicalColumnName, table);
                columns[index] = new Column(columnName);
                unbound.add(columns[index]);
                continue;
            }
            catch (MappingException e2) {
                unboundNoLogical.add(new Column(logicalColumnName));
            }
        }
        for (Column column : columns) {
            if (!table.containsColumn(column)) continue;
            UniqueKey uc = table.getOrCreateUniqueKey(keyName);
            uc.addColumn(table.getColumn(column));
            unbound.remove(column);
        }
        if (unbound.size() > 0 || unboundNoLogical.size() > 0) {
            StringBuilder sb = new StringBuilder("Unable to create unique key constraint (");
            for (String columnName : columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(") on table ").append(table.getName()).append(": ");
            for (Column column : unbound) {
                sb.append(column.getName()).append(", ");
            }
            for (Column column : unboundNoLogical) {
                sb.append(column.getName()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" not found");
            throw new AnnotationException(sb.toString());
        }
    }

    private void applyConstraintsToDDL() {
        boolean applyOnDdl = this.getProperties().getProperty("hibernate.validator.apply_to_ddl", "true").equalsIgnoreCase("true");
        if (!applyOnDdl) {
            return;
        }
        this.applyHibernateValidatorLegacyConstraintsOnDDL();
        this.applyBeanValidationConstraintsOnDDL();
    }

    private void applyHibernateValidatorLegacyConstraintsOnDDL() {
        Constructor validatorCtr = null;
        Method applyMethod = null;
        try {
            Class classValidator = ReflectHelper.classForName("org.hibernate.validator.ClassValidator", this.getClass());
            Class messageInterpolator = ReflectHelper.classForName("org.hibernate.validator.MessageInterpolator", this.getClass());
            validatorCtr = classValidator.getDeclaredConstructor(Class.class, ResourceBundle.class, messageInterpolator, Map.class, ReflectionManager.class);
            applyMethod = classValidator.getMethod("apply", PersistentClass.class);
        }
        catch (ClassNotFoundException e2) {
            if (!this.isValidatorNotPresentLogged) {
                log.info("Hibernate Validator not found: ignoring");
            }
            this.isValidatorNotPresentLogged = true;
        }
        catch (NoSuchMethodException e3) {
            throw new AnnotationException(e3);
        }
        if (applyMethod != null) {
            for (PersistentClass persistentClazz : this.classes.values()) {
                String className = persistentClazz.getClassName();
                if (!StringHelper.isNotEmpty(className)) continue;
                try {
                    Object validator = validatorCtr.newInstance(ReflectHelper.classForName(className), null, null, null, this.reflectionManager);
                    applyMethod.invoke(validator, persistentClazz);
                }
                catch (Exception e4) {
                    log.warn("Unable to apply constraints on DDL for " + className, e4);
                }
            }
        }
    }

    private void applyBeanValidationConstraintsOnDDL() {
        BeanValidationActivator.applyDDL(this.classes.values(), this.getProperties());
    }

    private void originalSecondPassCompile() throws MappingException {
        SecondPass sp;
        log.debug("processing extends queue");
        this.processExtendsQueue();
        log.debug("processing collection mappings");
        Iterator<Serializable> itr = this.secondPasses.iterator();
        while (itr.hasNext()) {
            sp = itr.next();
            if (sp instanceof QuerySecondPass) continue;
            sp.doSecondPass(this.classes);
            itr.remove();
        }
        log.debug("processing native query and ResultSetMapping mappings");
        itr = this.secondPasses.iterator();
        while (itr.hasNext()) {
            sp = itr.next();
            sp.doSecondPass(this.classes);
            itr.remove();
        }
        log.debug("processing association property references");
        for (Mappings.PropertyReference upr : this.propertyReferences) {
            PersistentClass clazz = this.getClassMapping(upr.referencedClass);
            if (clazz == null) {
                throw new MappingException("property-ref to unmapped class: " + upr.referencedClass);
            }
            Property prop = clazz.getReferencedProperty(upr.propertyName);
            if (!upr.unique) continue;
            ((SimpleValue)prop.getValue()).setAlternateUniqueKey(true);
        }
        log.debug("processing foreign key constraints");
        itr = this.getTableMappings();
        HashSet done = new HashSet();
        while (itr.hasNext()) {
            this.secondPassCompileForeignKeys((Table)itr.next(), done);
        }
    }

    private int processExtendsQueue() {
        log.debug("processing extends queue");
        int added = 0;
        ExtendsQueueEntry extendsQueueEntry = this.findPossibleExtends();
        while (extendsQueueEntry != null) {
            this.metadataSourceQueue.processHbmXml(extendsQueueEntry.getMetadataXml(), extendsQueueEntry.getEntityNames());
            extendsQueueEntry = this.findPossibleExtends();
        }
        if (this.extendsQueue.size() > 0) {
            Iterator<ExtendsQueueEntry> iterator = this.extendsQueue.keySet().iterator();
            StringBuffer buf = new StringBuffer("Following super classes referenced in extends not found: ");
            while (iterator.hasNext()) {
                ExtendsQueueEntry entry = iterator.next();
                buf.append(entry.getExplicitName());
                if (entry.getMappingPackage() != null) {
                    buf.append("[").append(entry.getMappingPackage()).append("]");
                }
                if (!iterator.hasNext()) continue;
                buf.append(",");
            }
            throw new MappingException(buf.toString());
        }
        return added;
    }

    protected ExtendsQueueEntry findPossibleExtends() {
        Iterator<ExtendsQueueEntry> itr = this.extendsQueue.keySet().iterator();
        while (itr.hasNext()) {
            ExtendsQueueEntry entry = itr.next();
            boolean found = this.getClassMapping(entry.getExplicitName()) != null || this.getClassMapping(HbmBinder.getClassName(entry.getExplicitName(), entry.getMappingPackage())) != null;
            if (!found) continue;
            itr.remove();
            return entry;
        }
        return null;
    }

    protected void secondPassCompileForeignKeys(Table table, Set done) throws MappingException {
        table.createForeignKeys();
        Iterator iter = table.getForeignKeyIterator();
        while (iter.hasNext()) {
            PersistentClass referencedClass;
            ForeignKey fk = (ForeignKey)iter.next();
            if (done.contains(fk)) continue;
            done.add(fk);
            String referencedEntityName = fk.getReferencedEntityName();
            if (referencedEntityName == null) {
                throw new MappingException("An association from the table " + fk.getTable().getName() + " does not specify the referenced entity");
            }
            if (log.isDebugEnabled()) {
                log.debug("resolving reference to class: " + referencedEntityName);
            }
            if ((referencedClass = this.classes.get(referencedEntityName)) == null) {
                throw new MappingException("An association from the table " + fk.getTable().getName() + " refers to an unmapped class: " + referencedEntityName);
            }
            if (referencedClass.isJoinedSubclass()) {
                this.secondPassCompileForeignKeys(referencedClass.getSuperclass().getTable(), done);
            }
            fk.setReferencedTable(referencedClass.getTable());
            fk.alignColumns();
        }
    }

    public Map<String, NamedQueryDefinition> getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        log.debug("Preparing to build session factory with filters : " + this.filterDefinitions);
        this.secondPassCompile();
        if (!this.metadataSourceQueue.isEmpty()) {
            log.warn("mapping metadata cache was not completely processed");
        }
        this.enableLegacyHibernateValidator();
        this.enableBeanValidation();
        this.enableHibernateSearch();
        this.validate();
        Environment.verifyProperties(this.properties);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        PropertiesHelper.resolvePlaceHolders(copy);
        Settings settings = this.buildSettings(copy);
        return new SessionFactoryImpl(this, this.mapping, settings, this.getInitializedEventListeners(), this.sessionFactoryObserver);
    }

    private void enableLegacyHibernateValidator() {
        boolean enableValidatorListeners = !"false".equalsIgnoreCase(this.getProperty("hibernate.validator.autoregister_listeners"));
        Class validateEventListenerClass = null;
        try {
            validateEventListenerClass = ReflectHelper.classForName(LEGACY_VALIDATOR_EVENT_LISTENER, Configuration.class);
        }
        catch (ClassNotFoundException e2) {
            log.debug("Legacy Validator not present in classpath, ignoring event listener registration");
        }
        if (enableValidatorListeners && validateEventListenerClass != null) {
            Object validateEventListener;
            try {
                validateEventListener = validateEventListenerClass.newInstance();
            }
            catch (Exception e3) {
                throw new AnnotationException("Unable to load Validator event listener", e3);
            }
            boolean present = false;
            Serializable[] listeners = this.getEventListeners().getPreInsertEventListeners();
            if (listeners != null) {
                for (Serializable eventListener : listeners) {
                    present = present || validateEventListenerClass == eventListener.getClass();
                }
                if (!present) {
                    int length = listeners.length + 1;
                    PreInsertEventListener[] newListeners = new PreInsertEventListener[length];
                    System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                    newListeners[length - 1] = (PreInsertEventListener)validateEventListener;
                    this.getEventListeners().setPreInsertEventListeners(newListeners);
                }
            } else {
                this.getEventListeners().setPreInsertEventListeners(new PreInsertEventListener[]{(PreInsertEventListener)validateEventListener});
            }
            present = false;
            listeners = this.getEventListeners().getPreUpdateEventListeners();
            if (listeners != null) {
                for (Serializable eventListener : listeners) {
                    present = present || validateEventListenerClass == eventListener.getClass();
                }
                if (!present) {
                    int length = listeners.length + 1;
                    PreUpdateEventListener[] newListeners = new PreUpdateEventListener[length];
                    System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                    newListeners[length - 1] = (PreUpdateEventListener)validateEventListener;
                    this.getEventListeners().setPreUpdateEventListeners(newListeners);
                }
            } else {
                this.getEventListeners().setPreUpdateEventListeners(new PreUpdateEventListener[]{(PreUpdateEventListener)validateEventListener});
            }
        }
    }

    private void enableBeanValidation() {
        BeanValidationActivator.activateBeanValidation(this.getEventListeners(), this.getProperties());
    }

    private void enableHibernateSearch() {
        Class searchStartupClass;
        try {
            searchStartupClass = ReflectHelper.classForName(SEARCH_STARTUP_CLASS, this.getClass());
        }
        catch (ClassNotFoundException e2) {
            try {
                searchStartupClass = ReflectHelper.classForName(SEARCH_EVENT_LISTENER_REGISTERER_CLASS, this.getClass());
            }
            catch (ClassNotFoundException cnfe) {
                log.debug("Search not present in classpath, ignoring event listener registration.");
                return;
            }
        }
        try {
            Object searchStartupInstance = searchStartupClass.newInstance();
            Method enableSearchMethod = searchStartupClass.getDeclaredMethod(SEARCH_STARTUP_METHOD, EventListeners.class, Properties.class);
            enableSearchMethod.invoke(searchStartupInstance, this.getEventListeners(), this.getProperties());
        }
        catch (InstantiationException e3) {
            log.debug("Unable to instantiate {}, ignoring event listener registration.", (Object)SEARCH_STARTUP_CLASS);
        }
        catch (IllegalAccessException e4) {
            log.debug("Unable to instantiate {}, ignoring event listener registration.", (Object)SEARCH_STARTUP_CLASS);
        }
        catch (NoSuchMethodException e5) {
            log.debug("Method enableHibernateSearch() not found in {}.", (Object)SEARCH_STARTUP_CLASS);
        }
        catch (InvocationTargetException e6) {
            log.debug("Unable to execute {}, ignoring event listener registration.", (Object)SEARCH_STARTUP_METHOD);
        }
    }

    private EventListeners getInitializedEventListeners() {
        EventListeners result = (EventListeners)this.eventListeners.shallowCopy();
        result.initializeListeners(this);
        return result;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Configuration addProperties(Properties extraProperties) {
        this.properties.putAll((Map<?, ?>)extraProperties);
        return this;
    }

    public Configuration mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public Configuration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    private void addProperties(Element parent) {
        Iterator itr = parent.elementIterator("property");
        while (itr.hasNext()) {
            Element node = (Element)itr.next();
            String name = node.attributeValue("name");
            String value = node.getText().trim();
            log.debug(name + "=" + value);
            this.properties.setProperty(name, value);
            if (name.startsWith("hibernate")) continue;
            this.properties.setProperty("hibernate." + name, value);
        }
        Environment.verifyProperties(this.properties);
    }

    public Configuration configure() throws HibernateException {
        this.configure("/hibernate.cfg.xml");
        return this;
    }

    public Configuration configure(String resource) throws HibernateException {
        log.info("configuring from resource: " + resource);
        InputStream stream = this.getConfigurationInputStream(resource);
        return this.doConfigure(stream, resource);
    }

    protected InputStream getConfigurationInputStream(String resource) throws HibernateException {
        log.info("Configuration resource: " + resource);
        return ConfigHelper.getResourceAsStream(resource);
    }

    public Configuration configure(URL url) throws HibernateException {
        log.info("configuring from url: " + url.toString());
        try {
            return this.doConfigure(url.openStream(), url.toString());
        }
        catch (IOException ioe) {
            throw new HibernateException("could not configure from URL: " + url, ioe);
        }
    }

    public Configuration configure(File configFile) throws HibernateException {
        log.info("configuring from file: " + configFile.getName());
        try {
            return this.doConfigure(new FileInputStream(configFile), configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new HibernateException("could not find file: " + configFile, fnfe);
        }
    }

    protected Configuration doConfigure(InputStream stream, String resourceName) throws HibernateException {
        try {
            ArrayList errors = new ArrayList();
            org.dom4j.Document document = this.xmlHelper.createSAXReader(resourceName, errors, this.entityResolver).read(new InputSource(stream));
            if (errors.size() != 0) {
                throw new MappingException("invalid configuration", (Throwable)errors.get(0));
            }
            this.doConfigure(document);
        }
        catch (DocumentException e2) {
            throw new HibernateException("Could not parse configuration: " + resourceName, e2);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                log.warn("could not close input stream for: " + resourceName, ioe);
            }
        }
        return this;
    }

    public Configuration configure(Document document) throws HibernateException {
        log.info("configuring from XML document");
        return this.doConfigure(this.xmlHelper.createDOMReader().read(document));
    }

    protected Configuration doConfigure(org.dom4j.Document doc) throws HibernateException {
        Element sfNode = doc.getRootElement().element("session-factory");
        String name = sfNode.attributeValue("name");
        if (name != null) {
            this.properties.setProperty("hibernate.session_factory_name", name);
        }
        this.addProperties(sfNode);
        this.parseSessionFactory(sfNode, name);
        Element secNode = doc.getRootElement().element("security");
        if (secNode != null) {
            this.parseSecurity(secNode);
        }
        log.info("Configured SessionFactory: " + name);
        log.debug("properties: " + this.properties);
        return this;
    }

    private void parseSessionFactory(Element sfNode, String name) {
        Iterator elements = sfNode.elementIterator();
        while (elements.hasNext()) {
            String region;
            Attribute regionNode;
            Element subelement = (Element)elements.next();
            String subelementName = subelement.getName();
            if ("mapping".equals(subelementName)) {
                this.parseMappingElement(subelement, name);
                continue;
            }
            if ("class-cache".equals(subelementName)) {
                String className = subelement.attributeValue("class");
                regionNode = subelement.attribute("region");
                region = regionNode == null ? className : regionNode.getValue();
                boolean includeLazy = !"non-lazy".equals(subelement.attributeValue("include"));
                this.setCacheConcurrencyStrategy(className, subelement.attributeValue("usage"), region, includeLazy);
                continue;
            }
            if ("collection-cache".equals(subelementName)) {
                String role = subelement.attributeValue("collection");
                regionNode = subelement.attribute("region");
                region = regionNode == null ? role : regionNode.getValue();
                this.setCollectionCacheConcurrencyStrategy(role, subelement.attributeValue("usage"), region);
                continue;
            }
            if ("listener".equals(subelementName)) {
                this.parseListener(subelement);
                continue;
            }
            if (!"event".equals(subelementName)) continue;
            this.parseEvent(subelement);
        }
    }

    private void parseMappingElement(Element mappingElement, String name) {
        Attribute resourceAttribute = mappingElement.attribute("resource");
        Attribute fileAttribute = mappingElement.attribute("file");
        Attribute jarAttribute = mappingElement.attribute("jar");
        Attribute packageAttribute = mappingElement.attribute("package");
        Attribute classAttribute = mappingElement.attribute("class");
        if (resourceAttribute != null) {
            String resourceName = resourceAttribute.getValue();
            log.debug("session-factory config [{}] named resource [{}] for mapping", (Object)name, (Object)resourceName);
            this.addResource(resourceName);
        } else if (fileAttribute != null) {
            String fileName = fileAttribute.getValue();
            log.debug("session-factory config [{}] named file [{}] for mapping", (Object)name, (Object)fileName);
            this.addFile(fileName);
        } else if (jarAttribute != null) {
            String jarFileName = jarAttribute.getValue();
            log.debug("session-factory config [{}] named jar file [{}] for mapping", (Object)name, (Object)jarFileName);
            this.addJar(new File(jarFileName));
        } else if (packageAttribute != null) {
            String packageName = packageAttribute.getValue();
            log.debug("session-factory config [{}] named package [{}] for mapping", (Object)name, (Object)packageName);
            this.addPackage(packageName);
        } else if (classAttribute != null) {
            String className = classAttribute.getValue();
            log.debug("session-factory config [{}] named class [{}] for mapping", (Object)name, (Object)className);
            try {
                this.addAnnotatedClass(ReflectHelper.classForName(className));
            }
            catch (Exception e2) {
                throw new MappingException("Unable to load class [ " + className + "] declared in Hibernate configuration <mapping/> entry", e2);
            }
        } else {
            throw new MappingException("<mapping> element in configuration specifies no known attributes");
        }
    }

    private void parseSecurity(Element secNode) {
        String contextId = secNode.attributeValue("context");
        this.setProperty("hibernate.jacc_context_id", contextId);
        log.info("JACC contextID: " + contextId);
        JACCConfiguration jcfg = new JACCConfiguration(contextId);
        Iterator grantElements = secNode.elementIterator();
        while (grantElements.hasNext()) {
            Element grantElement = (Element)grantElements.next();
            String elementName = grantElement.getName();
            if (!"grant".equals(elementName)) continue;
            jcfg.addPermission(grantElement.attributeValue("role"), grantElement.attributeValue("entity-name"), grantElement.attributeValue("actions"));
        }
    }

    private void parseEvent(Element element) {
        String type = element.attributeValue("type");
        List listeners = element.elements();
        Object[] listenerClasses = new String[listeners.size()];
        for (int i = 0; i < listeners.size(); ++i) {
            listenerClasses[i] = ((Element)listeners.get(i)).attributeValue("class");
        }
        log.debug("Event listeners: " + type + "=" + StringHelper.toString(listenerClasses));
        this.setListeners(type, (String[])listenerClasses);
    }

    private void parseListener(Element element) {
        String type = element.attributeValue("type");
        if (type == null) {
            throw new MappingException("No type specified for listener");
        }
        String impl = element.attributeValue("class");
        log.debug("Event listener: " + type + "=" + impl);
        this.setListeners(type, new String[]{impl});
    }

    public void setListener(String type, String listener) {
        String[] listeners = null;
        if (listener != null) {
            listeners = (String[])Array.newInstance(String.class, 1);
            listeners[0] = listener;
        }
        this.setListeners(type, listeners);
    }

    public void setListeners(String type, String[] listenerClasses) {
        Object[] listeners = null;
        if (listenerClasses != null) {
            listeners = (Object[])Array.newInstance(this.eventListeners.getListenerClassFor(type), listenerClasses.length);
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i] = ReflectHelper.classForName(listenerClasses[i]).newInstance();
                    continue;
                }
                catch (Exception e2) {
                    throw new MappingException("Unable to instantiate specified event (" + type + ") listener class: " + listenerClasses[i], e2);
                }
            }
        }
        this.setListeners(type, listeners);
    }

    public void setListener(String type, Object listener) {
        Object[] listeners = null;
        if (listener != null) {
            listeners = (Object[])Array.newInstance(this.eventListeners.getListenerClassFor(type), 1);
            listeners[0] = listener;
        }
        this.setListeners(type, listeners);
    }

    public void setListeners(String type, Object[] listeners) {
        if ("auto-flush".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setAutoFlushEventListeners(new AutoFlushEventListener[0]);
            } else {
                this.eventListeners.setAutoFlushEventListeners((AutoFlushEventListener[])listeners);
            }
        } else if ("merge".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setMergeEventListeners(new MergeEventListener[0]);
            } else {
                this.eventListeners.setMergeEventListeners((MergeEventListener[])listeners);
            }
        } else if ("create".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPersistEventListeners(new PersistEventListener[0]);
            } else {
                this.eventListeners.setPersistEventListeners((PersistEventListener[])listeners);
            }
        } else if ("create-onflush".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPersistOnFlushEventListeners(new PersistEventListener[0]);
            } else {
                this.eventListeners.setPersistOnFlushEventListeners((PersistEventListener[])listeners);
            }
        } else if ("delete".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setDeleteEventListeners(new DeleteEventListener[0]);
            } else {
                this.eventListeners.setDeleteEventListeners((DeleteEventListener[])listeners);
            }
        } else if ("dirty-check".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setDirtyCheckEventListeners(new DirtyCheckEventListener[0]);
            } else {
                this.eventListeners.setDirtyCheckEventListeners((DirtyCheckEventListener[])listeners);
            }
        } else if ("evict".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setEvictEventListeners(new EvictEventListener[0]);
            } else {
                this.eventListeners.setEvictEventListeners((EvictEventListener[])listeners);
            }
        } else if ("flush".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setFlushEventListeners(new FlushEventListener[0]);
            } else {
                this.eventListeners.setFlushEventListeners((FlushEventListener[])listeners);
            }
        } else if ("flush-entity".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setFlushEntityEventListeners(new FlushEntityEventListener[0]);
            } else {
                this.eventListeners.setFlushEntityEventListeners((FlushEntityEventListener[])listeners);
            }
        } else if ("load".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setLoadEventListeners(new LoadEventListener[0]);
            } else {
                this.eventListeners.setLoadEventListeners((LoadEventListener[])listeners);
            }
        } else if ("load-collection".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setInitializeCollectionEventListeners(new InitializeCollectionEventListener[0]);
            } else {
                this.eventListeners.setInitializeCollectionEventListeners((InitializeCollectionEventListener[])listeners);
            }
        } else if ("lock".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setLockEventListeners(new LockEventListener[0]);
            } else {
                this.eventListeners.setLockEventListeners((LockEventListener[])listeners);
            }
        } else if ("refresh".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setRefreshEventListeners(new RefreshEventListener[0]);
            } else {
                this.eventListeners.setRefreshEventListeners((RefreshEventListener[])listeners);
            }
        } else if ("replicate".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setReplicateEventListeners(new ReplicateEventListener[0]);
            } else {
                this.eventListeners.setReplicateEventListeners((ReplicateEventListener[])listeners);
            }
        } else if ("save-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setSaveOrUpdateEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setSaveOrUpdateEventListeners((SaveOrUpdateEventListener[])listeners);
            }
        } else if ("save".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setSaveEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setSaveEventListeners((SaveOrUpdateEventListener[])listeners);
            }
        } else if ("update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setUpdateEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setUpdateEventListeners((SaveOrUpdateEventListener[])listeners);
            }
        } else if ("pre-load".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreLoadEventListeners(new PreLoadEventListener[0]);
            } else {
                this.eventListeners.setPreLoadEventListeners((PreLoadEventListener[])listeners);
            }
        } else if ("pre-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreUpdateEventListeners(new PreUpdateEventListener[0]);
            } else {
                this.eventListeners.setPreUpdateEventListeners((PreUpdateEventListener[])listeners);
            }
        } else if ("pre-delete".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreDeleteEventListeners(new PreDeleteEventListener[0]);
            } else {
                this.eventListeners.setPreDeleteEventListeners((PreDeleteEventListener[])listeners);
            }
        } else if ("pre-insert".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreInsertEventListeners(new PreInsertEventListener[0]);
            } else {
                this.eventListeners.setPreInsertEventListeners((PreInsertEventListener[])listeners);
            }
        } else if ("pre-collection-recreate".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreCollectionRecreateEventListeners(new PreCollectionRecreateEventListener[0]);
            } else {
                this.eventListeners.setPreCollectionRecreateEventListeners((PreCollectionRecreateEventListener[])listeners);
            }
        } else if ("pre-collection-remove".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreCollectionRemoveEventListeners(new PreCollectionRemoveEventListener[0]);
            } else {
                this.eventListeners.setPreCollectionRemoveEventListeners((PreCollectionRemoveEventListener[])listeners);
            }
        } else if ("pre-collection-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPreCollectionUpdateEventListeners(new PreCollectionUpdateEventListener[0]);
            } else {
                this.eventListeners.setPreCollectionUpdateEventListeners((PreCollectionUpdateEventListener[])listeners);
            }
        } else if ("post-load".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostLoadEventListeners(new PostLoadEventListener[0]);
            } else {
                this.eventListeners.setPostLoadEventListeners((PostLoadEventListener[])listeners);
            }
        } else if ("post-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostUpdateEventListeners(new PostUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostUpdateEventListeners((PostUpdateEventListener[])listeners);
            }
        } else if ("post-delete".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostDeleteEventListeners(new PostDeleteEventListener[0]);
            } else {
                this.eventListeners.setPostDeleteEventListeners((PostDeleteEventListener[])listeners);
            }
        } else if ("post-insert".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostInsertEventListeners(new PostInsertEventListener[0]);
            } else {
                this.eventListeners.setPostInsertEventListeners((PostInsertEventListener[])listeners);
            }
        } else if ("post-commit-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCommitUpdateEventListeners(new PostUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostCommitUpdateEventListeners((PostUpdateEventListener[])listeners);
            }
        } else if ("post-commit-delete".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCommitDeleteEventListeners(new PostDeleteEventListener[0]);
            } else {
                this.eventListeners.setPostCommitDeleteEventListeners((PostDeleteEventListener[])listeners);
            }
        } else if ("post-commit-insert".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCommitInsertEventListeners(new PostInsertEventListener[0]);
            } else {
                this.eventListeners.setPostCommitInsertEventListeners((PostInsertEventListener[])listeners);
            }
        } else if ("post-collection-recreate".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCollectionRecreateEventListeners(new PostCollectionRecreateEventListener[0]);
            } else {
                this.eventListeners.setPostCollectionRecreateEventListeners((PostCollectionRecreateEventListener[])listeners);
            }
        } else if ("post-collection-remove".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCollectionRemoveEventListeners(new PostCollectionRemoveEventListener[0]);
            } else {
                this.eventListeners.setPostCollectionRemoveEventListeners((PostCollectionRemoveEventListener[])listeners);
            }
        } else if ("post-collection-update".equals(type)) {
            if (listeners == null) {
                this.eventListeners.setPostCollectionUpdateEventListeners(new PostCollectionUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostCollectionUpdateEventListeners((PostCollectionUpdateEventListener[])listeners);
            }
        } else {
            throw new MappingException("Unrecognized listener type [" + type + "]");
        }
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    RootClass getRootClassMapping(String clazz) throws MappingException {
        try {
            return (RootClass)this.getClassMapping(clazz);
        }
        catch (ClassCastException cce) {
            throw new MappingException("You may only specify a cache for root <class> mappings");
        }
    }

    public Configuration setCacheConcurrencyStrategy(String entityName, String concurrencyStrategy) {
        this.setCacheConcurrencyStrategy(entityName, concurrencyStrategy, entityName);
        return this;
    }

    public Configuration setCacheConcurrencyStrategy(String entityName, String concurrencyStrategy, String region) {
        this.setCacheConcurrencyStrategy(entityName, concurrencyStrategy, region, true);
        return this;
    }

    public void setCacheConcurrencyStrategy(String entityName, String concurrencyStrategy, String region, boolean cacheLazyProperty) throws MappingException {
        this.caches.add(new CacheHolder(entityName, concurrencyStrategy, region, true, cacheLazyProperty));
    }

    private void applyCacheConcurrencyStrategy(CacheHolder holder) {
        RootClass rootClass = this.getRootClassMapping(holder.role);
        if (rootClass == null) {
            throw new MappingException("Cannot cache an unknown entity: " + holder.role);
        }
        rootClass.setCacheConcurrencyStrategy(holder.usage);
        rootClass.setCacheRegionName(holder.region);
        rootClass.setLazyPropertiesCacheable(holder.cacheLazy);
    }

    public Configuration setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy) {
        this.setCollectionCacheConcurrencyStrategy(collectionRole, concurrencyStrategy, collectionRole);
        return this;
    }

    public void setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy, String region) {
        this.caches.add(new CacheHolder(collectionRole, concurrencyStrategy, region, false, false));
    }

    private void applyCollectionCacheConcurrencyStrategy(CacheHolder holder) {
        Collection collection = this.getCollectionMapping(holder.role);
        if (collection == null) {
            throw new MappingException("Cannot cache an unknown collection: " + holder.role);
        }
        collection.setCacheConcurrencyStrategy(holder.usage);
        collection.setCacheRegionName(holder.region);
    }

    public Map<String, String> getImports() {
        return this.imports;
    }

    public Settings buildSettings() {
        Properties clone = (Properties)this.properties.clone();
        PropertiesHelper.resolvePlaceHolders(clone);
        return this.buildSettingsInternal(clone);
    }

    public Settings buildSettings(Properties props) throws HibernateException {
        return this.buildSettingsInternal(props);
    }

    private Settings buildSettingsInternal(Properties props) {
        Settings settings = this.settingsFactory.buildSettings(props);
        settings.setEntityTuplizerFactory(this.getEntityTuplizerFactory());
        return settings;
    }

    public Map getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public Map getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public Configuration setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    public PersisterClassProvider getPersisterClassProvider() {
        return this.persisterClassProvider;
    }

    public Configuration setPersisterClassProvider(PersisterClassProvider persisterClassProvider) {
        this.persisterClassProvider = persisterClassProvider;
        return this;
    }

    public DefaultIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.identifierGeneratorFactory;
    }

    public Mapping buildMapping() {
        return new Mapping(){

            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return Configuration.this.identifierGeneratorFactory;
            }

            public Type getIdentifierType(String entityName) throws MappingException {
                PersistentClass pc = Configuration.this.classes.get(entityName);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + entityName);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String entityName) throws MappingException {
                PersistentClass pc = Configuration.this.classes.get(entityName);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + entityName);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String entityName, String propertyName) throws MappingException {
                PersistentClass pc = Configuration.this.classes.get(entityName);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + entityName);
                }
                Property prop = pc.getReferencedProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + entityName + '.' + propertyName);
                }
                return prop.getType();
            }
        };
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        MetadataProvider metadataProvider = (MetadataProvider)ois.readObject();
        this.mapping = this.buildMapping();
        this.xmlHelper = new XMLHelper();
        this.createReflectionManager(metadataProvider);
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        MetadataProvider metadataProvider = ((MetadataProviderInjector)((Object)this.reflectionManager)).getMetadataProvider();
        out.writeObject(metadataProvider);
        out.defaultWriteObject();
    }

    private void createReflectionManager() {
        this.createReflectionManager(new JPAMetadataProvider());
    }

    private void createReflectionManager(MetadataProvider metadataProvider) {
        this.reflectionManager = new JavaReflectionManager();
        ((MetadataProviderInjector)((Object)this.reflectionManager)).setMetadataProvider(metadataProvider);
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition definition) {
        this.filterDefinitions.put(definition.getFilterName(), definition);
    }

    public Iterator iterateFetchProfiles() {
        return this.fetchProfiles.values().iterator();
    }

    public void addFetchProfile(FetchProfile fetchProfile) {
        this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject object) {
        this.auxiliaryDatabaseObjects.add(object);
    }

    public Map getSqlFunctions() {
        return this.sqlFunctions;
    }

    public void addSqlFunction(String functionName, SQLFunction function) {
        this.sqlFunctions.put(functionName, function);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void registerTypeOverride(BasicType type) {
        this.getTypeResolver().registerTypeOverride(type);
    }

    public void registerTypeOverride(UserType type, String[] keys) {
        this.getTypeResolver().registerTypeOverride(type, keys);
    }

    public void registerTypeOverride(CompositeUserType type, String[] keys) {
        this.getTypeResolver().registerTypeOverride(type, keys);
    }

    public SessionFactoryObserver getSessionFactoryObserver() {
        return this.sessionFactoryObserver;
    }

    public void setSessionFactoryObserver(SessionFactoryObserver sessionFactoryObserver) {
        this.sessionFactoryObserver = sessionFactoryObserver;
    }

    private List<MetadataSourceType> determineMetadataSourcePrecedence() {
        if (this.metadataSourcePrecedence.isEmpty() && StringHelper.isNotEmpty(this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER))) {
            this.metadataSourcePrecedence = this.parsePrecedence(this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER));
        }
        if (this.metadataSourcePrecedence.isEmpty()) {
            this.metadataSourcePrecedence = Arrays.asList(DEFAULT_ARTEFACT_PROCESSING_ORDER);
        }
        this.metadataSourcePrecedence = Collections.unmodifiableList(this.metadataSourcePrecedence);
        return this.metadataSourcePrecedence;
    }

    public void setPrecedence(String precedence) {
        this.metadataSourcePrecedence = this.parsePrecedence(precedence);
    }

    private List<MetadataSourceType> parsePrecedence(String s) {
        if (StringHelper.isEmpty(s)) {
            return Collections.emptyList();
        }
        StringTokenizer precedences = new StringTokenizer(s, ",; ", false);
        ArrayList<MetadataSourceType> tmpPrecedences = new ArrayList<MetadataSourceType>();
        while (precedences.hasMoreElements()) {
            tmpPrecedences.add(MetadataSourceType.parsePrecedence((String)precedences.nextElement()));
        }
        return tmpPrecedences;
    }

    private static class CacheHolder {
        public String role;
        public String usage;
        public String region;
        public boolean isClass;
        public boolean cacheLazy;

        public CacheHolder(String role, String usage, String region, boolean isClass, boolean cacheLazy) {
            this.role = role;
            this.usage = usage;
            this.region = region;
            this.isClass = isClass;
            this.cacheLazy = cacheLazy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MetadataSourceQueue
    implements Serializable {
        private LinkedHashMap<XmlDocument, Set<String>> hbmMetadataToEntityNamesMap = new LinkedHashMap();
        private Map<String, XmlDocument> hbmMetadataByEntityNameXRef = new HashMap<String, XmlDocument>();
        private transient List<XClass> annotatedClasses = new ArrayList<XClass>();
        private transient Map<String, XClass> annotatedClassesByEntityNameMap = new HashMap<String, XClass>();

        protected MetadataSourceQueue() {
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.annotatedClassesByEntityNameMap = new HashMap<String, XClass>();
            List serializableAnnotatedClasses = (List)ois.readObject();
            this.annotatedClasses = new ArrayList<XClass>(serializableAnnotatedClasses.size());
            for (Class clazz : serializableAnnotatedClasses) {
                this.annotatedClasses.add(Configuration.this.reflectionManager.toXClass(clazz));
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            ArrayList<Class> serializableAnnotatedClasses = new ArrayList<Class>(this.annotatedClasses.size());
            for (XClass xClass : this.annotatedClasses) {
                serializableAnnotatedClasses.add(Configuration.this.reflectionManager.toClass(xClass));
            }
            out.writeObject(serializableAnnotatedClasses);
        }

        public void add(XmlDocument metadataXml) {
            org.dom4j.Document document = metadataXml.getDocumentTree();
            Element hmNode = document.getRootElement();
            Attribute packNode = hmNode.attribute("package");
            String defaultPackage = packNode != null ? packNode.getValue() : "";
            HashSet<String> entityNames = new HashSet<String>();
            this.findClassNames(defaultPackage, hmNode, entityNames);
            for (String entity : entityNames) {
                this.hbmMetadataByEntityNameXRef.put(entity, metadataXml);
            }
            this.hbmMetadataToEntityNamesMap.put(metadataXml, entityNames);
        }

        private void findClassNames(String defaultPackage, Element startNode, Set<String> names) {
            Iterator[] classes = new Iterator[]{startNode.elementIterator("class"), startNode.elementIterator("subclass"), startNode.elementIterator("joined-subclass"), startNode.elementIterator("union-subclass")};
            JoinedIterator classIterator = new JoinedIterator(classes);
            while (classIterator.hasNext()) {
                Element element = (Element)classIterator.next();
                String entityName = element.attributeValue("entity-name");
                if (entityName == null) {
                    entityName = this.getClassName(element.attribute("name"), defaultPackage);
                }
                names.add(entityName);
                this.findClassNames(defaultPackage, element, names);
            }
        }

        private String getClassName(Attribute name, String defaultPackage) {
            if (name == null) {
                return null;
            }
            String unqualifiedName = name.getValue();
            if (unqualifiedName == null) {
                return null;
            }
            if (unqualifiedName.indexOf(46) < 0 && defaultPackage != null) {
                return defaultPackage + '.' + unqualifiedName;
            }
            return unqualifiedName;
        }

        public void add(XClass annotatedClass) {
            this.annotatedClasses.add(annotatedClass);
        }

        protected void syncAnnotatedClasses() {
            Iterator<XClass> itr = this.annotatedClasses.iterator();
            while (itr.hasNext()) {
                XClass annotatedClass = itr.next();
                if (annotatedClass.isAnnotationPresent(Entity.class)) {
                    this.annotatedClassesByEntityNameMap.put(annotatedClass.getName(), annotatedClass);
                    continue;
                }
                if (annotatedClass.isAnnotationPresent(MappedSuperclass.class)) continue;
                itr.remove();
            }
        }

        protected void processMetadata(List<MetadataSourceType> order) {
            this.syncAnnotatedClasses();
            for (MetadataSourceType type : order) {
                if (MetadataSourceType.HBM.equals((Object)type)) {
                    this.processHbmXmlQueue();
                    continue;
                }
                if (!MetadataSourceType.CLASS.equals((Object)type)) continue;
                this.processAnnotatedClassesQueue();
            }
        }

        private void processHbmXmlQueue() {
            log.debug("Processing hbm.xml files");
            for (Map.Entry<XmlDocument, Set<String>> entry : this.hbmMetadataToEntityNamesMap.entrySet()) {
                this.processHbmXml(entry.getKey(), entry.getValue());
            }
            this.hbmMetadataToEntityNamesMap.clear();
            this.hbmMetadataByEntityNameXRef.clear();
        }

        private void processHbmXml(XmlDocument metadataXml, Set<String> entityNames) {
            try {
                HbmBinder.bindRoot(metadataXml, Configuration.this.createMappings(), CollectionHelper.EMPTY_MAP, entityNames);
            }
            catch (MappingException me) {
                throw new InvalidMappingException(metadataXml.getOrigin().getType(), metadataXml.getOrigin().getName(), me);
            }
            for (String entityName : entityNames) {
                if (!this.annotatedClassesByEntityNameMap.containsKey(entityName)) continue;
                this.annotatedClasses.remove(this.annotatedClassesByEntityNameMap.get(entityName));
                this.annotatedClassesByEntityNameMap.remove(entityName);
            }
        }

        private void processAnnotatedClassesQueue() {
            log.debug("Process annotated classes");
            List<XClass> orderedClasses = this.orderAndFillHierarchy(this.annotatedClasses);
            Mappings mappings = Configuration.this.createMappings();
            Map<XClass, InheritanceState> inheritanceStatePerClass = AnnotationBinder.buildInheritanceStates(orderedClasses, mappings);
            for (XClass clazz : orderedClasses) {
                AnnotationBinder.bindClass(clazz, inheritanceStatePerClass, mappings);
                String entityName = clazz.getName();
                if (!this.hbmMetadataByEntityNameXRef.containsKey(entityName)) continue;
                this.hbmMetadataToEntityNamesMap.remove(this.hbmMetadataByEntityNameXRef.get(entityName));
                this.hbmMetadataByEntityNameXRef.remove(entityName);
            }
            this.annotatedClasses.clear();
            this.annotatedClassesByEntityNameMap.clear();
        }

        private List<XClass> orderAndFillHierarchy(List<XClass> original) {
            ArrayList<XClass> copy = new ArrayList<XClass>(original);
            this.insertMappedSuperclasses(original, copy);
            ArrayList<XClass> workingCopy = new ArrayList<XClass>(copy);
            ArrayList<XClass> newList = new ArrayList<XClass>(copy.size());
            while (workingCopy.size() > 0) {
                XClass clazz = (XClass)workingCopy.get(0);
                this.orderHierarchy(workingCopy, newList, copy, clazz);
            }
            return newList;
        }

        private void insertMappedSuperclasses(List<XClass> original, List<XClass> copy) {
            for (XClass clazz : original) {
                for (XClass superClass = clazz.getSuperclass(); superClass != null && !Configuration.this.reflectionManager.equals(superClass, Object.class) && !copy.contains(superClass); superClass = superClass.getSuperclass()) {
                    if (!superClass.isAnnotationPresent(Entity.class) && !superClass.isAnnotationPresent(MappedSuperclass.class)) continue;
                    copy.add(superClass);
                }
            }
        }

        private void orderHierarchy(List<XClass> copy, List<XClass> newList, List<XClass> original, XClass clazz) {
            if (clazz == null || Configuration.this.reflectionManager.equals(clazz, Object.class)) {
                return;
            }
            this.orderHierarchy(copy, newList, original, clazz.getSuperclass());
            if (original.contains(clazz)) {
                if (!newList.contains(clazz)) {
                    newList.add(clazz);
                }
                copy.remove(clazz);
            }
        }

        public boolean isEmpty() {
            return this.hbmMetadataToEntityNamesMap.isEmpty() && this.annotatedClasses.isEmpty();
        }
    }

    final class ObjectNameNormalizerImpl
    extends ObjectNameNormalizer
    implements Serializable {
        ObjectNameNormalizerImpl() {
        }

        public boolean isUseQuotedIdentifiersGlobally() {
            String setting = (String)Configuration.this.properties.get("hibernate.globally_quoted_identifiers");
            return setting != null && Boolean.valueOf(setting) != false;
        }

        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MappingsImpl
    implements ExtendedMappings,
    Serializable {
        private String schemaName;
        private String catalogName;
        private String defaultPackage;
        private boolean autoImport;
        private boolean defaultLazy;
        private String defaultCascade;
        private String defaultAccess;
        private Boolean useNewGeneratorMappings;

        protected MappingsImpl() {
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public String getCatalogName() {
            return this.catalogName;
        }

        @Override
        public void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public String getDefaultPackage() {
            return this.defaultPackage;
        }

        @Override
        public void setDefaultPackage(String defaultPackage) {
            this.defaultPackage = defaultPackage;
        }

        @Override
        public boolean isAutoImport() {
            return this.autoImport;
        }

        @Override
        public void setAutoImport(boolean autoImport) {
            this.autoImport = autoImport;
        }

        @Override
        public boolean isDefaultLazy() {
            return this.defaultLazy;
        }

        @Override
        public void setDefaultLazy(boolean defaultLazy) {
            this.defaultLazy = defaultLazy;
        }

        @Override
        public String getDefaultCascade() {
            return this.defaultCascade;
        }

        @Override
        public void setDefaultCascade(String defaultCascade) {
            this.defaultCascade = defaultCascade;
        }

        @Override
        public String getDefaultAccess() {
            return this.defaultAccess;
        }

        @Override
        public void setDefaultAccess(String defaultAccess) {
            this.defaultAccess = defaultAccess;
        }

        @Override
        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }

        @Override
        public void setNamingStrategy(NamingStrategy namingStrategy) {
            Configuration.this.namingStrategy = namingStrategy;
        }

        @Override
        public PersisterClassProvider getPersisterClassProvider() {
            return Configuration.this.persisterClassProvider;
        }

        @Override
        public void setPersisterClassProvider(PersisterClassProvider persisterClassProvider) {
            Configuration.this.persisterClassProvider = persisterClassProvider;
        }

        @Override
        public TypeResolver getTypeResolver() {
            return Configuration.this.typeResolver;
        }

        @Override
        public Iterator<PersistentClass> iterateClasses() {
            return Configuration.this.classes.values().iterator();
        }

        @Override
        public PersistentClass getClass(String entityName) {
            return Configuration.this.classes.get(entityName);
        }

        @Override
        public PersistentClass locatePersistentClassByEntityName(String entityName) {
            String actualEntityName;
            PersistentClass persistentClass = Configuration.this.classes.get(entityName);
            if (persistentClass == null && StringHelper.isNotEmpty(actualEntityName = Configuration.this.imports.get(entityName))) {
                persistentClass = Configuration.this.classes.get(actualEntityName);
            }
            return persistentClass;
        }

        @Override
        public void addClass(PersistentClass persistentClass) throws DuplicateMappingException {
            PersistentClass old = Configuration.this.classes.put(persistentClass.getEntityName(), persistentClass);
            if (old != null) {
                throw new DuplicateMappingException("class/entity", persistentClass.getEntityName());
            }
        }

        @Override
        public void addImport(String entityName, String rename) throws DuplicateMappingException {
            String existing = Configuration.this.imports.put(rename, entityName);
            if (existing != null) {
                if (existing.equals(entityName)) {
                    log.info("duplicate import: {} -> {}", (Object)entityName, (Object)rename);
                } else {
                    throw new DuplicateMappingException("duplicate import: " + rename + " refers to both " + entityName + " and " + existing + " (try using auto-import=\"false\")", "import", rename);
                }
            }
        }

        @Override
        public Collection getCollection(String role) {
            return Configuration.this.collections.get(role);
        }

        @Override
        public Iterator<Collection> iterateCollections() {
            return Configuration.this.collections.values().iterator();
        }

        @Override
        public void addCollection(Collection collection) throws DuplicateMappingException {
            Collection old = Configuration.this.collections.put(collection.getRole(), collection);
            if (old != null) {
                throw new DuplicateMappingException("collection role", collection.getRole());
            }
        }

        @Override
        public Table getTable(String schema, String catalog, String name) {
            String key = Table.qualify(catalog, schema, name);
            return Configuration.this.tables.get(key);
        }

        @Override
        public Iterator<Table> iterateTables() {
            return Configuration.this.tables.values().iterator();
        }

        @Override
        public Table addTable(String schema, String catalog, String name, String subselect, boolean isAbstract) {
            name = this.getObjectNameNormalizer().normalizeIdentifierQuoting(name);
            schema = this.getObjectNameNormalizer().normalizeIdentifierQuoting(schema);
            catalog = this.getObjectNameNormalizer().normalizeIdentifierQuoting(catalog);
            String key = subselect == null ? Table.qualify(catalog, schema, name) : subselect;
            Table table = Configuration.this.tables.get(key);
            if (table == null) {
                table = new Table();
                table.setAbstract(isAbstract);
                table.setName(name);
                table.setSchema(schema);
                table.setCatalog(catalog);
                table.setSubselect(subselect);
                Configuration.this.tables.put(key, table);
            } else if (!isAbstract) {
                table.setAbstract(false);
            }
            return table;
        }

        @Override
        public Table addDenormalizedTable(String schema, String catalog, String name, boolean isAbstract, String subselect, Table includedTable) throws DuplicateMappingException {
            String key;
            name = this.getObjectNameNormalizer().normalizeIdentifierQuoting(name);
            schema = this.getObjectNameNormalizer().normalizeIdentifierQuoting(schema);
            catalog = this.getObjectNameNormalizer().normalizeIdentifierQuoting(catalog);
            String string = key = subselect == null ? Table.qualify(catalog, schema, name) : subselect;
            if (Configuration.this.tables.containsKey(key)) {
                throw new DuplicateMappingException("table", name);
            }
            DenormalizedTable table = new DenormalizedTable(includedTable);
            table.setAbstract(isAbstract);
            table.setName(name);
            table.setSchema(schema);
            table.setCatalog(catalog);
            table.setSubselect(subselect);
            Configuration.this.tables.put(key, table);
            return table;
        }

        @Override
        public NamedQueryDefinition getQuery(String name) {
            return Configuration.this.namedQueries.get(name);
        }

        @Override
        public void addQuery(String name, NamedQueryDefinition query2) throws DuplicateMappingException {
            if (!Configuration.this.defaultNamedQueryNames.contains(name)) {
                this.applyQuery(name, query2);
            }
        }

        private void applyQuery(String name, NamedQueryDefinition query2) {
            this.checkQueryName(name);
            Configuration.this.namedQueries.put(name.intern(), query2);
        }

        private void checkQueryName(String name) throws DuplicateMappingException {
            if (Configuration.this.namedQueries.containsKey(name) || Configuration.this.namedSqlQueries.containsKey(name)) {
                throw new DuplicateMappingException("query", name);
            }
        }

        @Override
        public void addDefaultQuery(String name, NamedQueryDefinition query2) {
            this.applyQuery(name, query2);
            Configuration.this.defaultNamedQueryNames.add(name);
        }

        @Override
        public NamedSQLQueryDefinition getSQLQuery(String name) {
            return Configuration.this.namedSqlQueries.get(name);
        }

        @Override
        public void addSQLQuery(String name, NamedSQLQueryDefinition query2) throws DuplicateMappingException {
            if (!Configuration.this.defaultNamedNativeQueryNames.contains(name)) {
                this.applySQLQuery(name, query2);
            }
        }

        private void applySQLQuery(String name, NamedSQLQueryDefinition query2) throws DuplicateMappingException {
            this.checkQueryName(name);
            Configuration.this.namedSqlQueries.put(name.intern(), query2);
        }

        @Override
        public void addDefaultSQLQuery(String name, NamedSQLQueryDefinition query2) {
            this.applySQLQuery(name, query2);
            Configuration.this.defaultNamedNativeQueryNames.add(name);
        }

        @Override
        public ResultSetMappingDefinition getResultSetMapping(String name) {
            return Configuration.this.sqlResultSetMappings.get(name);
        }

        @Override
        public void addResultSetMapping(ResultSetMappingDefinition sqlResultSetMapping) throws DuplicateMappingException {
            if (!Configuration.this.defaultSqlResultSetMappingNames.contains(sqlResultSetMapping.getName())) {
                this.applyResultSetMapping(sqlResultSetMapping);
            }
        }

        public void applyResultSetMapping(ResultSetMappingDefinition sqlResultSetMapping) throws DuplicateMappingException {
            ResultSetMappingDefinition old = Configuration.this.sqlResultSetMappings.put(sqlResultSetMapping.getName(), sqlResultSetMapping);
            if (old != null) {
                throw new DuplicateMappingException("resultSet", sqlResultSetMapping.getName());
            }
        }

        @Override
        public void addDefaultResultSetMapping(ResultSetMappingDefinition definition) {
            String name = definition.getName();
            if (!Configuration.this.defaultSqlResultSetMappingNames.contains(name) && this.getResultSetMapping(name) != null) {
                this.removeResultSetMapping(name);
            }
            this.applyResultSetMapping(definition);
            Configuration.this.defaultSqlResultSetMappingNames.add(name);
        }

        protected void removeResultSetMapping(String name) {
            Configuration.this.sqlResultSetMappings.remove(name);
        }

        @Override
        public TypeDef getTypeDef(String typeName) {
            return Configuration.this.typeDefs.get(typeName);
        }

        @Override
        public void addTypeDef(String typeName, String typeClass, Properties paramMap) {
            TypeDef def = new TypeDef(typeClass, paramMap);
            Configuration.this.typeDefs.put(typeName, def);
            log.debug("Added " + typeName + " with class " + typeClass);
        }

        @Override
        public Map getFilterDefinitions() {
            return Configuration.this.filterDefinitions;
        }

        @Override
        public FilterDefinition getFilterDefinition(String name) {
            return Configuration.this.filterDefinitions.get(name);
        }

        @Override
        public void addFilterDefinition(FilterDefinition definition) {
            Configuration.this.filterDefinitions.put(definition.getFilterName(), definition);
        }

        @Override
        public FetchProfile findOrCreateFetchProfile(String name, MetadataSource source) {
            FetchProfile profile = Configuration.this.fetchProfiles.get(name);
            if (profile == null) {
                profile = new FetchProfile(name, source);
                Configuration.this.fetchProfiles.put(name, profile);
            }
            return profile;
        }

        @Override
        public Iterator<AuxiliaryDatabaseObject> iterateAuxliaryDatabaseObjects() {
            return this.iterateAuxiliaryDatabaseObjects();
        }

        @Override
        public Iterator<AuxiliaryDatabaseObject> iterateAuxiliaryDatabaseObjects() {
            return Configuration.this.auxiliaryDatabaseObjects.iterator();
        }

        @Override
        public ListIterator<AuxiliaryDatabaseObject> iterateAuxliaryDatabaseObjectsInReverse() {
            return this.iterateAuxiliaryDatabaseObjectsInReverse();
        }

        @Override
        public ListIterator<AuxiliaryDatabaseObject> iterateAuxiliaryDatabaseObjectsInReverse() {
            return Configuration.this.auxiliaryDatabaseObjects.listIterator(Configuration.this.auxiliaryDatabaseObjects.size());
        }

        @Override
        public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
            Configuration.this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
        }

        @Override
        public String getLogicalTableName(Table table) throws MappingException {
            return this.getLogicalTableName(table.getQuotedSchema(), table.getCatalog(), table.getQuotedName());
        }

        private String getLogicalTableName(String schema, String catalog, String physicalName) throws MappingException {
            String key = this.buildTableNameKey(schema, catalog, physicalName);
            TableDescription descriptor = (TableDescription)Configuration.this.tableNameBinding.get(key);
            if (descriptor == null) {
                throw new MappingException("Unable to find physical table: " + physicalName);
            }
            return descriptor.logicalName;
        }

        @Override
        public void addTableBinding(String schema, String catalog, String logicalName, String physicalName, Table denormalizedSuperTable) throws DuplicateMappingException {
            TableDescription tableDescription;
            String key = this.buildTableNameKey(schema, catalog, physicalName);
            TableDescription oldDescriptor = Configuration.this.tableNameBinding.put(key, tableDescription = new TableDescription(logicalName, denormalizedSuperTable));
            if (oldDescriptor != null && !oldDescriptor.logicalName.equals(logicalName)) {
                throw new DuplicateMappingException("Same physical table name [" + physicalName + "] references several logical table names: [" + oldDescriptor.logicalName + "], [" + logicalName + ']', "table", physicalName);
            }
        }

        private String buildTableNameKey(String schema, String catalog, String finalName) {
            StringBuffer keyBuilder = new StringBuffer();
            if (schema != null) {
                keyBuilder.append(schema);
            }
            keyBuilder.append(".");
            if (catalog != null) {
                keyBuilder.append(catalog);
            }
            keyBuilder.append(".");
            keyBuilder.append(finalName);
            return keyBuilder.toString();
        }

        @Override
        public void addColumnBinding(String logicalName, Column physicalColumn, Table table) throws DuplicateMappingException {
            TableColumnNameBinding binding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(table);
            if (binding == null) {
                binding = new TableColumnNameBinding(table.getName());
                Configuration.this.columnNameBindingPerTable.put(table, binding);
            }
            binding.addBinding(logicalName, physicalColumn);
        }

        @Override
        public String getPhysicalColumnName(String logicalName, Table table) throws MappingException {
            logicalName = logicalName.toLowerCase();
            String finalName = null;
            Table currentTable = table;
            do {
                String key;
                TableDescription description;
                TableColumnNameBinding binding;
                if ((binding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(currentTable)) != null) {
                    finalName = (String)binding.logicalToPhysical.get(logicalName);
                }
                currentTable = (description = (TableDescription)Configuration.this.tableNameBinding.get(key = this.buildTableNameKey(currentTable.getQuotedSchema(), currentTable.getCatalog(), currentTable.getQuotedName()))) != null ? description.denormalizedSupertable : null;
            } while (finalName == null && currentTable != null);
            if (finalName == null) {
                throw new MappingException("Unable to find column with logical name " + logicalName + " in table " + table.getName());
            }
            return finalName;
        }

        @Override
        public String getLogicalColumnName(String physicalName, Table table) throws MappingException {
            String logical = null;
            Table currentTable = table;
            TableDescription description = null;
            do {
                String key;
                TableColumnNameBinding binding;
                if ((binding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(currentTable)) != null) {
                    logical = (String)binding.physicalToLogical.get(physicalName);
                }
                currentTable = (description = (TableDescription)Configuration.this.tableNameBinding.get(key = this.buildTableNameKey(currentTable.getQuotedSchema(), currentTable.getCatalog(), currentTable.getQuotedName()))) != null ? description.denormalizedSupertable : null;
            } while (logical == null && currentTable != null && description != null);
            if (logical == null) {
                throw new MappingException("Unable to find logical column name from physical name " + physicalName + " in table " + table.getName());
            }
            return logical;
        }

        @Override
        public void addSecondPass(SecondPass sp) {
            this.addSecondPass(sp, false);
        }

        @Override
        public void addSecondPass(SecondPass sp, boolean onTopOfTheQueue) {
            if (onTopOfTheQueue) {
                Configuration.this.secondPasses.add(0, sp);
            } else {
                Configuration.this.secondPasses.add(sp);
            }
        }

        @Override
        public void addPropertyReference(String referencedClass, String propertyName) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(referencedClass, propertyName, false));
        }

        @Override
        public void addUniquePropertyReference(String referencedClass, String propertyName) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(referencedClass, propertyName, true));
        }

        @Override
        public void addToExtendsQueue(ExtendsQueueEntry entry) {
            Configuration.this.extendsQueue.put(entry, null);
        }

        @Override
        public DefaultIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
            return Configuration.this.identifierGeneratorFactory;
        }

        @Override
        public void addMappedSuperclass(Class type, org.hibernate.mapping.MappedSuperclass mappedSuperclass) {
            Configuration.this.mappedSuperClasses.put(type, mappedSuperclass);
        }

        @Override
        public org.hibernate.mapping.MappedSuperclass getMappedSuperclass(Class type) {
            return (org.hibernate.mapping.MappedSuperclass)Configuration.this.mappedSuperClasses.get(type);
        }

        @Override
        public ObjectNameNormalizer getObjectNameNormalizer() {
            return Configuration.this.normalizer;
        }

        @Override
        public Properties getConfigurationProperties() {
            return Configuration.this.properties;
        }

        @Override
        public void addDefaultGenerator(IdGenerator generator) {
            this.addGenerator(generator);
            Configuration.this.defaultNamedGenerators.add(generator.getName());
        }

        @Override
        public boolean isInSecondPass() {
            return Configuration.this.inSecondPass;
        }

        @Override
        public PropertyData getPropertyAnnotatedWithMapsId(XClass entityType, String propertyName) {
            Map map = (Map)Configuration.this.propertiesAnnotatedWithMapsId.get(entityType);
            return map == null ? null : (PropertyData)map.get(propertyName);
        }

        @Override
        public void addPropertyAnnotatedWithMapsId(XClass entityType, PropertyData property) {
            HashMap<String, PropertyData> map = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithMapsId.get(entityType);
            if (map == null) {
                map = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithMapsId.put(entityType, map);
            }
            map.put(property.getProperty().getAnnotation(MapsId.class).value(), property);
        }

        @Override
        public boolean isSpecjProprietarySyntaxEnabled() {
            return Configuration.this.specjProprietarySyntaxEnabled;
        }

        @Override
        public void addPropertyAnnotatedWithMapsIdSpecj(XClass entityType, PropertyData property, String mapsIdValue) {
            HashMap<String, PropertyData> map = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithMapsId.get(entityType);
            if (map == null) {
                map = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithMapsId.put(entityType, map);
            }
            map.put(mapsIdValue, property);
        }

        @Override
        public PropertyData getPropertyAnnotatedWithIdAndToOne(XClass entityType, String propertyName) {
            Map map = (Map)Configuration.this.propertiesAnnotatedWithIdAndToOne.get(entityType);
            return map == null ? null : (PropertyData)map.get(propertyName);
        }

        @Override
        public void addToOneAndIdProperty(XClass entityType, PropertyData property) {
            HashMap<String, PropertyData> map = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithIdAndToOne.get(entityType);
            if (map == null) {
                map = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithIdAndToOne.put(entityType, map);
            }
            map.put(property.getPropertyName(), property);
        }

        @Override
        public boolean useNewGeneratorMappings() {
            if (this.useNewGeneratorMappings == null) {
                String booleanName = this.getConfigurationProperties().getProperty(Configuration.USE_NEW_ID_GENERATOR_MAPPINGS);
                this.useNewGeneratorMappings = Boolean.valueOf(booleanName);
            }
            return this.useNewGeneratorMappings;
        }

        @Override
        public IdGenerator getGenerator(String name) {
            return this.getGenerator(name, null);
        }

        @Override
        public IdGenerator getGenerator(String name, Map<String, IdGenerator> localGenerators) {
            IdGenerator result;
            if (localGenerators != null && (result = localGenerators.get(name)) != null) {
                return result;
            }
            return (IdGenerator)Configuration.this.namedGenerators.get(name);
        }

        @Override
        public void addGenerator(IdGenerator generator) {
            IdGenerator old;
            if (!Configuration.this.defaultNamedGenerators.contains(generator.getName()) && (old = Configuration.this.namedGenerators.put(generator.getName(), generator)) != null) {
                log.warn("duplicate generator name {}", (Object)old.getName());
            }
        }

        @Override
        public void addGeneratorTable(String name, Properties params) {
            Properties old = Configuration.this.generatorTables.put(name, params);
            if (old != null) {
                log.warn("duplicate generator table: {}", (Object)name);
            }
        }

        @Override
        public Properties getGeneratorTableProperties(String name, Map<String, Properties> localGeneratorTables) {
            Properties result;
            if (localGeneratorTables != null && (result = localGeneratorTables.get(name)) != null) {
                return result;
            }
            return (Properties)Configuration.this.generatorTables.get(name);
        }

        @Override
        public Map<String, Join> getJoins(String entityName) {
            return (Map)Configuration.this.joins.get(entityName);
        }

        @Override
        public void addJoins(PersistentClass persistentClass, Map<String, Join> joins) {
            Map<String, Join> old = Configuration.this.joins.put(persistentClass.getEntityName(), joins);
            if (old != null) {
                log.warn("duplicate joins for class: {}", (Object)persistentClass.getEntityName());
            }
        }

        @Override
        public AnnotatedClassType getClassType(XClass clazz) {
            AnnotatedClassType type = (AnnotatedClassType)((Object)Configuration.this.classTypes.get(clazz.getName()));
            if (type == null) {
                return this.addClassType(clazz);
            }
            return type;
        }

        @Override
        public AnnotatedClassType addClassType(XClass clazz) {
            AnnotatedClassType type = clazz.isAnnotationPresent(Entity.class) ? AnnotatedClassType.ENTITY : (clazz.isAnnotationPresent(Embeddable.class) ? AnnotatedClassType.EMBEDDABLE : (clazz.isAnnotationPresent(MappedSuperclass.class) ? AnnotatedClassType.EMBEDDABLE_SUPERCLASS : AnnotatedClassType.NONE));
            Configuration.this.classTypes.put(clazz.getName(), type);
            return type;
        }

        @Override
        public Map<Table, List<String[]>> getTableUniqueConstraints() {
            HashMap<Table, List<String[]>> deprecatedStructure = new HashMap<Table, List<String[]>>(CollectionHelper.determineProperSizing(this.getUniqueConstraintHoldersByTable()), 0.75f);
            for (Map.Entry<Table, List<UniqueConstraintHolder>> entry : this.getUniqueConstraintHoldersByTable().entrySet()) {
                ArrayList<String[]> columnsPerConstraint = new ArrayList<String[]>(CollectionHelper.determineProperSizing(entry.getValue().size()));
                deprecatedStructure.put(entry.getKey(), columnsPerConstraint);
                for (UniqueConstraintHolder holder : entry.getValue()) {
                    columnsPerConstraint.add(holder.getColumns());
                }
            }
            return deprecatedStructure;
        }

        @Override
        public Map<Table, List<UniqueConstraintHolder>> getUniqueConstraintHoldersByTable() {
            return Configuration.this.uniqueConstraintHoldersByTable;
        }

        @Override
        public void addUniqueConstraints(Table table, List uniqueConstraints) {
            ArrayList<UniqueConstraintHolder> constraintHolders = new ArrayList<UniqueConstraintHolder>(CollectionHelper.determineProperSizing(uniqueConstraints.size()));
            int keyNameBase = this.determineCurrentNumberOfUniqueConstraintHolders(table);
            for (String[] columns : uniqueConstraints) {
                String keyName = "key" + keyNameBase++;
                constraintHolders.add(new UniqueConstraintHolder().setName(keyName).setColumns(columns));
            }
            this.addUniqueConstraintHolders(table, constraintHolders);
        }

        private int determineCurrentNumberOfUniqueConstraintHolders(Table table) {
            List<UniqueConstraintHolder> currentHolders = this.getUniqueConstraintHoldersByTable().get(table);
            return currentHolders == null ? 0 : currentHolders.size();
        }

        @Override
        public void addUniqueConstraintHolders(Table table, List<UniqueConstraintHolder> uniqueConstraintHolders) {
            List<UniqueConstraintHolder> holderList = this.getUniqueConstraintHoldersByTable().get(table);
            if (holderList == null) {
                holderList = new ArrayList<UniqueConstraintHolder>();
                this.getUniqueConstraintHoldersByTable().put(table, holderList);
            }
            holderList.addAll(uniqueConstraintHolders);
        }

        @Override
        public void addMappedBy(String entityName, String propertyName, String inversePropertyName) {
            Configuration.this.mappedByResolver.put(entityName + "." + propertyName, inversePropertyName);
        }

        @Override
        public String getFromMappedBy(String entityName, String propertyName) {
            return (String)Configuration.this.mappedByResolver.get(entityName + "." + propertyName);
        }

        @Override
        public void addPropertyReferencedAssociation(String entityName, String propertyName, String propertyRef) {
            Configuration.this.propertyRefResolver.put(entityName + "." + propertyName, propertyRef);
        }

        @Override
        public String getPropertyReferencedAssociation(String entityName, String propertyName) {
            return (String)Configuration.this.propertyRefResolver.get(entityName + "." + propertyName);
        }

        @Override
        public ReflectionManager getReflectionManager() {
            return Configuration.this.reflectionManager;
        }

        @Override
        public Map getClasses() {
            return Configuration.this.classes;
        }

        @Override
        public void addAnyMetaDef(AnyMetaDef defAnn) throws AnnotationException {
            if (Configuration.this.anyMetaDefs.containsKey(defAnn.name())) {
                throw new AnnotationException("Two @AnyMetaDef with the same name defined: " + defAnn.name());
            }
            Configuration.this.anyMetaDefs.put(defAnn.name(), defAnn);
        }

        @Override
        public AnyMetaDef getAnyMetaDef(String name) {
            return (AnyMetaDef)Configuration.this.anyMetaDefs.get(name);
        }

        private class TableColumnNameBinding
        implements Serializable {
            private final String tableName;
            private Map logicalToPhysical = new HashMap();
            private Map physicalToLogical = new HashMap();

            private TableColumnNameBinding(String tableName) {
                this.tableName = tableName;
            }

            public void addBinding(String logicalName, Column physicalColumn) {
                this.bindLogicalToPhysical(logicalName, physicalColumn);
                this.bindPhysicalToLogical(logicalName, physicalColumn);
            }

            private void bindLogicalToPhysical(String logicalName, Column physicalColumn) throws DuplicateMappingException {
                String physicalName;
                String logicalKey = logicalName.toLowerCase();
                String existingPhysicalName = this.logicalToPhysical.put(logicalKey, physicalName = physicalColumn.getQuotedName());
                if (existingPhysicalName != null) {
                    boolean areSamePhysicalColumn;
                    boolean bl = areSamePhysicalColumn = physicalColumn.isQuoted() ? existingPhysicalName.equals(physicalName) : existingPhysicalName.equalsIgnoreCase(physicalName);
                    if (!areSamePhysicalColumn) {
                        throw new DuplicateMappingException(" Table [" + this.tableName + "] contains logical column name [" + logicalName + "] referenced by multiple physical column names: [" + existingPhysicalName + "], [" + physicalName + "]", "column-binding", this.tableName + "." + logicalName);
                    }
                }
            }

            private void bindPhysicalToLogical(String logicalName, Column physicalColumn) throws DuplicateMappingException {
                String physicalName = physicalColumn.getQuotedName();
                String existingLogicalName = this.physicalToLogical.put(physicalName, logicalName);
                if (existingLogicalName != null && !existingLogicalName.equals(logicalName)) {
                    throw new DuplicateMappingException(" Table [" + this.tableName + "] contains phyical column name [" + physicalName + "] represented by different logical column names: [" + existingLogicalName + "], [" + logicalName + "]", "column-binding", this.tableName + "." + physicalName);
                }
            }
        }

        private class TableDescription
        implements Serializable {
            final String logicalName;
            final Table denormalizedSupertable;

            TableDescription(String logicalName, Table denormalizedSupertable) {
                this.logicalName = logicalName;
                this.denormalizedSupertable = denormalizedSupertable;
            }
        }
    }
}

