/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.BitSet;

public class EncodingUtilities {
    private static BitSet pcharUnescapedCharacters;
    private static BitSet fragmentUnescapedCharacters;
    private static BitSet queryUnescapedCharacters;
    private static final char[] hexadecimal;

    public static String encodeUrlPathSegment(String segmentString) {
        return EncodingUtilities.encodeString(pcharUnescapedCharacters, segmentString);
    }

    public static String encodeUrlQuerySegment(String segmentString) {
        return EncodingUtilities.encodeString(queryUnescapedCharacters, segmentString);
    }

    public static String encodeUrlFragment(String fragmentString) {
        return EncodingUtilities.encodeString(fragmentUnescapedCharacters, fragmentString);
    }

    private static String encodeString(BitSet unescapedSet, String idString) {
        OutputStreamWriter writer;
        int maxBytesPerChar = 10;
        StringBuilder rewrittenPathSegment = new StringBuilder(idString.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF-8");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < idString.length(); ++i) {
            char c = idString.charAt(i);
            if (unescapedSet.get(c)) {
                rewrittenPathSegment.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e3) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                byte toEncode = ba[j];
                rewrittenPathSegment.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPathSegment.append(hexadecimal[high]);
                rewrittenPathSegment.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPathSegment.toString();
    }

    public static String decodeString(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        string = string.replace("+", "%2B");
        return URLDecoder.decode(string, "UTF-8");
    }

    public static String decodeXmlDataItems(String dataString) {
        String decodedString = dataString.replaceAll("&gt;", ">");
        decodedString = decodedString.replaceAll("&lt;", "<");
        decodedString = decodedString.replaceAll("&amp;", "&");
        decodedString = decodedString.replaceAll("&apos;", "'");
        decodedString = decodedString.replaceAll("&quot;", "\"");
        return decodedString;
    }

    static {
        int i;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        pcharUnescapedCharacters = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            pcharUnescapedCharacters.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            pcharUnescapedCharacters.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            pcharUnescapedCharacters.set(i);
        }
        pcharUnescapedCharacters.set(45);
        pcharUnescapedCharacters.set(95);
        pcharUnescapedCharacters.set(46);
        pcharUnescapedCharacters.set(126);
        pcharUnescapedCharacters.set(33);
        pcharUnescapedCharacters.set(36);
        pcharUnescapedCharacters.set(38);
        pcharUnescapedCharacters.set(39);
        pcharUnescapedCharacters.set(40);
        pcharUnescapedCharacters.set(41);
        pcharUnescapedCharacters.set(42);
        pcharUnescapedCharacters.set(44);
        pcharUnescapedCharacters.set(61);
        pcharUnescapedCharacters.set(58);
        pcharUnescapedCharacters.set(64);
        fragmentUnescapedCharacters = (BitSet)pcharUnescapedCharacters.clone();
        fragmentUnescapedCharacters.set(47);
        fragmentUnescapedCharacters.set(63);
        fragmentUnescapedCharacters.set(59);
        queryUnescapedCharacters = (BitSet)fragmentUnescapedCharacters.clone();
        queryUnescapedCharacters.clear(61);
        queryUnescapedCharacters.clear(38);
    }
}

