/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1.strategy;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataone.cn.data.repository.ReplicationTask;
import org.dataone.cn.data.repository.ReplicationTaskRepository;
import org.dataone.cn.log.AuditEvent;
import org.dataone.cn.log.AuditLogClientFactory;
import org.dataone.cn.log.AuditLogEntry;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.ReplicationFactory;
import org.dataone.service.cn.replication.auditor.v1.strategy.ReplicaAuditStrategy;
import org.dataone.service.cn.replication.auditor.v1.strategy.ReplicaAuditingDelegate;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.SystemMetadata;

public class MemberNodeReplicaAuditingStrategy
implements ReplicaAuditStrategy {
    public static Logger log = Logger.getLogger(MemberNodeReplicaAuditingStrategy.class);
    private static final BigInteger auditSizeLimit = Settings.getConfiguration().getBigInteger("dataone.mn.audit.size.limit", BigInteger.valueOf(1000000000L));
    private ReplicaAuditingDelegate auditDelegate = new ReplicaAuditingDelegate();
    private ReplicationTaskRepository taskRepository = ReplicationFactory.getReplicationTaskRepository();

    @Override
    public void auditPids(List<Identifier> pids, Date auditDate) {
        log.debug("audit pids called with " + pids.size() + ".");
        for (Identifier pid : pids) {
            this.auditPid(pid, auditDate);
        }
    }

    private void auditPid(Identifier pid, Date auditDate) {
        log.debug("auditPid for Member Node replica called for pid: " + pid.getValue());
        SystemMetadata sysMeta = this.auditDelegate.getSystemMetadata(pid);
        if (sysMeta == null) {
            return;
        }
        boolean queueToReplication = false;
        int validReplicaCount = 0;
        for (Replica replica : sysMeta.getReplicaList()) {
            boolean valid;
            boolean verify = replica.getReplicaVerified().before(auditDate);
            if (this.auditDelegate.isCNodeReplica(replica)) continue;
            if (this.auditDelegate.isAuthoritativeMNReplica(sysMeta, replica)) {
                if (!verify || (valid = this.auditAuthoritativeMNodeReplica(sysMeta, replica))) continue;
                queueToReplication = true;
                continue;
            }
            valid = false;
            if (verify) {
                valid = this.auditMemberNodeReplica(sysMeta, replica);
            }
            if (valid || !verify) {
                ++validReplicaCount;
                continue;
            }
            if (valid) continue;
            queueToReplication = true;
        }
        if (this.shouldSendToReplication(queueToReplication, sysMeta, validReplicaCount)) {
            this.sendToReplication(pid);
        }
    }

    private boolean auditMemberNodeReplica(SystemMetadata sysMeta, Replica replica) {
        Identifier pid = sysMeta.getIdentifier();
        if (auditSizeLimit.compareTo(sysMeta.getSize()) < 0) {
            AuditLogEntry logEntry = new AuditLogEntry(pid.getValue(), replica.getReplicaMemberNode().getValue(), AuditEvent.REPLICA_AUDIT_FAILED, "replica audit skipped, size of document exceeds audit limit");
            AuditLogClientFactory.getAuditLogClient().logAuditEvent(logEntry);
            this.updateReplicaVerified(pid, replica);
            return true;
        }
        Checksum expected = sysMeta.getChecksum();
        Checksum actual = null;
        try {
            actual = this.auditDelegate.getChecksumFromMN(pid, sysMeta, replica.getReplicaMemberNode());
        }
        catch (NotFound e2) {
            log.error(e2);
            String message = "Attempt to retrieve the checksum from source member node resulted in a D1 NotFound exception: " + e2.getMessage() + ".   Replica has been marked invalid.";
            this.handleInvalidReplica(sysMeta, replica);
            AuditLogEntry logEntry = new AuditLogEntry(pid.getValue(), replica.getReplicaMemberNode().getValue(), AuditEvent.REPLICA_NOT_FOUND, message);
            AuditLogClientFactory.getAuditLogClient().logAuditEvent(logEntry);
            return false;
        }
        catch (BaseException e3) {
            log.error("Unable to get checksum from mn: " + replica.getReplicaMemberNode() + ". ", e3);
            this.updateReplicaVerified(pid, replica);
            String message = "Attempt to retrieve checksum from MN resulted in multiple ServiceFailure exceptions: " + e3.getMessage() + ".  Not invalidating replica.";
            this.logAuditingFailure(replica, pid, message);
            return true;
        }
        if (actual == null) {
            String message = "Attempt to retrieve the checksum from source member node resulted in a null checksum.  Replica has been marked invalid.";
            log.error(message);
            this.handleInvalidReplica(sysMeta, replica);
            AuditLogEntry logEntry = new AuditLogEntry(pid.getValue(), replica.getReplicaMemberNode().getValue(), AuditEvent.REPLICA_BAD_CHECKSUM, message);
            AuditLogClientFactory.getAuditLogClient().logAuditEvent(logEntry);
            return false;
        }
        boolean valid = ChecksumUtil.areChecksumsEqual(actual, expected);
        if (!valid) {
            String message = "Checksum mismatch for pid: " + pid.getValue() + " against MN: " + replica.getReplicaMemberNode().getValue() + ".  Expected checksum is: " + expected.getValue() + " actual was: " + actual.getValue();
            log.error(message);
            this.handleInvalidReplica(sysMeta, replica);
            AuditLogEntry logEntry = new AuditLogEntry(pid.getValue(), replica.getReplicaMemberNode().getValue(), AuditEvent.REPLICA_BAD_CHECKSUM, message);
            AuditLogClientFactory.getAuditLogClient().logAuditEvent(logEntry);
            return false;
        }
        this.updateReplicaVerified(pid, replica);
        return true;
    }

    private void logAuditingFailure(Replica replica, Identifier pid, String message) {
        AuditLogClientFactory.getAuditLogClient().removeReplicaAuditEvent(new AuditLogEntry(pid.getValue(), replica.getReplicaMemberNode().getValue(), AuditEvent.REPLICA_AUDIT_FAILED, null, null));
        AuditLogEntry logEntry = new AuditLogEntry(pid.getValue(), replica.getReplicaMemberNode().getValue(), AuditEvent.REPLICA_AUDIT_FAILED, message);
        AuditLogClientFactory.getAuditLogClient().logAuditEvent(logEntry);
    }

    private boolean auditAuthoritativeMNodeReplica(SystemMetadata sysMeta, Replica replica) {
        return this.auditMemberNodeReplica(sysMeta, replica);
    }

    private boolean shouldSendToReplication(boolean queueToReplication, SystemMetadata sysMeta, int validReplicaCount) {
        if (sysMeta.getReplicationPolicy() == null || sysMeta.getReplicationPolicy().getNumberReplicas() == null) {
            return false;
        }
        return queueToReplication || validReplicaCount != sysMeta.getReplicationPolicy().getNumberReplicas();
    }

    private void updateReplicaVerified(Identifier pid, Replica replica) {
        this.auditDelegate.updateVerifiedReplica(pid, replica);
    }

    private void handleInvalidReplica(SystemMetadata sysMeta, Replica replica) {
        this.auditDelegate.updateInvalidReplica(sysMeta, replica);
    }

    private void sendToReplication(Identifier pid) {
        List<ReplicationTask> taskList = this.taskRepository.findByPid(pid.getValue());
        if (taskList.size() == 1) {
            ReplicationTask task = taskList.get(0);
            task.markNew();
            this.taskRepository.save(task);
        } else if (taskList.size() == 0) {
            log.warn("In Replication Manager, task that should exist 'in process' does not exist.  Creating new task for pid: " + pid.getValue());
            this.taskRepository.save(new ReplicationTask(pid));
        } else if (taskList.size() > 1) {
            log.warn("In Replication Manager, more than one task found for pid: " + pid.getValue() + ". Deleting all and creating new task.");
            this.taskRepository.delete(taskList);
            this.taskRepository.save(new ReplicationTask(pid));
        }
    }
}

