/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1.strategy;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataone.cn.log.AuditEvent;
import org.dataone.cn.log.AuditLogClientFactory;
import org.dataone.cn.log.AuditLogEntry;
import org.dataone.service.cn.replication.auditor.v1.strategy.ReplicaAuditStrategy;
import org.dataone.service.cn.replication.auditor.v1.strategy.ReplicaAuditingDelegate;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.SystemMetadata;

public class InvalidMemberNodeReplicaAuditingStrategy
implements ReplicaAuditStrategy {
    public static Logger log = Logger.getLogger(InvalidMemberNodeReplicaAuditingStrategy.class);
    private ReplicaAuditingDelegate auditDelegate = new ReplicaAuditingDelegate();

    @Override
    public void auditPids(List<Identifier> pids, Date auditDate) {
        log.debug("audit pids called with " + pids.size() + ".");
        for (Identifier pid : pids) {
            this.auditPid(pid, auditDate);
        }
    }

    private void auditPid(Identifier pid, Date auditDate) {
        log.debug("auditPid for invalid replica called for pid: " + pid.getValue());
        SystemMetadata sysMeta = this.auditDelegate.getSystemMetadata(pid);
        if (sysMeta == null) {
            return;
        }
        for (Replica replica : sysMeta.getReplicaList()) {
            boolean verify;
            if (this.auditDelegate.isCNodeReplica(replica) || !(verify = replica.getReplicaVerified().before(auditDate))) continue;
            this.auditInvalidMemberNodeReplica(sysMeta, replica);
        }
    }

    private void auditInvalidMemberNodeReplica(SystemMetadata sysMeta, Replica replica) {
        boolean valid;
        Identifier pid = sysMeta.getIdentifier();
        Checksum expected = sysMeta.getChecksum();
        Checksum actual = null;
        try {
            actual = this.auditDelegate.getChecksumFromMN(pid, sysMeta, replica.getReplicaMemberNode());
        }
        catch (BaseException e2) {
            e2.printStackTrace();
        }
        if (actual == null) {
            // empty if block
        }
        if (valid = ChecksumUtil.areChecksumsEqual(actual, expected)) {
            this.updateReplicaToComplete(pid, replica);
        } else {
            log.error("Checksum mismatch for pid: " + pid.getValue());
            log.error(" against MN: " + replica.getReplicaMemberNode().getValue() + ".");
            log.error("Expected checksum is: " + expected.getValue());
            String actualChecksum = null;
            if (actual != null) {
                actualChecksum = actual.getValue();
            }
            log.error(" actual was: " + actualChecksum);
            AuditLogEntry logEntry = new AuditLogEntry(pid.getValue(), replica.getReplicaMemberNode().getValue(), AuditEvent.REPLICA_BAD_CHECKSUM, "Checksum mismatch for pid: " + pid.getValue() + " against MN: " + replica.getReplicaMemberNode().getValue() + ".  Expected checksum is: " + expected.getValue() + " actual was: " + actualChecksum);
            AuditLogClientFactory.getAuditLogClient().logAuditEvent(logEntry);
            this.handleInvalidReplica(sysMeta, replica);
        }
    }

    private void handleInvalidReplica(SystemMetadata sysMeta, Replica replica) {
        this.auditDelegate.updateInvalidReplica(sysMeta, replica);
    }

    private void updateReplicaToComplete(Identifier pid, Replica replica) {
        this.auditDelegate.updateVerifiedReplica(pid, replica);
    }
}

