/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1.controller;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.auditor.v1.controller.AbstractReplicationAuditor;
import org.dataone.service.cn.replication.auditor.v1.task.MemberNodeReplicaAuditTask;
import org.dataone.service.types.v1.Identifier;

public class MemberNodeReplicationAuditor
extends AbstractReplicationAuditor {
    private static final int pageSize = 100;
    private static final int pidsPerTaskSize = 5;
    private static final int taskPoolSize = 5;
    private static final int maxPages = 10;
    private static final long executionWaitSeconds = 60L;
    private static final long auditPeriodDays = Settings.getConfiguration().getLong("Replication.audit.mn.period.days", 90L);
    private static final long auditPeriod = 86400000L * auditPeriodDays;
    private static final String MN_AUDIT_LOCK_NAME = "memberNodeReplicationAuditLock";

    @Override
    protected String getLockName() {
        return MN_AUDIT_LOCK_NAME;
    }

    @Override
    protected Date calculateAuditDate() {
        return new Date(System.currentTimeMillis() - auditPeriod);
    }

    @Override
    protected List<Identifier> getPidsToAudit(Date auditDate, int pageNumber, int pageSize) throws DataAccessException {
        return this.replicationDao.getCompletedMemberNodeReplicasByDate(auditDate, pageNumber, pageSize);
    }

    @Override
    protected Callable<String> newAuditTask(List<Identifier> pids, Date auditDate) {
        return new MemberNodeReplicaAuditTask(pids, auditDate);
    }

    @Override
    protected int getMaxPages() {
        return 10;
    }

    @Override
    protected int getTaskPoolSize() {
        return 5;
    }

    @Override
    protected int getPageSize() {
        return 100;
    }

    @Override
    protected int getPidsPerTaskSize() {
        return 5;
    }

    @Override
    protected boolean shouldRunAudit() {
        return ComponentActivationUtility.replicationMNAuditorIsActive();
    }

    @Override
    protected long getFutureExecutionWaitTimeSeconds() {
        return 60L;
    }
}

