/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.IMap;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v1.MNode;
import org.dataone.client.v1.itk.D1Client;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.SystemMetadata;

public class MNAuditTask
implements Serializable,
Callable<String> {
    public static Log log = LogFactory.getLog(MNAuditTask.class);
    private String taskid;
    private String eventid;
    private Node auditTargetNode;
    private String auditTargetNodeSubject;
    private ArrayList<Identifier> auditIDs;
    private Identifier last_pid;

    public MNAuditTask() {
    }

    public MNAuditTask(String taskid, Node auditTargetNode, ArrayList<Identifier> auditIDs) {
        this.taskid = taskid;
        this.auditTargetNode = auditTargetNode;
        this.auditTargetNodeSubject = auditTargetNode.getSubject(0).getValue();
        this.auditIDs = auditIDs;
    }

    public String getTaskid() {
        return this.taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getEventid() {
        return this.eventid;
    }

    public void setEventid(String eventid) {
        this.eventid = eventid;
    }

    public Node getAuditTargetNode() {
        return this.auditTargetNode;
    }

    public void setAuditTargetNode(Node auditTargetNode) {
        this.auditTargetNode = auditTargetNode;
    }

    public String getAuditTargetNodeSubject() {
        return this.auditTargetNodeSubject;
    }

    public void setAuditTargetNodeSubject(String subject) {
        this.auditTargetNodeSubject = subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws IllegalStateException {
        MNode targetMN = null;
        try {
            String clientCertificateLocation = Settings.getConfiguration().getString("D1Client.certificate.directory") + File.separator + Settings.getConfiguration().getString("D1Client.certificate.filename");
            CertificateManager.getInstance().setCertificateLocation(clientCertificateLocation);
            log.debug("MNReplicationTask task id " + this.taskid + "is using an X509 certificate from " + clientCertificateLocation);
            log.debug("Getting the MNode reference for " + this.auditTargetNode.getIdentifier().getValue());
            targetMN = D1Client.getMN(this.auditTargetNode.getIdentifier());
        }
        catch (ServiceFailure e2) {
            log.debug("Failed to get the target MNode reference for " + this.auditTargetNode.getIdentifier().getValue() + " while executing MNAuditTask id " + this.taskid);
        }
        String hzSystemMetadata = Settings.getConfiguration().getString("dataone.hazelcast.systemMetadata");
        HazelcastClient hzClient = HazelcastClientFactory.getStorageClient();
        IMap sysMetaMap = hzClient.getMap(hzSystemMetadata);
        try {
            Iterator<Identifier> iterator = this.auditIDs.iterator();
            while (iterator.hasNext()) {
                Identifier pid;
                this.last_pid = pid = iterator.next();
                sysMetaMap.lock(pid.getValue());
                SystemMetadata sysmeta = (SystemMetadata)sysMetaMap.get(pid);
                ArrayList replicaList = (ArrayList)sysmeta.getReplicaList();
                int replicaIndex = -1;
                for (Replica replica : replicaList) {
                    if (!replica.getReplicaMemberNode().getValue().equals(this.auditTargetNode.getIdentifier().getValue())) continue;
                    replicaIndex = replicaList.indexOf(replica);
                    break;
                }
                if (replicaIndex == -1) {
                    throw new InvalidRequest("1080", "Node is not reported to have object: " + pid);
                }
                log.debug("Calling MNRead.getChecksum() at auditTargetNode id " + targetMN.getNodeId());
                Session session = null;
                Checksum targetChecksum = targetMN.getChecksum(session, pid, sysmeta.getChecksum().getAlgorithm());
                if (targetChecksum != sysmeta.getChecksum()) {
                    ((Replica)replicaList.get(replicaIndex)).setReplicationStatus(ReplicationStatus.INVALIDATED);
                    ((Replica)replicaList.get(replicaIndex)).setReplicaVerified(Calendar.getInstance().getTime());
                } else {
                    ((Replica)replicaList.get(replicaIndex)).setReplicaVerified(Calendar.getInstance().getTime());
                }
                sysmeta.setReplicaList(replicaList);
                sysMetaMap.unlock(pid.getValue());
            }
        }
        catch (NotImplemented e3) {
            e3.printStackTrace();
        }
        catch (ServiceFailure e4) {
            e4.printStackTrace();
        }
        catch (NotAuthorized e5) {
            e5.printStackTrace();
        }
        catch (InvalidRequest e6) {
            e6.printStackTrace();
        }
        catch (InvalidToken e7) {
            e7.printStackTrace();
        }
        catch (NotFound e8) {
            e8.printStackTrace();
        }
        finally {
            sysMetaMap.unlock(this.last_pid.getValue());
        }
        return this.auditTargetNode.getIdentifier().getValue();
    }
}

