/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dataone.cn.dao.DaoFactory;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v2.SystemMetadata;

public class ReplicationPrioritizationStrategy {
    public static Logger log = Logger.getLogger(ReplicationPrioritizationStrategy.class);
    private int requestLimit = Settings.getConfiguration().getInt("replication.concurrent.request.limit");
    private float successThreshold = Settings.getConfiguration().getFloat("replication.success.threshold");
    private boolean useRequestFactor = Settings.getConfiguration().getBoolean("replication.prioritization.useRequestFactor");
    private boolean useFailureFactor = Settings.getConfiguration().getBoolean("replication.prioritization.useFailureFactor");
    private boolean useBandwidthFactor = Settings.getConfiguration().getBoolean("replication.prioritization.useBandwidthFactor");
    private boolean usePreferenceFactor = Settings.getConfiguration().getBoolean("replication.prioritization.usePreferenceFactor");

    public Map<NodeReference, Float> getPendingRequestFactors(List<NodeReference> nodeIdentifiers, boolean useCache) {
        Map<NodeReference, Integer> pendingRequests;
        HashMap<NodeReference, Float> requestFactors = new HashMap<NodeReference, Float>();
        try {
            pendingRequests = DaoFactory.getReplicationDao().getPendingReplicasByNode();
        }
        catch (DataAccessException dataAccessEx) {
            pendingRequests = new HashMap<NodeReference, Integer>();
            log.error("Unable to retrieve pending replicas by node: " + dataAccessEx.getMessage());
        }
        for (NodeReference nodeId : nodeIdentifiers) {
            Integer pending = pendingRequests.get(nodeId) != null ? pendingRequests.get(nodeId) : new Integer(0);
            log.debug("Pending requests for node " + nodeId.getValue() + " is " + pending);
            if (pending <= this.requestLimit) {
                requestFactors.put(nodeId, new Float(1.0f));
                continue;
            }
            requestFactors.put(nodeId, new Float(0.0f));
            log.info("Node " + nodeId.getValue() + " is currently over its request limit of " + this.requestLimit + " requests.");
        }
        return requestFactors;
    }

    public Map<NodeReference, Float> getFailureFactors(List<NodeReference> nodeIdentifiers, boolean useCache) {
        Map<Object, Object> failedRequests = new HashMap();
        Map<Object, Object> completedRequests = new HashMap();
        HashMap<NodeReference, Float> failureFactors = new HashMap<NodeReference, Float>();
        Float successThreshold = new Float(this.successThreshold);
        try {
            failedRequests = DaoFactory.getReplicationDao().getRecentFailedReplicas();
        }
        catch (DataAccessException dataAccessEx) {
            log.error("Unable to retrieve recent failed replicas by node: " + dataAccessEx.getMessage());
        }
        try {
            completedRequests = DaoFactory.getReplicationDao().getRecentCompletedReplicas();
        }
        catch (DataAccessException dataAccessEx) {
            log.error("Unable to retrieve recent completed replicas by node: " + dataAccessEx.getMessage());
        }
        for (NodeReference nodeId : nodeIdentifiers) {
            Float failureFactor;
            Integer successes;
            Integer failures = failedRequests.get(nodeId) != null ? (Integer)failedRequests.get(nodeId) : new Integer(0);
            Integer n = successes = completedRequests.get(nodeId) != null ? (Integer)completedRequests.get(nodeId) : new Integer(0);
            if (failures == 0 && successes == 0) {
                failureFactors.put(nodeId, new Float(1.0f));
                continue;
            }
            if (failures + successes < 5) {
                failureFactor = new Float(1.0f);
                log.debug("Gave node " + nodeId.getValue() + " a pass since it has less than 5 replica attempts.");
            } else {
                failureFactor = new Float(successes.floatValue() / (successes.floatValue() + failures.floatValue()));
                if (failureFactor.floatValue() <= successThreshold.floatValue()) {
                    failureFactor = new Float(0.0f);
                }
            }
            failureFactors.put(nodeId, failureFactor);
        }
        return failureFactors;
    }

    public Map<NodeReference, Float> getBandwidthFactors(List<NodeReference> nodeIdentifiers, boolean useCache) {
        HashMap<NodeReference, Float> bandwidthFactors = new HashMap<NodeReference, Float>();
        Iterator<NodeReference> nodeIterator = nodeIdentifiers.iterator();
        while (nodeIterator.hasNext()) {
            bandwidthFactors.put(nodeIterator.next(), new Float(1.0f));
        }
        return bandwidthFactors;
    }

    /*
     * WARNING - void declaration
     */
    public List<NodeReference> prioritizeNodes(List<NodeReference> potentialNodeList, SystemMetadata sysmeta) {
        ArrayList nodesByPriority = new ArrayList();
        ReplicationPolicy replicationPolicy = sysmeta.getReplicationPolicy();
        Identifier pid = sysmeta.getIdentifier();
        Map<Object, Object> requestFactorMap = new HashMap();
        Map<Object, Object> failureFactorMap = new HashMap();
        Map<Object, Object> bandwidthFactorMap = new HashMap();
        log.info("Retrieving performance metrics for the potential replication list for " + pid.getValue());
        requestFactorMap = this.getPendingRequestFactors(potentialNodeList, false);
        failureFactorMap = this.getFailureFactors(potentialNodeList, false);
        bandwidthFactorMap = this.getBandwidthFactors(potentialNodeList, false);
        List<NodeReference> preferredList = null;
        if (replicationPolicy != null) {
            preferredList = replicationPolicy.getPreferredMemberNodeList();
        }
        List<NodeReference> blockedList = null;
        if (replicationPolicy != null) {
            blockedList = replicationPolicy.getBlockedMemberNodeList();
        }
        HashMap<NodeReference, Float> nodeScoreMap = new HashMap<NodeReference, Float>();
        ValueComparator valueComparator = new ValueComparator(nodeScoreMap);
        TreeMap<Object, Float> sortedScoresMap = new TreeMap<Object, Float>(valueComparator);
        for (NodeReference nodeReference : potentialNodeList) {
            void var16_18;
            void var18_29;
            void var16_23;
            Float f = Float.valueOf(1.0f);
            if (preferredList != null && preferredList.contains(nodeReference)) {
                Float f2 = Float.valueOf(2.0f);
            }
            if (blockedList != null && blockedList.contains(nodeReference)) {
                Float f3 = Float.valueOf(0.0f);
            }
            log.debug("Node " + nodeReference.getValue() + " preferenceFactor is " + var16_23);
            Float nodePendingRequestFactor = Float.valueOf(1.0f);
            if (requestFactorMap.get(nodeReference) != null) {
                nodePendingRequestFactor = (Float)requestFactorMap.get(nodeReference);
                log.debug("Node " + nodeReference.getValue() + " requestFactor is " + nodePendingRequestFactor);
            }
            Float f4 = Float.valueOf(1.0f);
            if (failureFactorMap.get(nodeReference) != null) {
                Float f5 = (Float)failureFactorMap.get(nodeReference);
                log.debug("Node " + nodeReference.getValue() + " failureFactor is " + f5);
            }
            Float nodeBandwidthFactor = Float.valueOf(1.0f);
            if (bandwidthFactorMap.get(nodeReference) != null) {
                nodeBandwidthFactor = (Float)bandwidthFactorMap.get(nodeReference);
                log.debug("Node " + nodeReference.getValue() + " bandwidthFactor is " + nodeBandwidthFactor);
            }
            if (!this.useRequestFactor) {
                nodePendingRequestFactor = Float.valueOf(1.0f);
                log.debug("useRequestFactor is false, using 1.0");
            }
            if (!this.useFailureFactor) {
                Float f6 = Float.valueOf(1.0f);
                log.debug("useFailureFactor is false, using 1.0");
            }
            if (!this.useBandwidthFactor) {
                nodeBandwidthFactor = Float.valueOf(1.0f);
                log.debug("useBandwidthFactor is false, using 1.0");
            }
            if (!this.usePreferenceFactor) {
                Float f7 = Float.valueOf(1.0f);
                log.debug("usePreferenceFactor is false, using 1.0");
            }
            Float score = Float.valueOf(nodePendingRequestFactor.floatValue() * var18_29.floatValue() * nodeBandwidthFactor.floatValue() * var16_18.floatValue());
            log.debug("Score for " + nodeReference.getValue() + " will be " + nodePendingRequestFactor + " * " + var18_29 + " * " + nodeBandwidthFactor + " * " + var16_18);
            List<Replica> replicaList = sysmeta.getReplicaList();
            for (Replica replica : replicaList) {
                String nodeIdStr = replica.getReplicaMemberNode().getValue();
                ReplicationStatus nodeStatus = replica.getReplicationStatus();
                if (nodeIdStr != nodeReference.getValue() || nodeStatus != ReplicationStatus.QUEUED && nodeStatus != ReplicationStatus.REQUESTED && nodeStatus != ReplicationStatus.COMPLETED && nodeStatus != ReplicationStatus.INVALIDATED) continue;
                score = new Float(0.0f);
                log.debug("Node " + nodeReference.getValue() + " is already listed as a " + nodeStatus.toString() + " replica for identifier" + pid.getValue());
                break;
            }
            log.info("Priority score for " + nodeReference.getValue() + " is " + score.floatValue());
            nodeScoreMap.put(nodeReference, score);
        }
        sortedScoresMap.putAll(nodeScoreMap);
        log.debug("logging sorted scores map:");
        for (NodeReference nodeReference : sortedScoresMap.keySet()) {
            log.debug("node id: " + nodeReference.getValue());
            Float score = (Float)sortedScoresMap.get(nodeReference);
            if (score != null) {
                log.debug("node score is: " + score.floatValue());
                continue;
            }
            log.debug("node score is NULL.");
            Float f = (Float)nodeScoreMap.get(nodeReference);
            if (f != null) {
                log.debug("backup score is " + f.floatValue());
                continue;
            }
            log.debug("backup score is NULL");
        }
        log.debug("Sorted scores map size: " + sortedScoresMap.size());
        HashSet<Float> hashSet = new HashSet<Float>();
        ArrayList<NodeReference> arrayList = new ArrayList<NodeReference>();
        for (NodeReference nodeReference : sortedScoresMap.keySet()) {
            Float value = (Float)sortedScoresMap.get(nodeReference);
            if (value == null) {
                log.debug("Node: " + nodeReference.getValue() + " has NULL score.");
                value = (Float)nodeScoreMap.get(nodeReference);
                if (value == null) {
                    log.debug("Could not get node score from node score map either: " + nodeReference.getValue());
                    continue;
                }
            }
            log.debug("score for node: " + nodeReference.getValue() + " is: " + value.floatValue());
            if (value.floatValue() <= 0.0f) {
                log.info("Removed " + nodeReference.getValue() + ", score is " + value.floatValue());
                continue;
            }
            if (hashSet.contains(value)) continue;
            hashSet.add(value);
            ArrayList<NodeReference> sameScores = new ArrayList<NodeReference>();
            for (NodeReference nodeReference2 : sortedScoresMap.keySet()) {
                if (nodeReference2.equals(nodeReference)) continue;
                Float matchValue = (Float)sortedScoresMap.get(nodeReference2);
                if (matchValue == null) {
                    log.debug("match value is null for: " + nodeReference2.getValue());
                    matchValue = (Float)nodeScoreMap.get(nodeReference2);
                    if (matchValue == null) {
                        log.debug("could not get node score from node score map: " + nodeReference2.getValue());
                        continue;
                    }
                }
                if (matchValue.floatValue() != value.floatValue()) continue;
                log.debug("match value score for node: " + nodeReference2.getValue() + " is: " + matchValue.floatValue());
                sameScores.add(nodeReference2);
            }
            if (sameScores.isEmpty()) {
                log.debug("Adding " + nodeReference.getValue() + " , score is " + value.floatValue());
                arrayList.add(nodeReference);
                continue;
            }
            sameScores.add(nodeReference);
            Collections.shuffle(sameScores);
            if (log.isDebugEnabled()) {
                log.debug("Adding: ");
                for (NodeReference nodeReference3 : sameScores) {
                    log.debug("Node: " + nodeReference3.getValue() + " , score is " + value.floatValue());
                }
            }
            arrayList.addAll(sameScores);
        }
        return arrayList;
    }

    private class ValueComparator
    implements Comparator<Object> {
        Map<NodeReference, Float> incomingMap;

        public ValueComparator(Map<NodeReference, Float> incomingMap) {
            this.incomingMap = incomingMap;
        }

        @Override
        public int compare(Object a, Object b) {
            if (this.incomingMap.get(a).floatValue() < this.incomingMap.get(b).floatValue()) {
                return 1;
            }
            if (this.incomingMap.get(a) == this.incomingMap.get(b)) {
                return 0;
            }
            return -1;
        }
    }
}

