/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v2.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.utils.ExceptionUtils;
import org.dataone.client.v2.MNode;
import org.dataone.client.v2.impl.MultipartD1Node;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.OptionList;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.D1Url;

public class MultipartMNode
extends MultipartD1Node
implements MNode {
    protected static Log log = LogFactory.getLog(MultipartMNode.class);

    @Deprecated
    public MultipartMNode(String nodeBaseServiceUrl) throws IOException, ClientSideException {
        super(nodeBaseServiceUrl);
        this.nodeType = NodeType.MN;
    }

    public MultipartMNode(MultipartRestClient mrc, String nodeBaseServiceUrl) {
        super(mrc, nodeBaseServiceUrl);
        this.nodeType = NodeType.MN;
    }

    public MultipartMNode(MultipartRestClient mrc, String nodeBaseServiceUrl, Session session) {
        super(mrc, nodeBaseServiceUrl, session);
        this.nodeType = NodeType.MN;
    }

    @Override
    public String getNodeBaseServiceUrl() {
        D1Url url = new D1Url(super.getNodeBaseServiceUrl());
        url.addNextPathElement("v2");
        log.debug("Node base service URL is: " + url.getUrl());
        return url.getUrl();
    }

    @Override
    public Date ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        return super.ping();
    }

    @Override
    public ObjectList listObjects(Session session, Date fromDate, Date toDate, ObjectFormatIdentifier formatid, Identifier identifier, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        if (toDate != null && fromDate != null && !toDate.after(fromDate)) {
            throw new InvalidRequest("1000", "fromDate must be before toDate in listObjects() call. " + fromDate + " " + toDate);
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        url.addDateParamPair("fromDate", fromDate);
        url.addDateParamPair("toDate", toDate);
        if (formatid != null) {
            url.addNonEmptyParamPair("formatId", formatid.getValue());
        }
        if (identifier != null) {
            url.addNonEmptyParamPair("identifier", identifier.getValue());
        }
        if (replicaStatus != null) {
            if (replicaStatus.booleanValue()) {
                url.addNonEmptyParamPair("replicaStatus", 1);
            } else {
                url.addNonEmptyParamPair("replicaStatus", 0);
            }
        }
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        ObjectList objectList = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            objectList = this.deserializeServiceType(ObjectList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e2) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e2);
        }
        return objectList;
    }

    @Override
    public Node getCapabilities() throws NotImplemented, ServiceFailure {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        Node node = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            node = this.deserializeServiceType(Node.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e2) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e2);
        }
        return node;
    }

    @Override
    public InputStream get(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        return super.get(pid);
    }

    @Override
    public InputStream get(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        return super.get(session, pid);
    }

    @Override
    public org.dataone.service.types.v2.Log getLogRecords(Session session, Date fromDate, Date toDate, String event, String idFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "log");
        url.addDateParamPair("fromDate", fromDate);
        url.addDateParamPair("toDate", toDate);
        if (event != null) {
            url.addNonEmptyParamPair("event", event);
        }
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        url.addNonEmptyParamPair("idFilter", idFilter);
        org.dataone.service.types.v2.Log log = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.D1Node.getLogRecords.timeout", null));
            log = this.deserializeServiceType(org.dataone.service.types.v2.Log.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e2) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e2);
        }
        return log;
    }

    @Override
    public SystemMetadata getSystemMetadata(Session session, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.getSystemMetadata(session, id);
    }

    @Override
    public DescribeResponse describe(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.describe(pid);
    }

    @Override
    public DescribeResponse describe(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.describe(session, pid);
    }

    @Override
    public Checksum getChecksum(Identifier pid, String checksumAlgorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.getChecksum(pid, checksumAlgorithm);
    }

    @Override
    public Checksum getChecksum(Session session, Identifier pid, String checksumAlgorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return super.getChecksum(session, pid, checksumAlgorithm);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean synchronizationFailed(Session session, SynchronizationFailed message) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "error");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("message", message.serialize(0));
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)be;
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)be;
                }
                if (!(be instanceof ServiceFailure)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (ServiceFailure)be;
                catch (ClientSideException e2) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e2);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    @Override
    public boolean isAuthorized(Identifier pid, Permission action) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        return super.isAuthorized(pid, action);
    }

    @Override
    public boolean isAuthorized(Session session, Identifier pid, Permission action) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        return super.isAuthorized(session, pid, action);
    }

    @Override
    public Identifier generateIdentifier(String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return super.generateIdentifier(scheme, fragment);
    }

    @Override
    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return super.generateIdentifier(session, scheme, fragment);
    }

    @Override
    public Identifier create(Session session, Identifier pid, InputStream object, SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addParamPart("pid", pid.getValue());
            mpe.addFilePart("object", object);
            mpe.addFilePart("sysmeta", sysmeta);
        }
        catch (IOException e2) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e2);
        }
        catch (MarshallingException e3) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e3);
        }
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.MNode.create.timeout", null));
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)be;
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)be;
            }
            if (be instanceof UnsupportedType) {
                throw (UnsupportedType)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e4) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e4);
        }
        return identifier;
    }

    @Override
    public boolean updateSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        return super.updateSystemMetadata(session, pid, sysmeta);
    }

    @Override
    public Identifier update(Session session, Identifier pid, InputStream object, Identifier newPid, SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        mpe.addParamPart("newPid", newPid.getValue());
        try {
            mpe.addFilePart("object", object);
            mpe.addFilePart("sysmeta", sysmeta);
        }
        catch (IOException e2) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e2);
        }
        catch (MarshallingException e3) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e3);
        }
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.MNode.update.timeout", null));
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)be;
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)be;
            }
            if (be instanceof UnsupportedType) {
                throw (UnsupportedType)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e4) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e4);
        }
        return identifier;
    }

    @Override
    public Identifier archive(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.archive(pid);
    }

    @Override
    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.archive(session, pid);
    }

    @Override
    public Identifier delete(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.delete(pid);
    }

    @Override
    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.delete(session, pid);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean replicate(Session session, SystemMetadata sysmeta, NodeReference sourceNode) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken, InsufficientResources, UnsupportedType {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicate");
        SimpleMultipartEntity smpe = new SimpleMultipartEntity();
        if (sourceNode != null) {
            smpe.addParamPart("sourceNode", sourceNode.getValue());
        }
        try {
            smpe.addFilePart("sysmeta", sysmeta);
        }
        catch (IOException e2) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e2);
        }
        catch (MarshallingException e3) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e3);
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPostRequest(url.getUrl(), smpe, Settings.getConfiguration().getInteger("D1Client.MNode.replicate.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)be;
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)be;
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)be;
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof InsufficientResources) {
                    throw (InsufficientResources)be;
                }
                if (!(be instanceof UnsupportedType)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (UnsupportedType)be;
                catch (ClientSideException e4) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e4);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    @Override
    public InputStream getReplica(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replica");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        AutoCloseInputStream is = null;
        try {
            is = new AutoCloseInputStream(this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.MNode.getReplica.timeout", null)));
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e2) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e2);
        }
        return is;
    }

    @Override
    public InputStream view(Session session, String theme, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        return super.view(session, theme, id);
    }

    @Override
    public OptionList listViews(Session session) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return super.listViews(session);
    }

    @Override
    public InputStream getPackage(Session session, ObjectFormatIdentifier packageType, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound, UnsupportedType {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "packages");
        if (packageType == null || StringUtils.isBlank(packageType.getValue())) {
            url.addNextPathElement("application/zip");
        } else {
            url.addNextPathElement(packageType.getValue());
        }
        if (StringUtils.isBlank(id.getValue())) {
            throw new NotFound("0000", "'pid' cannot be null nor empty");
        }
        url.addNextPathElement(id.getValue());
        InputStream remoteStream = null;
        try {
            remoteStream = this.getRestClient(session).doGetRequest(url.getUrl(), 120000);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e2) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e2);
        }
        return new AutoCloseInputStream(remoteStream);
    }
}

