/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.PreCompInfo;

public class FixedPointUtil {
    public static final String PRECOMP_NAME = "bc_fixed_point";

    public static int getCombSize(ECCurve eCCurve) {
        BigInteger bigInteger = eCCurve.getOrder();
        return bigInteger == null ? eCCurve.getFieldSize() + 1 : bigInteger.bitLength();
    }

    public static FixedPointPreCompInfo getFixedPointPreCompInfo(PreCompInfo preCompInfo) {
        if (preCompInfo != null && preCompInfo instanceof FixedPointPreCompInfo) {
            return (FixedPointPreCompInfo)preCompInfo;
        }
        return new FixedPointPreCompInfo();
    }

    public static FixedPointPreCompInfo precompute(ECPoint eCPoint, int n) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n2 = 1 << n;
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.getFixedPointPreCompInfo(eCCurve.getPreCompInfo(eCPoint, PRECOMP_NAME));
        ECPoint[] eCPointArray = fixedPointPreCompInfo.getPreComp();
        if (eCPointArray == null || eCPointArray.length < n2) {
            int n4;
            int n5 = FixedPointUtil.getCombSize(eCCurve);
            int n6 = (n5 + n - 1) / n;
            ECPoint[] eCPointArray2 = new ECPoint[n];
            eCPointArray2[0] = eCPoint;
            for (n4 = 1; n4 < n; ++n4) {
                eCPointArray2[n4] = eCPointArray2[n4 - 1].timesPow2(n6);
            }
            eCCurve.normalizeAll(eCPointArray2);
            eCPointArray = new ECPoint[n2];
            eCPointArray[0] = eCCurve.getInfinity();
            for (n4 = n - 1; n4 >= 0; --n4) {
                int n7;
                ECPoint eCPoint2 = eCPointArray2[n4];
                for (int i = n7 = 1 << n4; i < n2; i += n7 << 1) {
                    eCPointArray[i] = eCPointArray[i - n7].add(eCPoint2);
                }
            }
            eCCurve.normalizeAll(eCPointArray);
            fixedPointPreCompInfo.setPreComp(eCPointArray);
            fixedPointPreCompInfo.setWidth(n);
            eCCurve.setPreCompInfo(eCPoint, PRECOMP_NAME, fixedPointPreCompInfo);
        }
        return fixedPointPreCompInfo;
    }
}

