/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldReaderException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;

final class FieldsReader {
    private final FieldInfos fieldInfos;
    private final IndexInput cloneableFieldsStream;
    private final IndexInput fieldsStream;
    private final IndexInput indexStream;
    private int size;
    private boolean closed;
    private ThreadLocal fieldsStreamTL = new ThreadLocal();

    FieldsReader(Directory d, String segment, FieldInfos fn) throws IOException {
        this(d, segment, fn, 1024);
    }

    FieldsReader(Directory d, String segment, FieldInfos fn, int readBufferSize) throws IOException {
        this.fieldInfos = fn;
        this.cloneableFieldsStream = d.openInput(segment + ".fdt", readBufferSize);
        this.fieldsStream = (IndexInput)this.cloneableFieldsStream.clone();
        this.indexStream = d.openInput(segment + ".fdx", readBufferSize);
        this.size = (int)(this.indexStream.length() / 8L);
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    final void close() throws IOException {
        if (!this.closed) {
            this.fieldsStream.close();
            this.cloneableFieldsStream.close();
            this.indexStream.close();
            IndexInput localFieldsStream = (IndexInput)this.fieldsStreamTL.get();
            if (localFieldsStream != null) {
                localFieldsStream.close();
                this.fieldsStreamTL.set(null);
            }
            this.closed = true;
        }
    }

    final int size() {
        return this.size;
    }

    final Document doc(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.indexStream.seek((long)n * 8L);
        long position = this.indexStream.readLong();
        this.fieldsStream.seek(position);
        Document doc = new Document();
        int numFields = this.fieldsStream.readVInt();
        for (int i = 0; i < numFields; ++i) {
            boolean binary;
            int fieldNumber = this.fieldsStream.readVInt();
            FieldInfo fi = this.fieldInfos.fieldInfo(fieldNumber);
            FieldSelectorResult acceptField = fieldSelector == null ? FieldSelectorResult.LOAD : fieldSelector.accept(fi.name);
            byte bits = this.fieldsStream.readByte();
            boolean compressed = (bits & 4) != 0;
            boolean tokenize = (bits & 1) != 0;
            boolean bl = binary = (bits & 2) != 0;
            if (acceptField.equals(FieldSelectorResult.LOAD)) {
                this.addField(doc, fi, binary, compressed, tokenize);
                continue;
            }
            if (acceptField.equals(FieldSelectorResult.LOAD_FOR_MERGE)) {
                this.addFieldForMerge(doc, fi, binary, compressed, tokenize);
                continue;
            }
            if (acceptField.equals(FieldSelectorResult.LOAD_AND_BREAK)) {
                this.addField(doc, fi, binary, compressed, tokenize);
                break;
            }
            if (acceptField.equals(FieldSelectorResult.LAZY_LOAD)) {
                this.addFieldLazy(doc, fi, binary, compressed, tokenize);
                continue;
            }
            if (acceptField.equals(FieldSelectorResult.SIZE)) {
                this.skipField(binary, compressed, this.addFieldSize(doc, fi, binary, compressed));
                continue;
            }
            if (acceptField.equals(FieldSelectorResult.SIZE_AND_BREAK)) {
                this.addFieldSize(doc, fi, binary, compressed);
                break;
            }
            this.skipField(binary, compressed);
        }
        return doc;
    }

    private void skipField(boolean binary, boolean compressed) throws IOException {
        this.skipField(binary, compressed, this.fieldsStream.readVInt());
    }

    private void skipField(boolean binary, boolean compressed, int toRead) throws IOException {
        if (binary || compressed) {
            long pointer = this.fieldsStream.getFilePointer();
            this.fieldsStream.seek(pointer + (long)toRead);
        } else {
            this.fieldsStream.skipChars(toRead);
        }
    }

    private void addFieldLazy(Document doc, FieldInfo fi, boolean binary, boolean compressed, boolean tokenize) throws IOException {
        if (binary) {
            int toRead = this.fieldsStream.readVInt();
            long pointer = this.fieldsStream.getFilePointer();
            if (compressed) {
                doc.add(new LazyField(fi.name, Field.Store.COMPRESS, toRead, pointer));
            } else {
                doc.add(new LazyField(fi.name, Field.Store.YES, toRead, pointer));
            }
            this.fieldsStream.seek(pointer + (long)toRead);
        } else {
            LazyField f;
            Field.Store store = Field.Store.YES;
            Field.Index index = this.getIndexType(fi, tokenize);
            Field.TermVector termVector = this.getTermVectorType(fi);
            if (compressed) {
                store = Field.Store.COMPRESS;
                int toRead = this.fieldsStream.readVInt();
                long pointer = this.fieldsStream.getFilePointer();
                f = new LazyField(fi.name, store, toRead, pointer);
                this.fieldsStream.seek(pointer + (long)toRead);
                f.setOmitNorms(fi.omitNorms);
            } else {
                int length = this.fieldsStream.readVInt();
                long pointer = this.fieldsStream.getFilePointer();
                this.fieldsStream.skipChars(length);
                f = new LazyField(fi.name, store, index, termVector, length, pointer);
                f.setOmitNorms(fi.omitNorms);
            }
            doc.add(f);
        }
    }

    private void addFieldForMerge(Document doc, FieldInfo fi, boolean binary, boolean compressed, boolean tokenize) throws IOException {
        Object data;
        if (binary || compressed) {
            int toRead = this.fieldsStream.readVInt();
            byte[] b = new byte[toRead];
            this.fieldsStream.readBytes(b, 0, b.length);
            data = b;
        } else {
            data = this.fieldsStream.readString();
        }
        doc.add(new FieldForMerge(data, fi, binary, compressed, tokenize));
    }

    private void addField(Document doc, FieldInfo fi, boolean binary, boolean compressed, boolean tokenize) throws CorruptIndexException, IOException {
        if (binary) {
            int toRead = this.fieldsStream.readVInt();
            byte[] b = new byte[toRead];
            this.fieldsStream.readBytes(b, 0, b.length);
            if (compressed) {
                doc.add(new Field(fi.name, this.uncompress(b), Field.Store.COMPRESS));
            } else {
                doc.add(new Field(fi.name, b, Field.Store.YES));
            }
        } else {
            Field f;
            Field.Store store = Field.Store.YES;
            Field.Index index = this.getIndexType(fi, tokenize);
            Field.TermVector termVector = this.getTermVectorType(fi);
            if (compressed) {
                store = Field.Store.COMPRESS;
                int toRead = this.fieldsStream.readVInt();
                byte[] b = new byte[toRead];
                this.fieldsStream.readBytes(b, 0, b.length);
                f = new Field(fi.name, new String(this.uncompress(b), "UTF-8"), store, index, termVector);
                f.setOmitNorms(fi.omitNorms);
            } else {
                f = new Field(fi.name, this.fieldsStream.readString(), store, index, termVector);
                f.setOmitNorms(fi.omitNorms);
            }
            doc.add(f);
        }
    }

    private int addFieldSize(Document doc, FieldInfo fi, boolean binary, boolean compressed) throws IOException {
        int size = this.fieldsStream.readVInt();
        int bytesize = binary || compressed ? size : 2 * size;
        byte[] sizebytes = new byte[]{(byte)(bytesize >>> 24), (byte)(bytesize >>> 16), (byte)(bytesize >>> 8), (byte)bytesize};
        doc.add(new Field(fi.name, sizebytes, Field.Store.YES));
        return size;
    }

    private Field.TermVector getTermVectorType(FieldInfo fi) {
        Field.TermVector termVector = null;
        termVector = fi.storeTermVector ? (fi.storeOffsetWithTermVector ? (fi.storePositionWithTermVector ? Field.TermVector.WITH_POSITIONS_OFFSETS : Field.TermVector.WITH_OFFSETS) : (fi.storePositionWithTermVector ? Field.TermVector.WITH_POSITIONS : Field.TermVector.YES)) : Field.TermVector.NO;
        return termVector;
    }

    private Field.Index getIndexType(FieldInfo fi, boolean tokenize) {
        Field.Index index = fi.isIndexed && tokenize ? Field.Index.TOKENIZED : (fi.isIndexed && !tokenize ? Field.Index.UN_TOKENIZED : Field.Index.NO);
        return index;
    }

    private final byte[] uncompress(byte[] input) throws CorruptIndexException, IOException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e2) {
                CorruptIndexException newException = new CorruptIndexException("field data are in wrong format: " + e2.toString());
                newException.initCause(e2);
                throw newException;
            }
        }
        decompressor.end();
        return bos.toByteArray();
    }

    static final class FieldForMerge
    extends AbstractField {
        public String stringValue() {
            return (String)this.fieldsData;
        }

        public Reader readerValue() {
            return null;
        }

        public byte[] binaryValue() {
            return (byte[])this.fieldsData;
        }

        public TokenStream tokenStreamValue() {
            return null;
        }

        public FieldForMerge(Object value, FieldInfo fi, boolean binary, boolean compressed, boolean tokenize) {
            this.isStored = true;
            this.fieldsData = value;
            this.isCompressed = compressed;
            this.isBinary = binary;
            this.isTokenized = tokenize;
            this.name = fi.name.intern();
            this.isIndexed = fi.isIndexed;
            this.omitNorms = fi.omitNorms;
            this.storeOffsetWithTermVector = fi.storeOffsetWithTermVector;
            this.storePositionWithTermVector = fi.storePositionWithTermVector;
            this.storeTermVector = fi.storeTermVector;
        }
    }

    private class LazyField
    extends AbstractField
    implements Fieldable {
        private int toRead;
        private long pointer;

        public LazyField(String name, Field.Store store, int toRead, long pointer) {
            super(name, store, Field.Index.NO, Field.TermVector.NO);
            this.toRead = toRead;
            this.pointer = pointer;
            this.lazy = true;
        }

        public LazyField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, int toRead, long pointer) {
            super(name, store, index, termVector);
            this.toRead = toRead;
            this.pointer = pointer;
            this.lazy = true;
        }

        private IndexInput getFieldStream() {
            IndexInput localFieldsStream = (IndexInput)FieldsReader.this.fieldsStreamTL.get();
            if (localFieldsStream == null) {
                localFieldsStream = (IndexInput)FieldsReader.this.cloneableFieldsStream.clone();
                FieldsReader.this.fieldsStreamTL.set(localFieldsStream);
            }
            return localFieldsStream;
        }

        public byte[] binaryValue() {
            FieldsReader.this.ensureOpen();
            if (this.fieldsData == null) {
                byte[] b = new byte[this.toRead];
                IndexInput localFieldsStream = this.getFieldStream();
                try {
                    localFieldsStream.seek(this.pointer);
                    localFieldsStream.readBytes(b, 0, b.length);
                    this.fieldsData = this.isCompressed ? (Object)FieldsReader.this.uncompress(b) : (Object)b;
                }
                catch (IOException e2) {
                    throw new FieldReaderException(e2);
                }
            }
            return this.fieldsData instanceof byte[] ? (byte[])this.fieldsData : null;
        }

        public Reader readerValue() {
            FieldsReader.this.ensureOpen();
            return this.fieldsData instanceof Reader ? (Reader)this.fieldsData : null;
        }

        public TokenStream tokenStreamValue() {
            FieldsReader.this.ensureOpen();
            return this.fieldsData instanceof TokenStream ? (TokenStream)this.fieldsData : null;
        }

        public String stringValue() {
            FieldsReader.this.ensureOpen();
            if (this.fieldsData == null) {
                IndexInput localFieldsStream = this.getFieldStream();
                try {
                    localFieldsStream.seek(this.pointer);
                    if (this.isCompressed) {
                        byte[] b = new byte[this.toRead];
                        localFieldsStream.readBytes(b, 0, b.length);
                        this.fieldsData = new String(FieldsReader.this.uncompress(b), "UTF-8");
                    } else {
                        char[] chars = new char[this.toRead];
                        localFieldsStream.readChars(chars, 0, this.toRead);
                        this.fieldsData = new String(chars);
                    }
                }
                catch (IOException e2) {
                    throw new FieldReaderException(e2);
                }
            }
            return this.fieldsData instanceof String ? (String)this.fieldsData : null;
        }

        public long getPointer() {
            FieldsReader.this.ensureOpen();
            return this.pointer;
        }

        public void setPointer(long pointer) {
            FieldsReader.this.ensureOpen();
            this.pointer = pointer;
        }

        public int getToRead() {
            FieldsReader.this.ensureOpen();
            return this.toRead;
        }

        public void setToRead(int toRead) {
            FieldsReader.this.ensureOpen();
            this.toRead = toRead;
        }
    }
}

