/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.index.Payload;

public class Token
implements Cloneable {
    String termText;
    int startOffset;
    int endOffset;
    String type = "word";
    Payload payload;
    private int positionIncrement = 1;

    public Token(String text, int start, int end) {
        this.termText = text;
        this.startOffset = start;
        this.endOffset = end;
    }

    public Token(String text, int start, int end, String typ) {
        this.termText = text;
        this.startOffset = start;
        this.endOffset = end;
        this.type = typ;
    }

    public void setPositionIncrement(int positionIncrement) {
        if (positionIncrement < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + positionIncrement);
        }
        this.positionIncrement = positionIncrement;
    }

    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    public void setTermText(String text) {
        this.termText = text;
    }

    public final String termText() {
        return this.termText;
    }

    public final int startOffset() {
        return this.startOffset;
    }

    public final int endOffset() {
        return this.endOffset;
    }

    public final String type() {
        return this.type;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(" + this.termText + "," + this.startOffset + "," + this.endOffset);
        if (!this.type.equals("word")) {
            sb.append(",type=" + this.type);
        }
        if (this.positionIncrement != 1) {
            sb.append(",posIncr=" + this.positionIncrement);
        }
        sb.append(")");
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }
}

