/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import com.hp.hpl.jena.sparql.util.Utils;

public class NodeValueFloat
extends NodeValue {
    float value = Float.NaN;

    public NodeValueFloat(float f) {
        this.value = f;
    }

    public NodeValueFloat(float f, Node n) {
        super(n);
        this.value = f;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isFloat() {
        return true;
    }

    public boolean isDouble() {
        return true;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    protected Node makeNode() {
        return Node.createLiteral(Utils.stringForm(this.value), null, XSDDatatype.XSDfloat);
    }

    public String asString() {
        return this.toString();
    }

    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return Float.toString(this.value);
    }

    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

