/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.rdf.arp.test.ARPTests;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WGReasonerTester {
    public static final String NS = "http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#";
    public static final String BASE_URI = "http://www.w3.org/2000/10/rdf-tests/rdfcore/";
    public static final String DEFAULT_BASE_DIR = "testing/wg/";
    protected final String baseDir;
    public static final Resource PositiveEntailmentTest;
    public static final Resource NegativeEntailmentTest;
    public static final Resource FalseDocument;
    public static final Property descriptionP;
    public static final Property statusP;
    public static final Property entailmentRulesP;
    public static final Property premiseDocumentP;
    public static final Property conclusionDocumentP;
    Resource testType;
    public static final String[] blockedTests;
    protected Model testManifest;
    protected static Log logger;
    public static final int FAIL = -1;
    public static final int NOT_APPLICABLE = 0;
    public static final int INCOMPLETE = 1;
    public static final int PASS = 2;

    public WGReasonerTester(String manifest, String baseDir) throws IOException {
        this.baseDir = baseDir;
        this.testManifest = this.loadFile(manifest);
    }

    public WGReasonerTester(String manifest) throws IOException {
        this(manifest, DEFAULT_BASE_DIR);
    }

    public Model loadFile(String file) throws IOException {
        String langType = "RDF/XML";
        if (file.endsWith(".nt")) {
            langType = "N-TRIPLE";
        } else if (file.endsWith("n3")) {
            langType = "N3";
        }
        Model result = ModelFactory.createNonreifyingModel();
        String fname = file;
        if (fname.startsWith(BASE_URI)) {
            fname = fname.substring(BASE_URI.length());
        }
        InputStream in = this.baseDir.startsWith("http:") ? new URL(this.baseDir + fname).openStream() : new FileInputStream(this.baseDir + fname);
        in = new BufferedInputStream(in);
        result.read(in, BASE_URI + fname, langType);
        return result;
    }

    private Graph loadTestFile(Resource test, Property predicate) throws IOException {
        if (test.hasProperty(predicate)) {
            String fileName = ((Object)test.getRequiredProperty(predicate).getObject()).toString();
            return this.loadFile(fileName).getGraph();
        }
        return Factory.createGraphMem();
    }

    public boolean runTests(ReasonerFactory reasonerF, TestCase testcase, Resource configuration) throws IOException {
        Iterator i = this.listTests().iterator();
        while (i.hasNext()) {
            String test = (String)i.next();
            if (this.runTest(test, reasonerF, testcase, configuration)) continue;
            return false;
        }
        return true;
    }

    public List listTests() {
        ArrayList<String> testList = new ArrayList<String>();
        ResIterator tests = this.testManifest.listResourcesWithProperty(RDF.type, PositiveEntailmentTest);
        while (tests.hasNext()) {
            testList.add(tests.next().toString());
        }
        tests = this.testManifest.listResourcesWithProperty(RDF.type, NegativeEntailmentTest);
        while (tests.hasNext()) {
            testList.add(tests.next().toString());
        }
        return testList;
    }

    public Resource getTypeOfLastTest() {
        return this.testType;
    }

    public boolean runTest(String uri, ReasonerFactory reasonerF, TestCase testcase, Resource configuration) throws IOException {
        return this.runTestDetailedResponse(uri, reasonerF, testcase, configuration) != -1;
    }

    public int runTestDetailedResponse(String uri, ReasonerFactory reasonerF, TestCase testcase, Resource configuration) throws IOException {
        boolean noisy;
        Resource test = this.testManifest.getResource(uri);
        this.testType = (Resource)test.getRequiredProperty(RDF.type).getObject();
        if (!((Object)this.testType).equals(NegativeEntailmentTest) && !((Object)this.testType).equals(PositiveEntailmentTest)) {
            throw new JenaException("Can't find test: " + uri);
        }
        Statement descriptionS = test.getProperty(descriptionP);
        String description = descriptionS == null ? "no description" : ((Object)descriptionS.getObject()).toString();
        String status = ((Object)test.getRequiredProperty(statusP).getObject()).toString();
        logger.debug("WG test " + test.getURI() + " - " + status);
        if (!status.equals("APPROVED")) {
            return 0;
        }
        for (int i = 0; i < blockedTests.length; ++i) {
            if (!test.getURI().equals(blockedTests[i])) continue;
            return 0;
        }
        Model premises = ModelFactory.createNonreifyingModel();
        StmtIterator premisesI = test.listProperties(premiseDocumentP);
        while (premisesI.hasNext()) {
            premises.add(this.loadFile(((Object)premisesI.nextStatement().getObject()).toString()));
        }
        Model conclusions = null;
        Resource conclusionsRes = (Resource)test.getRequiredProperty(conclusionDocumentP).getObject();
        Resource conclusionsType = (Resource)conclusionsRes.getRequiredProperty(RDF.type).getObject();
        if (!((Object)conclusionsType).equals(FalseDocument)) {
            conclusions = this.loadFile(((Object)conclusionsRes).toString());
        }
        Reasoner reasoner = reasonerF.create(configuration);
        InfGraph graph = reasoner.bind(premises.getGraph());
        Model result = ModelFactory.createModelForGraph(graph);
        boolean correct = true;
        int goodResult = 2;
        boolean bl = noisy = !this.baseDir.equals(DEFAULT_BASE_DIR) && !ARPTests.internet;
        if (((Object)this.testType).equals(PositiveEntailmentTest)) {
            if (conclusions == null) {
                boolean bl2 = correct = !graph.validate().isValid();
                if (noisy) {
                    System.out.println("PositiveEntailmentTest of FalseDoc " + test.getURI() + (correct ? " - OK" : " - FAIL"));
                }
            } else {
                correct = this.testConclusions(conclusions.getGraph(), result.getGraph());
                if (!graph.validate().isValid()) {
                    correct = false;
                }
                if (noisy) {
                    System.out.println("PositiveEntailmentTest " + test.getURI() + (correct ? " - OK" : " - FAIL"));
                }
            }
        } else {
            goodResult = 1;
            if (conclusions == null) {
                correct = graph.validate().isValid();
                if (noisy) {
                    System.out.println("NegativentailmentTest of FalseDoc " + test.getURI() + (correct ? " - OK" : " - FAIL"));
                }
            } else {
                boolean bl3 = correct = !this.testConclusions(conclusions.getGraph(), result.getGraph());
                if (noisy) {
                    System.out.println("NegativeEntailmentTest " + test.getURI() + (correct ? " - OK" : " - FAIL"));
                }
            }
        }
        if (!correct) {
            logger.debug("Premises: ");
            StmtIterator i = premises.listStatements();
            while (i.hasNext()) {
                logger.debug("  - " + i.nextStatement());
            }
            logger.debug("Conclusions: ");
            if (conclusions != null) {
                i = conclusions.listStatements();
                while (i.hasNext()) {
                    logger.debug("  - " + i.nextStatement());
                }
            }
        }
        if (testcase != null) {
            TestCase.assertTrue("Test: " + test + "\n" + description, correct);
        }
        return correct ? goodResult : -1;
    }

    private boolean testConclusions(Graph conclusions, Graph result) {
        QueryHandler qh = result.queryHandler();
        Query query2 = WGReasonerTester.graphToQuery(conclusions);
        ExtendedIterator i = qh.prepareBindings(query2, new Node[0]).executeBindings();
        return i.hasNext();
    }

    public static Query graphToQuery(Graph graph) {
        HashMap bnodeToVar = new HashMap();
        Query query2 = new Query();
        ExtendedIterator i = graph.find(null, null, null);
        while (i.hasNext()) {
            Triple triple = (Triple)i.next();
            query2.addMatch(WGReasonerTester.translate(triple.getSubject(), bnodeToVar), WGReasonerTester.translate(triple.getPredicate(), bnodeToVar), WGReasonerTester.translate(triple.getObject(), bnodeToVar));
        }
        return query2;
    }

    private static Node translate(Node node, HashMap bnodeToVar) {
        String varnames = "abcdefghijklmnopqrstuvwxyz";
        if (node.isBlank()) {
            Node t = (Node)bnodeToVar.get(node);
            if (t == null) {
                int i = bnodeToVar.size();
                if (i > varnames.length()) {
                    throw new ReasonerException("Too many bnodes in query");
                }
                t = Node.createVariable(varnames.substring(i, i + 1));
                bnodeToVar.put(node, t);
            }
            return t;
        }
        return node;
    }

    static {
        blockedTests = new String[]{"http://www.w3.org/2000/10/rdf-tests/rdfcore/datatypes/Manifest.rdf#language-important-for-non-dt-entailment-1", "http://www.w3.org/2000/10/rdf-tests/rdfcore/datatypes/Manifest.rdf#language-important-for-non-dt-entailment-2", "http://www.w3.org/2000/10/rdf-tests/rdfcore/pfps-10/Manifest.rdf#non-well-formed-literal-1", "http://www.w3.org/2000/10/rdf-tests/rdfcore/xmlsch-02/Manifest.rdf#whitespace-facet-3"};
        PositiveEntailmentTest = new ResourceImpl(NS, "PositiveEntailmentTest");
        NegativeEntailmentTest = new ResourceImpl(NS, "NegativeEntailmentTest");
        FalseDocument = new ResourceImpl(NS, "False-Document");
        descriptionP = new PropertyImpl(NS, "description");
        statusP = new PropertyImpl(NS, "status");
        entailmentRulesP = new PropertyImpl(NS, "entailmentRules");
        premiseDocumentP = new PropertyImpl(NS, "premiseDocument");
        conclusionDocumentP = new PropertyImpl(NS, "conclusionDocument");
        logger = LogFactory.getLog(WGReasonerTester.class);
    }
}

