/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.OWLExptRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.OWLRuleReasonerFactory;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugOWL {
    Reasoner reasoner;
    Graph testdata = Factory.createGraphMem();
    Graph schema = null;
    InfGraph infgraph;
    Node[] concepts;
    Node[] instances;
    Node[] properties;
    static Log logger = LogFactory.getLog(DebugOWL.class);
    public static final int EXPT = 1;
    public static final int OWLFB = 2;
    public static final int OWL = 3;
    public static final int RDFSFB = 4;
    public static final int RDFSFinal = 5;
    public static final int OWLExpt = 6;
    public static final int RDFSLPExpt = 7;

    public DebugOWL(int config) {
        switch (config) {
            case 1: {
                this.reasoner = GenericRuleReasonerFactory.theInstance().create(null);
                GenericRuleReasoner grr = (GenericRuleReasoner)this.reasoner;
                grr.setMode(GenericRuleReasoner.HYBRID);
                try {
                    grr.setRules(Rule.parseRules(Util.loadRuleParserFromResourceFile("etc/expt.rules")));
                }
                catch (WrappedIOException e2) {
                    System.out.println("Failed to open rules file: " + e2.getCause());
                    System.exit(1);
                }
                break;
            }
            case 2: {
                this.reasoner = OWLFBRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 3: {
                this.reasoner = OWLRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 4: {
                this.reasoner = RDFSFBRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 5: {
                this.reasoner = RDFSRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 6: {
                this.reasoner = OWLExptRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 7: {
                try {
                    List rules = Rule.parseRules(Util.loadRuleParserFromResourceFile("etc/expt.rules"));
                    this.reasoner = new FBRuleReasoner(rules);
                    break;
                }
                catch (WrappedIOException e3) {
                    System.out.println("Failed to open rules file: " + e3.getCause());
                    System.exit(1);
                }
            }
        }
    }

    public void load(String testFile) {
        this.testdata = FileManager.get().loadModel(testFile).getGraph();
        this.schema = null;
    }

    public void load(String schemaFile, String testFile) {
        this.testdata = FileManager.get().loadModel(testFile).getGraph();
        this.schema = FileManager.get().loadModel(schemaFile).getGraph();
    }

    public void createTest(int depth, int NS, int NI, boolean withProps) {
        int numClasses = 0;
        int levelSize = 1;
        for (int i = 0; i < depth; ++i) {
            numClasses += (levelSize *= NS);
        }
        this.concepts = new Node[numClasses];
        this.properties = new Node[numClasses];
        this.instances = new Node[numClasses * NI];
        logger.info("Classes: " + numClasses + " Instances: " + numClasses * NI + (withProps ? " with properties" : ""));
        this.testdata = Factory.createGraphMem();
        int conceptPtr = 0;
        int levelStart = 0;
        int levelEnd = 0;
        int instancePtr = 0;
        for (int i = 0; i < depth; ++i) {
            int k;
            Node concept;
            int j;
            Node property = null;
            if (i == 0) {
                for (j = 0; j < NS; ++j) {
                    concept = Node.createURI("concept" + conceptPtr);
                    if (withProps) {
                        this.properties[conceptPtr] = property = Node.createURI("prop" + conceptPtr);
                    }
                    this.concepts[conceptPtr++] = concept;
                }
            } else {
                for (j = levelStart; j < levelEnd; ++j) {
                    Node superConcept = this.concepts[j];
                    for (k = 0; k < NS; ++k) {
                        Node concept2 = Node.createURI("concept" + conceptPtr);
                        if (withProps) {
                            this.properties[conceptPtr] = property = Node.createURI("prop" + conceptPtr);
                        }
                        this.concepts[conceptPtr++] = concept2;
                        this.testdata.add(new Triple(concept2, RDFS.subClassOf.asNode(), superConcept));
                    }
                }
            }
            levelStart = levelEnd;
            levelEnd = conceptPtr;
            for (j = levelStart; j < levelEnd; ++j) {
                concept = this.concepts[j];
                for (k = 0; k < NI; ++k) {
                    Node instance = Node.createURI("instance" + instancePtr);
                    this.testdata.add(new Triple(instance, RDF.type.asNode(), concept));
                    if (withProps && (k - 1) % 3 == 0) {
                        this.testdata.add(new Triple(this.instances[instancePtr - 1], property, instance));
                    }
                    this.instances[instancePtr++] = instance;
                }
            }
        }
    }

    public void init() {
        this.infgraph = this.schema == null ? this.reasoner.bind(this.testdata) : this.reasoner.bind(new Union(this.schema, this.testdata));
        if (this.infgraph instanceof FBRuleInfGraph) {
            System.out.println("Starting prepare");
            ((FBRuleInfGraph)this.infgraph).prepare();
            System.out.println(".. finished");
        }
    }

    long listC0(boolean print) {
        return this.list(null, RDF.type.asNode(), this.concepts[0], print);
    }

    long list(Node s, Node p, Node o, boolean print) {
        long t1 = System.currentTimeMillis();
        this.init();
        int count = 0;
        ExtendedIterator i = this.infgraph.find(s, p, o);
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            ++count;
            if (!print) continue;
            logger.info(PrintUtil.print(t));
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Found " + count + " results");
        return t2 - t1;
    }

    public void runListClassesTest(int depth, int NS, int NI, boolean withProps) {
        this.createTest(depth, NS, NI, withProps);
        long t = this.list(null, RDF.type.asNode(), RDFS.Class.asNode(), false);
        System.out.println("Took " + t + "ms");
    }

    public void runVolz(int depth, int NS, int NI, boolean withProps) {
        this.createTest(depth, NS, NI, withProps);
        long t = this.listC0(false);
        System.out.println("Took " + t + "ms");
        if (this.infgraph instanceof FBRuleInfGraph) {
            ((FBRuleInfGraph)this.infgraph).printLPProfile();
        }
    }

    public void runVolz() {
        this.runVolz(3, 5, 10, false);
        this.runVolz(3, 5, 10, false);
        this.runVolz(4, 5, 10, false);
        this.runVolz(5, 5, 10, false);
    }

    public void listClassesOn(String filename) {
        this.load(filename);
        System.out.println("Testing: " + filename);
        long t = this.list(null, RDF.type.asNode(), RDFS.Class.asNode(), false);
        System.out.println("Took " + t + "ms");
    }

    public static void main(String[] args) {
        try {
            String dataFile = "file:testing/ontology/owl/list-syntax/test-with-import.rdf";
            String schemaFile = "file:vocabularies/owl.owl";
            String schemaFile2 = "file:testing/reasoners/bugs/owl-partial.owl";
            String dataFile2 = "file:testing/reasoners/bugs/test.owl";
            String food = "file:testing/reasoners/bugs/food.owl";
            System.out.println("Volz tests on normal RDFS, tgc + type rules");
            new DebugOWL(5).runVolz();
        }
        catch (Exception e2) {
            System.out.println("Problem: " + e2);
            e2.printStackTrace();
        }
    }
}

