/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalResults;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalState;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.RuleInstance;

public class RuleState {
    protected RuleInstance ruleInstance;
    protected RuleState prev;
    protected BindingVector env;
    protected GoalState goalState;
    protected boolean isScheduled = false;
    int clauseIndex;
    int subjectBind;
    int predicateBind;
    int objectBind;
    protected Functor functorMatch = null;

    public RuleState(RuleState parent, TriplePattern clause, int index, BindingVector env) {
        this.prev = parent;
        this.ruleInstance = parent.ruleInstance;
        this.clauseIndex = index;
        this.env = env;
        TriplePattern subgoal = env.partInstantiate(clause);
        this.goalState = this.ruleInstance.engine.findGoal(subgoal);
        this.initMapping(subgoal);
        this.ruleInstance.generator.incRefCount();
    }

    private RuleState(RuleInstance ruleInstance, BindingVector env, GoalState goalState, int index) {
        this.prev = null;
        this.ruleInstance = ruleInstance;
        this.env = env;
        this.goalState = goalState;
        this.clauseIndex = index;
        ruleInstance.generator.incRefCount();
    }

    Object next() {
        if (this.goalState == null) {
            return StateFlag.SATISFIED;
        }
        return this.goalState.next();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BindingVector newEnvironment(Triple result) {
        Node[] args;
        BindingVector newenv = new BindingVector(this.env);
        if (this.subjectBind != -1) {
            newenv.bind(this.subjectBind, result.getSubject());
        }
        if (this.predicateBind != -1) {
            newenv.bind(this.predicateBind, result.getPredicate());
        }
        if (this.objectBind != -1) {
            newenv.bind(this.objectBind, result.getObject());
        }
        if (this.functorMatch == null) return newenv;
        Node obj = result.getObject();
        if (!Functor.isFunctor(obj)) return null;
        Functor objValue = (Functor)obj.getLiteralValue();
        if (!objValue.getName().equals(this.functorMatch.getName())) return null;
        Node[] margs = this.functorMatch.getArgs();
        if (margs.length != (args = objValue.getArgs()).length) {
            return null;
        }
        for (int i = 0; i < margs.length; ++i) {
            Node match2 = margs[i];
            if (!(match2 instanceof Node_RuleVariable)) continue;
            Node val = args[i];
            if (Functor.isFunctor(val)) {
                return null;
            }
            if (newenv.bind(match2, val)) continue;
            return null;
        }
        return newenv;
    }

    public Triple getResult(BindingVector newenv) {
        return newenv.instantiate(this.ruleInstance.head);
    }

    public boolean couldProcess() {
        if (this.goalState == null) {
            return true;
        }
        return this.goalState.couldProcess();
    }

    private void initMapping(TriplePattern goal) {
        Node n = goal.getSubject();
        this.subjectBind = n instanceof Node_RuleVariable ? ((Node_RuleVariable)n).getIndex() : -1;
        n = goal.getPredicate();
        this.predicateBind = n instanceof Node_RuleVariable ? ((Node_RuleVariable)n).getIndex() : -1;
        n = goal.getObject();
        int n2 = this.objectBind = n instanceof Node_RuleVariable ? ((Node_RuleVariable)n).getIndex() : -1;
        if (Functor.isFunctor(n)) {
            this.functorMatch = (Functor)n.getLiteralValue();
        }
    }

    protected int nextClauseIndex() {
        if (this.ruleInstance.clausesReordered) {
            if (this.clauseIndex == this.ruleInstance.secondClause + 1) {
                return this.ruleInstance.secondClause - 1;
            }
            if (this.clauseIndex == this.ruleInstance.secondClause) {
                return this.clauseIndex + 1;
            }
        }
        return this.clauseIndex;
    }

    public void close() {
        if (this.goalState != null) {
            this.goalState.close();
        }
        this.ruleInstance.generator.decRefCount();
    }

    public static RuleState createInitialState(Rule rule, GoalResults generator) {
        TriplePattern goal = generator.goal;
        TriplePattern head = (TriplePattern)rule.getHeadElement(0);
        BindingVector env = BindingVector.unify(goal, head, rule.getNumVars());
        if (env == null) {
            return null;
        }
        RuleInstance ri = new RuleInstance(generator, rule, head);
        int maxClause = rule.bodyLength();
        int clauseIndex = 0;
        while (clauseIndex < maxClause) {
            ClauseEntry clause;
            if ((clause = rule.getBodyElement(clauseIndex++)) instanceof TriplePattern) {
                TriplePattern subgoal;
                ClauseEntry secondClause = null;
                boolean foundSecondClause = false;
                if (clauseIndex < maxClause && (secondClause = rule.getBodyElement(clauseIndex)) instanceof TriplePattern) {
                    foundSecondClause = true;
                }
                if (foundSecondClause) {
                    int score1 = RuleState.scoreClauseBoundness((TriplePattern)clause, head, env);
                    int score2 = RuleState.scoreClauseBoundness((TriplePattern)secondClause, head, env);
                    if (score2 > score1) {
                        ri.clausesReordered = true;
                        ri.secondClause = clauseIndex++;
                        clause = secondClause;
                    }
                }
                if (!(subgoal = env.partInstantiate((TriplePattern)clause)).isLegal()) {
                    return null;
                }
                GoalState gs = generator.getEngine().findGoal(subgoal);
                RuleState rs = new RuleState(ri, env, gs, clauseIndex);
                rs.initMapping(subgoal);
                return rs;
            }
            if (generator.getEngine().processBuiltin(clause, rule, env)) continue;
            return null;
        }
        return new RuleState(ri, env, null, 0);
    }

    private static int scoreClauseBoundness(TriplePattern clause, TriplePattern head, BindingVector env) {
        return RuleState.scoreNodeBoundness(clause.getSubject(), head, env) + RuleState.scoreNodeBoundness(clause.getPredicate(), head, env) + RuleState.scoreNodeBoundness(clause.getObject(), head, env);
    }

    private static int scoreNodeBoundness(Node n, TriplePattern head, BindingVector env) {
        if (n.isVariable()) {
            if (n == head.getSubject() || n == head.getPredicate() || n == head.getObject()) {
                Node val = env.getBinding(n);
                if (val == null || val.isVariable()) {
                    return -5;
                }
                return 5;
            }
            return 0;
        }
        return 1;
    }

    public String toString() {
        return "RuleState " + this.ruleInstance.rule.toShortString() + "(" + (this.clauseIndex - 1) + ")" + ", gs=" + this.goalState;
    }
}

