/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.states.test;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.impl.AbsXMLContext;
import com.hp.hpl.jena.rdf.arp.impl.AttributeLexer;
import com.hp.hpl.jena.rdf.arp.impl.Names;
import com.hp.hpl.jena.rdf.arp.impl.URIReference;
import com.hp.hpl.jena.rdf.arp.impl.XMLBaselessContext;
import com.hp.hpl.jena.rdf.arp.impl.XMLHandler;
import com.hp.hpl.jena.rdf.arp.states.AbsXMLLiteral;
import com.hp.hpl.jena.rdf.arp.states.DAMLCollection;
import com.hp.hpl.jena.rdf.arp.states.FrameI;
import com.hp.hpl.jena.rdf.arp.states.HasSubjectFrameI;
import com.hp.hpl.jena.rdf.arp.states.InnerXMLLiteral;
import com.hp.hpl.jena.rdf.arp.states.LookingForRDF;
import com.hp.hpl.jena.rdf.arp.states.OuterXMLLiteral;
import com.hp.hpl.jena.rdf.arp.states.RDFCollection;
import com.hp.hpl.jena.rdf.arp.states.WantEmpty;
import com.hp.hpl.jena.rdf.arp.states.WantLiteralValueOrDescription;
import com.hp.hpl.jena.rdf.arp.states.WantPropertyElement;
import com.hp.hpl.jena.rdf.arp.states.WantTopLevelDescription;
import com.hp.hpl.jena.rdf.arp.states.WantTypedLiteral;
import com.hp.hpl.jena.rdf.arp.states.WantsObjectFrameI;
import com.hp.hpl.jena.rdf.arp.states.test.AttrEvent;
import com.hp.hpl.jena.rdf.arp.states.test.ElementEvent;
import com.hp.hpl.jena.rdf.arp.states.test.Event;
import com.hp.hpl.jena.rdf.arp.states.test.EventList;
import com.hp.hpl.jena.rdf.arp.states.test.InternalEvent;
import com.hp.hpl.jena.rdf.arp.states.test.QName;
import com.hp.hpl.jena.rdf.arp.states.test.TestFrame;
import com.hp.hpl.jena.rdf.arp.states.test.TestHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class TestData
implements ARPErrorNumbers {
    private static final URIReference foo = URIReference.createNoChecks("http://foo/");
    private static final URIReference bar = URIReference.createNoChecks("http://bar/");
    static TestHandler xmlHandler = new TestHandler();
    static String dataFile = "testing/arp/state.txt";
    static AbsXMLContext xmlContext;
    static TestFrame testFrame;
    static char[] white;
    static char[] black;
    private static final AttrEvent xmlSpace;
    static Event[] allEvents;
    static Map short2Event;
    static Map state2Name;
    static Map state2ShortName;
    static Map shortName2State;
    static Map state2Args;
    static AttributeLexer ap;
    int localCount;
    int globalCount;
    private EventList eventList = new EventList();
    String[] characters = new String[]{"<eg:Goo>", "<eg:Goo> </end>", "<eg:Goo> </end> <eg:Goo>", "'abcde'", "'abcde' <eg:Goo>", "'abcde' </end>", "</end>", "pred-object", "object"};
    boolean inCharacterize = false;
    static Class[] tryClasses;
    private Random dice = new Random(23L);
    Set data = new TreeSet(new Comparator(){

        public int compare(Object arg1, Object arg2) {
            StringBuffer b1 = new StringBuffer((String)arg1).reverse();
            StringBuffer b2 = new StringBuffer((String)arg2).reverse();
            return b1.toString().compareTo(b2.toString());
        }
    });
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$impl$XMLContext;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$impl$AbsXMLContext;

    static void add(String sh, String nm, Class f, Object[] args) {
        state2Name.put(f, nm);
        sh = TestData.getSimpleName(f);
        if (shortName2State.get(sh) != null) {
            System.err.println("Duplicate: " + sh);
        }
        state2Args.put(f, args);
        shortName2State.put(sh, f);
        state2ShortName.put(f, sh);
    }

    private static String getSimpleName(Class f) {
        return XMLHandler.getSimpleName(f);
    }

    void characterize(Class f) {
        this.inCharacterize = true;
        int sz = this.eventList.size;
        StringBuffer rslt = new StringBuffer();
        String skip = null;
        this.eventList.test(f);
        rslt.append(this.eventListName(f, null));
        rslt.append(" $ " + this.testInfo(f) + " {");
        if (this.eventList.testResult.getClass() != LookingForRDF.class) {
            for (int i = 0; i < this.characters.length; ++i) {
                if (skip != null && this.characters[i].startsWith(skip)) continue;
                skip = null;
                this.addEvents(this.characters[i]);
                rslt.append(" " + this.characters[i] + " $ ");
                boolean testV = this.eventList.test(f);
                rslt.append(this.testInfo(f) + " ;");
                this.eventList.size = sz;
                if (testV) continue;
                skip = this.characters[i];
            }
        }
        rslt.append(" }");
        this.data.add(rslt.toString());
        this.inCharacterize = false;
    }

    private String eventListName(Class f, Class f2) {
        StringBuffer rslt = new StringBuffer();
        rslt.append(this.stateName(f, f2));
        for (int i = 0; i < this.eventList.size; ++i) {
            rslt.append(' ');
            rslt.append(this.eventList.events[i].oneChar);
        }
        return rslt.toString();
    }

    private String stateName(Class f, Class f2) {
        return f == f2 ? "*" : (String)state2ShortName.get(f);
    }

    private void addEvents(String string) {
        String[] all = string.split(" ");
        for (int i = 0; i < all.length; ++i) {
            this.eventList.add((Event)short2Event.get(all[i]));
        }
    }

    private String testInfo(Class f) {
        return this.eventList.testFailure ? (this.eventList.testException ? "!" : "?") : this.stateName(this.eventList.testResult.getClass(), f) + " " + xmlHandler.info() + " " + testFrame.info();
    }

    static FrameI create(Class cl) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        FrameI frame = null;
        Object[] args = (Object[])state2Args.get(cl);
        Class[] types = new Class[args.length];
        for (int i = 1; i < args.length; ++i) {
            types[i] = args[i].getClass();
            if (types[i] != (class$com$hp$hpl$jena$rdf$arp$impl$XMLContext == null ? TestData.class$("com.hp.hpl.jena.rdf.arp.impl.XMLContext") : class$com$hp$hpl$jena$rdf$arp$impl$XMLContext)) continue;
            types[i] = class$com$hp$hpl$jena$rdf$arp$impl$AbsXMLContext == null ? TestData.class$("com.hp.hpl.jena.rdf.arp.impl.AbsXMLContext") : class$com$hp$hpl$jena$rdf$arp$impl$AbsXMLContext;
        }
        if (cl == InnerXMLLiteral.class) {
            types[2] = Map.class;
        }
        for (int j = 0; j < tryClasses.length; ++j) {
            types[0] = tryClasses[j];
            try {
                frame = (FrameI)cl.getConstructor(types).newInstance(args);
                break;
            }
            catch (NoSuchMethodException e2) {
                continue;
            }
        }
        return frame;
    }

    void expand(Class f) {
        if (AbsXMLLiteral.class.isAssignableFrom(f)) {
            return;
        }
        if (this.randomPurgeXMLAttrs()) {
            return;
        }
        ++this.localCount;
        ++this.globalCount;
        if (this.localCount % 20000 == 0) {
            this.stats(f);
        }
        if (!this.eventList.test(f)) {
            if (!this.shorterTestFails(f)) {
                this.data.add(this.eventListName(f, null) + " $ " + this.testInfo(f));
            }
            return;
        }
        this.characterize(f);
        if (this.eventList.size >= (AbsXMLLiteral.class.isAssignableFrom(f) ? 3 : (this.eventList.testResult instanceof LookingForRDF ? 2 : 8))) {
            return;
        }
        for (int i = 0; i < allEvents.length; ++i) {
            Event e2;
            if (!allEvents[i].isAttribute() || !(e2 = this.eventList.last()).isElement() && (!e2.isAttribute() || e2.hashCode() >= allEvents[i].hashCode())) continue;
            this.eventList.add(allEvents[i]);
            this.expand(f);
            this.eventList.pop();
        }
    }

    private boolean randomPurgeXMLAttrs() {
        int weight = 0;
        this.eventList.rewind();
        while (this.eventList.hasNext()) {
            Event e2 = this.eventList.next();
            if (e2 == xmlSpace) {
                weight += 2;
                continue;
            }
            if (!e2.isAttribute() || !((AttrEvent)e2).q.uri.equals(Names.xmlns)) continue;
            ++weight;
        }
        while (weight-- > 0) {
            if (!this.dice.nextBoolean()) continue;
            return true;
        }
        return false;
    }

    private boolean shorterTestFails(Class f) {
        if (this.eventList.size <= 2) {
            return false;
        }
        for (int i = 1; i < this.eventList.size - 1; ++i) {
            EventList copy = this.eventList.copy();
            copy.delete(i);
            if (copy.test(f)) continue;
            return true;
        }
        return false;
    }

    void stats(Class f) {
    }

    void test1() throws IOException {
        Iterator<Object> it = state2Name.keySet().iterator();
        while (it.hasNext()) {
            Class f = (Class)it.next();
            this.localCount = 0;
            for (int i = 0; i < allEvents.length; ++i) {
                if (!allEvents[i].isElement()) continue;
                this.eventList.clear();
                this.eventList.add(allEvents[i]);
                this.expand(f);
            }
            this.stats(f);
        }
        FileWriter fw = new FileWriter(dataFile);
        it = this.data.iterator();
        while (it.hasNext()) {
            fw.write((String)it.next());
            fw.write(10);
        }
        fw.close();
    }

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        new TestData().test1();
        System.out.println(System.currentTimeMillis() - start + " ms");
    }

    public static String stateLongName(String sh) {
        return (String)state2Name.get(shortName2State.get(sh));
    }

    public static Class toState(String sh) {
        return (Class)shortName2State.get(sh);
    }

    static {
        try {
            xmlContext = new XMLBaselessContext(xmlHandler, 215).withBase(xmlHandler, "http://example.org/base/");
        }
        catch (SAXParseException e2) {
            throw new RuntimeException(e2);
        }
        testFrame = new TestFrame(xmlHandler, xmlContext);
        white = new char[]{' ', ' ', ' ', ' ', ' '};
        black = new char[]{'a', 'b', 'c', 'd', 'e'};
        xmlSpace = new AttrEvent(QName.xml("space"));
        allEvents = new Event[]{new ElementEvent(QName.rdf("li")), new ElementEvent(QName.rdf("Description")), new ElementEvent("F", QName.rdf("RDF")), new ElementEvent(QName.eg("Goo")), new AttrEvent(QName.xml("base")), new AttrEvent("g", QName.xml("lang"), "en"), new AttrEvent(QName.eg("foo")), xmlSpace, new AttrEvent("B", QName.rdf("bagID"), "en"), new AttrEvent(QName.rdf("about")), new AttrEvent("h", QName.rdf("aboutEach"), "en"), new AttrEvent("H", QName.rdf("aboutEachPrefix"), "en"), new AttrEvent(QName.rdf("ID")), new AttrEvent(QName.rdf("nodeID")), new AttrEvent(QName.rdf("resource")), new AttrEvent(QName.rdf("type")), new AttrEvent(QName.rdf("datatype")), new AttrEvent("C", QName.rdf("parseType"), "Collection"), new AttrEvent("L", QName.rdf("parseType"), "Literal"), new AttrEvent("R", QName.rdf("parseType"), "Resource"), new InternalEvent("e", "</end>"){

            FrameI apply(FrameI from, Attributes att) throws SAXParseException {
                from.endElement();
                return from.getParent();
            }
        }, new InternalEvent("O", "object"){

            FrameI apply(FrameI from, Attributes att) {
                ((WantsObjectFrameI)from).theObject(foo);
                return from;
            }
        }, new InternalEvent("W", "white"){

            FrameI apply(FrameI from, Attributes att) throws SAXParseException {
                from.characters(white, 0, 5);
                return from;
            }
        }, new InternalEvent("Q", "'abcde'"){

            FrameI apply(FrameI from, Attributes att) throws SAXParseException {
                from.characters(black, 0, 5);
                return from;
            }
        }, new InternalEvent("P", "pred-object"){

            FrameI apply(FrameI from, Attributes att) {
                ((HasSubjectFrameI)from).aPredAndObj(foo, bar);
                return from;
            }
        }};
        short2Event = new HashMap();
        for (int i = 0; i < allEvents.length; ++i) {
            String key = TestData.allEvents[i].oneChar;
            if (short2Event.get(key) != null) {
                System.err.println("Duplicate event code: " + key);
            }
            short2Event.put(key, allEvents[i]);
        }
        state2Name = new HashMap();
        state2ShortName = new HashMap();
        shortName2State = new HashMap();
        state2Args = new HashMap();
        ap = new AttributeLexer(testFrame, 0, 0);
        TestData.add("ix", "inner-xml-literal", InnerXMLLiteral.class, new Object[]{testFrame, "foo", TestData.testFrame.namespaces});
        TestData.add("xl", "xml-literal", OuterXMLLiteral.class, new Object[]{testFrame, xmlContext});
        TestData.add("ip", "vanilla-prop-elt", WantLiteralValueOrDescription.class, new Object[]{testFrame, xmlContext});
        TestData.add("tl", "typed-literal", WantTypedLiteral.class, new Object[]{testFrame, "http://ex/dt", xmlContext});
        TestData.add("dl", "daml:collection", DAMLCollection.class, new Object[]{testFrame, xmlContext});
        TestData.add("cl", "collection", RDFCollection.class, new Object[]{testFrame, xmlContext});
        TestData.add("tp", "top-level", WantTopLevelDescription.class, new Object[]{testFrame, ap});
        TestData.add("em", "empty-prop-elt", WantEmpty.class, new Object[]{testFrame, xmlContext});
        TestData.add("de", "inside-Description", WantPropertyElement.class, new Object[]{testFrame, xmlContext});
        TestData.add("RD", "looking-for-RDF", LookingForRDF.class, new Object[]{testFrame, ap});
        tryClasses = new Class[]{FrameI.class, AbsXMLLiteral.class, HasSubjectFrameI.class, WantsObjectFrameI.class};
    }
}

