/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import junit.framework.TestSuite;

public class TestIndividual
extends OntTestBase {
    public static TestSuite suite() {
        return new TestIndividual("TestIndividual");
    }

    public TestIndividual(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("Individual.sameAs", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual x = m.createIndividual(A);
                Individual y = m.createIndividual(A);
                Individual z = m.createIndividual(A);
                x.addSameAs(y);
                1.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.SAME_AS()));
                1.assertEquals("x should be the same as y", y, x.getSameAs());
                1.assertTrue("x should be the same as y", x.isSameAs(y));
                x.addSameAs(z);
                1.assertEquals("Cardinality should be 2", 2, x.getCardinality(prof.SAME_AS()));
                this.iteratorTest(x.listSameAs(), new Object[]{z, y});
                x.setSameAs(z);
                1.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.SAME_AS()));
                1.assertEquals("x should be same indiv. as z", z, x.getSameAs());
                x.removeSameAs(y);
                1.assertEquals("Cardinality should be 1", 1, x.getCardinality(prof.SAME_AS()));
                x.removeSameAs(z);
                1.assertEquals("Cardinality should be 0", 0, x.getCardinality(prof.SAME_AS()));
            }
        }, new OntTestBase.OntTestCase("Individual.hasOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual(A);
                2.assertTrue(x.hasOntClass(A));
                2.assertFalse(x.hasOntClass(B));
            }
        }, new OntTestBase.OntTestCase("Individual.hasOntClass direct", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass(B);
                Individual x = m.createIndividual(A);
                x.addRDFType(B);
                3.assertTrue(x.hasOntClass(A, false));
                3.assertTrue(x.hasOntClass(B, false));
                3.assertTrue(x.hasOntClass(A, false));
                3.assertTrue(x.hasOntClass(B, true));
            }
        }, new OntTestBase.OntTestCase("Individual.hasOntClass string", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual x = m.createIndividual(A);
                4.assertTrue(x.hasOntClass("http://jena.hpl.hp.com/testing/ontology#A"));
            }
        }, new OntTestBase.OntTestCase("Individual.getOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual x = m.createIndividual(A);
                5.assertEquals(A, x.getOntClass());
            }
        }, new OntTestBase.OntTestCase("Individual.getOntClass direct", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass(B);
                Individual x = m.createIndividual(A);
                x.addRDFType(B);
                6.assertEquals(B, x.getOntClass(true));
            }
        }, new OntTestBase.OntTestCase("Individual.listOntClasses", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass(B);
                Individual x = m.createIndividual(A);
                x.addRDFType(B);
                this.iteratorTest(x.listOntClasses(false), new Object[]{A, B});
                ExtendedIterator i = x.listOntClasses(false);
                while (i.hasNext()) {
                    7.assertTrue(i.next() instanceof OntClass);
                }
            }
        }, new OntTestBase.OntTestCase("Individual.listOntClasses direct", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass(B);
                Individual x = m.createIndividual(A);
                x.addRDFType(B);
                this.iteratorTest(x.listOntClasses(true), new Object[]{B});
                ExtendedIterator i = x.listOntClasses(true);
                while (i.hasNext()) {
                    8.assertTrue(i.next() instanceof OntClass);
                }
            }
        }, new OntTestBase.OntTestCase("Individual.addOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass(B);
                Individual x = m.createIndividual(A);
                this.iteratorTest(x.listOntClasses(false), new Object[]{A});
                x.addOntClass(B);
                this.iteratorTest(x.listOntClasses(false), new Object[]{A, B});
                ExtendedIterator i = x.listOntClasses(false);
                while (i.hasNext()) {
                    9.assertTrue(i.next() instanceof OntClass);
                }
            }
        }, new OntTestBase.OntTestCase("Individual.setOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass(B);
                Individual x = m.createIndividual(A);
                this.iteratorTest(x.listOntClasses(false), new Object[]{A});
                x.setOntClass(B);
                this.iteratorTest(x.listOntClasses(false), new Object[]{B});
                ExtendedIterator i = x.listOntClasses(false);
                while (i.hasNext()) {
                    10.assertTrue(i.next() instanceof OntClass);
                }
            }
        }, new OntTestBase.OntTestCase("Individual.removeOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual(A);
                x.addOntClass(B);
                this.iteratorTest(x.listOntClasses(false), new Object[]{A, B});
                x.removeOntClass(A);
                this.iteratorTest(x.listOntClasses(false), new Object[]{B});
                x.removeOntClass(A);
                this.iteratorTest(x.listOntClasses(false), new Object[]{B});
                x.removeOntClass(B);
                this.iteratorTest(x.listOntClasses(false), new Object[0]);
            }
        }};
    }
}

