/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.turtle.test;

import com.hp.hpl.jena.n3.turtle.TurtleEventNull;
import com.hp.hpl.jena.n3.turtle.parser.TurtleParser;
import com.hp.hpl.jena.util.junit.TestUtils;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TurtleInternalTests
extends TestSuite {
    public static final String QUOTE3 = "\"\"\"";
    public static boolean VERBOSE = false;

    public static TestSuite suite() {
        return new TurtleInternalTests();
    }

    public TurtleInternalTests() {
        super("Turtle Parser Syntactic tests");
        this.addTest(new Test("a:subj a:prop a:d ."));
        this.addTest(new Test("a:subj a:prop a:d . "));
        this.addTest(new Test("a:subj a:prop a:d."));
        this.addTest(new Test("a:subj a:prop a:d. "));
        this.addTest(new Test("rdf: rdf:type :_."));
        this.addTest(new Test("@prefix start: <somewhere>."));
        this.addTest(new Test("<http://here/subj> <http://here/prep> <http://here/obj>."));
        this.addTest(new Test("a:subj\ta:prop\ta:d.\t"));
        this.addTest(new Test("       a:subj\ta:prop\ta:d.     "));
        this.addTest(new Test("a:subj a:prop a:d.  "));
        this.addTest(new Test(""));
        this.addTest(new Test(" #Comment"));
        this.addTest(new Test("a:subj a:prop a:d.  # Comment"));
        this.addTest(new Test("a:subj a:prop a:d.# Comment"));
        this.addTest(new Test("a:subj a:prop 'string1'."));
        this.addTest(new Test("a:subj a:prop \"string2\"."));
        this.addTest(new Test("a:subj a:prop '''string3'''."));
        this.addTest(new Test("a:subj a:prop \"\"\"string3\"\"\"."));
        this.addTest(new Test("a:subj a:prop 'string1'^^x:dt."));
        this.addTest(new Test("a:subj a:prop 'string1'^^<uriref>."));
        this.addTest(new Test("a: :p 2. ."));
        this.addTest(new Test("a: :p +2. ."));
        this.addTest(new Test("a: :p -2 ."));
        this.addTest(new Test("a: :p 2e6."));
        this.addTest(new Test("a: :p 2e-6."));
        this.addTest(new Test("a: :p -2e-6."));
        this.addTest(new Test("a: :p 2.0e-6."));
        this.addTest(new Test("a: :p 2.0 ."));
        this.addTest(new Test("a:subj a:prop \"\\'string2\\'\"."));
        this.addTest(new Test("a:subj a:prop \"\\\"string2\\\"\"."));
        this.addTest(new Test("a:subj a:prop '\\'string1\\''."));
        this.addTest(new Test("a:subj a:prop '\\\"string1\\\"'."));
        this.addTest(new Test("a:q21 a:prop \"\"\"start\"finish\"\"\"."));
        this.addTest(new Test("a:q22 a:prop \"\"\"start\"\"finish\"\"\"."));
        this.addTest(new Test("a:q2e3 a:prop \"\"\"start\\\"\\\"\\\"finish\"\"\"."));
        this.addTest(new Test("a:q13 a:prop \"\"\"start'''finish\"\"\"."));
        this.addTest(new Test("a:q11 a:prop '''start'finish'''."));
        this.addTest(new Test("a:q12 a:prop '''start''finish'''."));
        this.addTest(new Test("a:q12 a:prop '''start\\'\\'\\'finish'''."));
        this.addTest(new Test("a:q23 a:prop '''start\"\"\"finish'''."));
        this.addTest(new Test("a:subj <a>  x:y ."));
        this.addTest(new Test("<this>  a   x:y ."));
        this.addTest(new Test("@prefix has: <uri>."));
        this.addTest(new Test("<>   a:prop  x:y ."));
        this.addTest(new Test("<#>  a:prop  x:y ."));
        this.addTest(new Test("a:subj a:prop a:d, a:e."));
        this.addTest(new Test("a:subj a:prop a:d, '123'."));
        this.addTest(new Test("a:subj a:prop '123', a:e."));
        this.addTest(new Test("a:subj a:p1 a:v1 ;  a:p2 a:v2 ."));
        this.addTest(new Test("a:subj a:p1 a:v1, a:v2 ;  a:p2 a:v2 ; a:p3 'v4' ,'v5' ."));
        this.addTest(new Test("a:subj a:p1 a:v1; ."));
        this.addTest(new Test("a:subj a:p1 a:v1; a:p2 a:v2; ."));
        this.addTest(new Test("[a:prop a:val]."));
        this.addTest(new Test("[] a:prop a:val."));
        this.addTest(new Test("[] a:prop []."));
        this.addTest(new Test("<here> <list> ()."));
        this.addTest(new Test(" ( a:i1 a:i2 a:i3 ) a rdf:List."));
        this.addTest(new Test("a:subj a:prop '123'^^xsd:integer ."));
        this.addTest(new Test("a:subj a:prop '123'^^<uri> ."));
        this.addTest(new Test("a:subj a:prop '<tag>text</tag>'^^rdf:XMLLiteral ."));
        this.addTest(new Test("a:subj a:prop 123 ."));
        this.addTest(new Test("a:subj a:prop 123.1 ."));
        this.addTest(new Test("a:subj a:prop -123.1 ."));
        this.addTest(new Test("a:subj a:prop 123.1e3 ."));
        this.addTest(new Test("a:subj a:prop 123.1e-3 ."));
        this.addTest(new Test("a:subj a:prop 123.1E3 ."));
        this.addTest(new Test("a:subj a:prop 123.1E-3 ."));
        this.addTest(new Test("a:subj a:prop 'text'@en ."));
        this.addTest(new Test("a:subj a:prop '<tag>text</tag>'^^rdf:XMLLiteral ."));
        this.addTest(new Test("a:subj a:prop '\u00e9'."));
        this.addTest(new Test("a:subj a:prop ';1'."));
        this.addTest(new Test("\u00e9:subj a:prop '\u00e9'."));
        this.addTest(new Test("a:subj-\u00e9 a:prop '\u00e9'."));
        this.addTest(new Test("\u03b1:subj a:prop '\u03b1'."));
        this.addTest(new Test("a:subj-\u03b1 a:prop '\u03b1'."));
    }

    static class Test
    extends TestCase {
        String testString;

        Test(String s) {
            super(TestUtils.safeName(s));
            this.testString = s;
        }

        protected void runTest() throws Throwable {
            TurtleParser parser = new TurtleParser(new StringReader(this.testString));
            parser.setEventHandler(new TurtleEventNull());
            parser.getPrefixMapping().setNsPrefix("a", "http://host/a#");
            parser.getPrefixMapping().setNsPrefix("x", "http://host/a#");
            parser.getPrefixMapping().setNsPrefix("\u00e9", "http://host/e-acute/");
            parser.getPrefixMapping().setNsPrefix("\u03b1", "http://host/alpha/");
            parser.getPrefixMapping().setNsPrefix("", "http://host/");
            parser.getPrefixMapping().setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            parser.getPrefixMapping().setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
            parser.setBaseURI("http://base/");
            parser.parse();
        }
    }
}

