/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.NodeToTriplesMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestSuite;

public class TestNodeToTriplesMap
extends GraphTestBase {
    protected NodeToTriplesMap ntS = new NodeToTriplesMap(Triple.Field.getSubject, Triple.Field.getPredicate, Triple.Field.getObject);
    protected NodeToTriplesMap ntP = new NodeToTriplesMap(Triple.Field.getPredicate, Triple.Field.getObject, Triple.Field.getSubject);
    protected NodeToTriplesMap ntO = new NodeToTriplesMap(Triple.Field.getObject, Triple.Field.getPredicate, Triple.Field.getSubject);
    protected static final Node x = TestNodeToTriplesMap.node("x");
    protected static final Node y = TestNodeToTriplesMap.node("y");

    public TestNodeToTriplesMap(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNodeToTriplesMap.class);
    }

    public void testZeroSize() {
        this.testZeroSize("fresh NTM", this.ntS);
    }

    protected void testZeroSize(String title, NodeToTriplesMap nt) {
        TestNodeToTriplesMap.assertEquals(title + " should have size 0", 0, nt.size());
        TestNodeToTriplesMap.assertEquals(title + " should be isEmpty()", true, nt.isEmpty());
        TestNodeToTriplesMap.assertEquals(title + " should have empty domain", false, nt.domain().hasNext());
    }

    public void testAddOne() {
        this.ntS.add(TestNodeToTriplesMap.triple("x P y"));
        this.testJustOne(x, this.ntS);
    }

    public void testAddOneTwice() {
        this.addTriples(this.ntS, "x P y; x P y");
        this.testJustOne(x, this.ntS);
    }

    protected void testJustOne(Node x, NodeToTriplesMap nt) {
        TestNodeToTriplesMap.assertEquals(1, nt.size());
        TestNodeToTriplesMap.assertEquals(false, nt.isEmpty());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.just(x), TestNodeToTriplesMap.iteratorToSet(nt.domain()));
    }

    public void testAddTwoUnshared() {
        this.addTriples(this.ntS, "x P a; y Q b");
        TestNodeToTriplesMap.assertEquals(2, this.ntS.size());
        TestNodeToTriplesMap.assertEquals(false, this.ntS.isEmpty());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.both(x, y), TestNodeToTriplesMap.iteratorToSet(this.ntS.domain()));
    }

    public void testAddTwoShared() {
        this.addTriples(this.ntS, "x P a; x Q b");
        TestNodeToTriplesMap.assertEquals(2, this.ntS.size());
        TestNodeToTriplesMap.assertEquals(false, this.ntS.isEmpty());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.just(x), TestNodeToTriplesMap.iteratorToSet(this.ntS.domain()));
    }

    public void testClear() {
        this.addTriples(this.ntS, "x P a; x Q b; y R z");
        this.ntS.clear();
        this.testZeroSize("cleared NTM", this.ntS);
    }

    public void testAllIterator() {
        String triples = "x P b; y P d; y P f";
        this.addTriples(this.ntS, triples);
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet(triples), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll()));
    }

    public void testOneIterator() {
        this.addTriples(this.ntS, "x P b; y P d; y P f");
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P b"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(x, null)));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y P d; y P f"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterator(y, null)));
    }

    public void testRemove() {
        this.addTriples(this.ntS, "x P b; y P d; y R f");
        this.ntS.remove(TestNodeToTriplesMap.triple("y P d"));
        TestNodeToTriplesMap.assertEquals(2, this.ntS.size());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P b; y R f"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll()));
    }

    public void testRemoveByIterator() {
        this.addTriples(this.ntS, "x nice a; a nasty b; x nice c");
        this.addTriples(this.ntS, "y nice d; y nasty e; y nice f");
        ExtendedIterator it = this.ntS.iterateAll();
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            if (!t.getPredicate().equals(TestNodeToTriplesMap.node("nasty"))) continue;
            it.remove();
        }
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x nice a; x nice c; y nice d; y nice f"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll()));
    }

    public void testIteratorWIthPatternOnEmpty() {
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet(""), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll(TestNodeToTriplesMap.triple("a P b"))));
    }

    public void testIteratorWIthPatternOnSomething() {
        this.addTriples(this.ntS, "x P a; y P b; y R c");
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll(TestNodeToTriplesMap.triple("x P ??"))));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y P b; y R c"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll(TestNodeToTriplesMap.triple("y ?? ??"))));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a; y P b"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll(TestNodeToTriplesMap.triple("?? P ??"))));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y R c"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll(TestNodeToTriplesMap.triple("?? ?? c"))));
    }

    public void testUnspecificRemoveS() {
        this.addTriples(this.ntS, "x P a; y Q b; z R c");
        this.ntS.remove(TestNodeToTriplesMap.triple("x P a"));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y Q b; z R c"), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll()));
    }

    public void testUnspecificRemoveP() {
        this.addTriples(this.ntP, "x P a; y Q b; z R c");
        this.ntP.remove(TestNodeToTriplesMap.triple("y Q b"));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a; z R c"), TestNodeToTriplesMap.iteratorToSet(this.ntP.iterateAll()));
    }

    public void testUnspecificRemoveO() {
        this.addTriples(this.ntO, "x P a; y Q b; z R c");
        this.ntO.remove(TestNodeToTriplesMap.triple("z R c"));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a; y Q b"), TestNodeToTriplesMap.iteratorToSet(this.ntO.iterateAll()));
    }

    public void testAddBooleanResult() {
        TestNodeToTriplesMap.assertEquals(true, this.ntS.add(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.add(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertEquals(true, this.ntS.add(TestNodeToTriplesMap.triple("y Q z")));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.add(TestNodeToTriplesMap.triple("y Q z")));
        TestNodeToTriplesMap.assertEquals(true, this.ntS.add(TestNodeToTriplesMap.triple("y R s")));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.add(TestNodeToTriplesMap.triple("y R s")));
    }

    public void testRemoveBooleanResult() {
        TestNodeToTriplesMap.assertEquals(false, this.ntS.remove(TestNodeToTriplesMap.triple("x P y")));
        this.ntS.add(TestNodeToTriplesMap.triple("x P y"));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.remove(TestNodeToTriplesMap.triple("x Q y")));
        TestNodeToTriplesMap.assertEquals(true, this.ntS.remove(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertEquals(false, this.ntS.remove(TestNodeToTriplesMap.triple("x P y")));
    }

    public void testContains() {
        this.addTriples(this.ntS, "x P y; a P b");
        TestNodeToTriplesMap.assertTrue(this.ntS.contains(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertTrue(this.ntS.contains(TestNodeToTriplesMap.triple("a P b")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("x P z")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("y P y")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("x R y")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("e T f")));
        TestNodeToTriplesMap.assertFalse(this.ntS.contains(TestNodeToTriplesMap.triple("_x F 17")));
    }

    protected void addTriples(NodeToTriplesMap nt, String facts) {
        Triple[] t = TestNodeToTriplesMap.tripleArray(facts);
        for (int i = 0; i < t.length; ++i) {
            nt.add(t[i]);
        }
    }

    protected static Set just(Object x) {
        HashSet<Object> result = new HashSet<Object>();
        result.add(x);
        return result;
    }

    protected static Set both(Object x, Object y) {
        Set result = TestNodeToTriplesMap.just(x);
        result.add(y);
        return result;
    }
}

