/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestLiteralLabels
extends GraphTestBase {
    public TestLiteralLabels(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestLiteralLabels.class);
    }

    public void testHashCode() {
        LiteralLabel ll = new LiteralLabel((Object)"test", "", null);
        ll.hashCode();
    }

    public void testHashCode2() {
        LiteralLabel ll = new LiteralLabel((Object)"test", "", null);
        ll.hashCode();
    }

    public void testHashCodesForBase64Binary() {
        LiteralLabel A = TestLiteralLabels.node("'0123'http://www.w3.org/2001/XMLSchema#base64Binary").getLiteral();
        LiteralLabel B = TestLiteralLabels.node("'0123'http://www.w3.org/2001/XMLSchema#base64Binary").getLiteral();
        TestLiteralLabels.assertEquals(A.hashCode(), B.hashCode());
    }

    public void testHashCodesForHexBinary() {
        LiteralLabel A = TestLiteralLabels.node("'0123'http://www.w3.org/2001/XMLSchema#hexBinary").getLiteral();
        LiteralLabel B = TestLiteralLabels.node("'0123'http://www.w3.org/2001/XMLSchema#hexBinary").getLiteral();
        TestLiteralLabels.assertEquals(A.hashCode(), B.hashCode());
    }

    public void testEquality1() {
        LiteralLabel A = new LiteralLabel("xyz");
        LiteralLabel B = new LiteralLabel("xyz");
        TestLiteralLabels.assertTrue(A.equals(B));
        TestLiteralLabels.assertTrue(A.sameValueAs(B));
        TestLiteralLabels.assertEquals(A.hashCode(), B.hashCode());
    }

    public void testEquality2() {
        LiteralLabel A = new LiteralLabel("xyz");
        LiteralLabel B = new LiteralLabel("XYZ");
        TestLiteralLabels.assertFalse(A.equals(B));
        TestLiteralLabels.assertFalse(A.sameValueAs(B));
    }

    public void testEquality3() {
        LiteralLabel A = new LiteralLabel("xyz", "en-us");
        LiteralLabel B = new LiteralLabel("xyz", "en-uk");
        TestLiteralLabels.assertFalse(A.equals(B));
        TestLiteralLabels.assertFalse(A.sameValueAs(B));
    }

    public void testEquality4() {
        LiteralLabel A = new LiteralLabel("xyz", "en-UK");
        LiteralLabel B = new LiteralLabel("xyz", "en-uk");
        TestLiteralLabels.assertFalse(A.equals(B));
        TestLiteralLabels.assertTrue(A.sameValueAs(B));
    }
}

