/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.graph.test.AbstractTestGraphMaker;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.util.HashSet;
import junit.framework.TestSuite;

public class TestFileGraphMaker
extends AbstractTestGraphMaker {
    public TestFileGraphMaker(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileGraphMaker.class);
    }

    public GraphMaker getGraphMaker() {
        String scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker").getPath();
        return new FileGraphMaker(scratch, ReificationStyle.Minimal, true);
    }

    public void testToFilename() {
        TestFileGraphMaker.assertEquals("plain", FileGraphMaker.toFilename("plain"));
        TestFileGraphMaker.assertEquals("with_Sslash", FileGraphMaker.toFilename("with/slash"));
        TestFileGraphMaker.assertEquals("with_Ccolon", FileGraphMaker.toFilename("with:colon"));
        TestFileGraphMaker.assertEquals("with_Uunderbar", FileGraphMaker.toFilename("with_underbar"));
        TestFileGraphMaker.assertEquals("with_Stwo_Sslashes", FileGraphMaker.toFilename("with/two/slashes"));
        TestFileGraphMaker.assertEquals("with_Sa_Cmixture_U...", FileGraphMaker.toFilename("with/a:mixture_..."));
    }

    public void testToGraphname() {
        TestFileGraphMaker.assertEquals("plain", FileGraphMaker.toGraphname("plain"));
        TestFileGraphMaker.assertEquals("with/slash", FileGraphMaker.toGraphname("with_Sslash"));
        TestFileGraphMaker.assertEquals("with:colon", FileGraphMaker.toGraphname("with_Ccolon"));
        TestFileGraphMaker.assertEquals("with_underbar", FileGraphMaker.toGraphname("with_Uunderbar"));
        TestFileGraphMaker.assertEquals("a/mixture_of:things", FileGraphMaker.toGraphname("a_Smixture_Uof_Cthings"));
        TestFileGraphMaker.assertEquals("with/two/slashes", FileGraphMaker.toGraphname("with_Stwo_Sslashes"));
    }

    public void testDetectsExistingFiles() {
        File scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-already");
        Graph content = TestFileGraphMaker.graphWith("something hasProperty someValue");
        FileGraphMaker A = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        FileGraphMaker B = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        FileGraph gA = (FileGraph)A.createGraph("already", true);
        gA.getBulkUpdateHandler().add(content);
        gA.close();
        FileGraph gB = (FileGraph)B.openGraph("already", false);
        TestFileGraphMaker.assertIsomorphic(content, gB);
        gB.close();
        gB.delete();
        gA.delete();
    }

    public void testDeletesFilesOfClosedMaker() {
        File scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-forgets");
        FileGraphMaker A = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        A.createGraph("empty").close();
        TestFileGraphMaker.assertTrue("file 'empty' should exist in '" + scratch + "'", new File(scratch, "empty").exists());
        A.close();
        TestFileGraphMaker.assertFalse("file 'empty' should no longer exist in '" + scratch + "'", new File(scratch, "empty").exists());
    }

    public void testForgetsClosedGraphs() {
        File scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-forgets");
        FileGraphMaker m = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        m.createGraph("example").close();
        TestFileGraphMaker.assertEquals(new HashSet(), TestFileGraphMaker.iteratorToSet(m.listGraphs()));
        m.close();
    }

    public void testDoesntReusedClosedGraphs() {
        File scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-noReuse");
        FileGraphMaker m = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        Graph m1 = m.createGraph("hello");
        m1.close();
        Graph m2 = m.createGraph("hello");
        TestFileGraphMaker.assertNotSame(m1, m2);
        m2.add(TestFileGraphMaker.triple("this graph isOpen"));
        m.close();
    }
}

